/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.tiles.TileBarbecueRack;
import snownee.cuisine.tiles.TileFirePit;
import snownee.cuisine.tiles.TileWok;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockModHorizontal;
import snownee.kiwi.util.AABBUtil;
import snownee.kiwi.util.OreUtil;

public class BlockFirePit
extends BlockModHorizontal {
    public static final PropertyEnum<Component> COMPONENT = PropertyEnum.func_177709_a((String)"component", Component.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB AABB_WITH_WOK = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.475, 1.0);
    private static final AxisAlignedBB AABB_STICKS = new AxisAlignedBB(0.4, 0.0, 0.0, 0.6, 1.0, 1.0);

    public BlockFirePit(String name) {
        super(name, Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a(COMPONENT, (Comparable)((Object)Component.NONE)));
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_149715_a(0.9375f);
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        Item item = Item.func_150898_a((Block)this);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "fire_pit"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "wok"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "bbq_rack"));
    }

    public int getItemSubtypeAmount() {
        return 3;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.hasComponent(state, Component.WOK) ? AABB_WITH_WOK : AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        if (this.hasComponent(state, Component.STICKS)) {
            BlockFirePit.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABBUtil.rotate((AxisAlignedBB)AABB_STICKS, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D))));
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult result;
        if (this.hasComponent(state, Component.STICKS) && (result = this.func_185503_a(pos, start, end, AABBUtil.rotate((AxisAlignedBB)AABB_STICKS, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D))))) != null && result.field_72313_a != RayTraceResult.Type.MISS) {
            return result;
        }
        return super.func_180636_a(state, worldIn, pos, start, end);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() == CuisineRegistry.WOK && this.hasComponent(state, Component.NONE)) {
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)playerIn.func_174811_aO().func_176734_d()).func_177226_a(COMPONENT, (Comparable)((Object)Component.WOK)));
            return true;
        }
        if (OreUtil.doesItemHaveOreName((ItemStack)stack, (String)"stickWood") && stack.func_190916_E() >= 3 && this.hasComponent(state, Component.NONE)) {
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(3);
            }
            worldIn.func_175656_a(pos, state.func_177226_a(COMPONENT, (Comparable)((Object)Component.STICKS)));
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (stack.func_77973_b() == CuisineRegistry.FAN) {
            return false;
        }
        if (hand == EnumHand.MAIN_HAND && this.hasComponent(state, Component.WOK)) {
            if (tile instanceof TileWok) {
                if (!worldIn.field_72995_K && playerIn instanceof EntityPlayerMP) {
                    ((TileWok)tile).onActivated((EntityPlayerMP)playerIn, hand, facing);
                }
                return true;
            }
        } else if (hand == EnumHand.MAIN_HAND && this.hasComponent(state, Component.STICKS) && tile instanceof TileBarbecueRack) {
            TileBarbecueRack teBR = (TileBarbecueRack)tile;
            if (teBR.stacks.isItemValid(3, stack)) {
                ItemStack remain = teBR.stacks.insertItem(3, stack, false);
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184611_a(hand, remain);
                }
            } else if (!worldIn.field_72995_K) {
                ArrayList aabbs = Lists.newArrayList();
                EnumFacing facing2 = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                AxisAlignedBB aabbItem = AABBUtil.rotate((AxisAlignedBB)new AxisAlignedBB(0.3, 0.5, 0.2, 0.7, 0.9, 0.4), (EnumFacing)facing2);
                AxisAlignedBB aabbEmpty = AABBUtil.rotate((AxisAlignedBB)new AxisAlignedBB(0.45, 0.65, 0.2, 0.55, 0.75, 0.4), (EnumFacing)facing2);
                for (int i = 0; i < 3; ++i) {
                    aabbs.add((teBR.stacks.getStackInSlot(2 - i).func_190926_b() ? aabbEmpty : aabbItem).func_72317_d((double)facing2.func_176730_m().func_177958_n() * 0.2 * (double)i, 0.0, (double)facing2.func_176734_d().func_176730_m().func_177952_p() * 0.2 * (double)i).func_186670_a(pos));
                }
                int result = AABBUtil.rayTraceByDistance((EntityPlayer)playerIn, (List)aabbs);
                if (result != -1) {
                    ItemStack stackSlot = teBR.stacks.extractItem(result = 2 - result, Integer.MAX_VALUE, false);
                    if (stackSlot.func_190926_b()) {
                        if (!stack.func_190926_b()) {
                            ItemStack remain = teBR.stacks.insertItem(result, playerIn.func_184812_l_() ? stack.func_77946_l() : stack, false);
                            if (!playerIn.func_184812_l_()) {
                                playerIn.func_184611_a(hand, remain);
                            }
                        }
                    } else {
                        EntityItem entityitem = new EntityItem(worldIn, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), stackSlot);
                        entityitem.field_70159_w = 0.0;
                        entityitem.field_70181_x = 0.0;
                        entityitem.field_70179_y = 0.0;
                        worldIn.func_72838_d((Entity)entityitem);
                        if (!(playerIn instanceof FakePlayer)) {
                            entityitem.func_70100_b_(playerIn);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileBarbecueRack) {
            StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)((TileBarbecueRack)tileentity).stacks, true);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Block)CuisineRegistry.FIRE_PIT));
        if (this.hasComponent(state, Component.WOK)) {
            drops.add((Object)new ItemStack((Item)CuisineRegistry.WOK));
        } else if (this.hasComponent(state, Component.STICKS)) {
            drops.add((Object)new ItemStack(Items.field_151055_y, 3));
        }
    }

    public int func_180651_a(IBlockState state) {
        switch ((Component)((Object)state.func_177229_b(COMPONENT))) {
            default: {
                return 0;
            }
            case WOK: {
                return 1;
            }
            case STICKS: 
        }
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileEntity;
        int heatLevel = 1;
        if (stateIn.func_177229_b(COMPONENT) != Component.NONE && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileFirePit) {
            heatLevel = ((TileFirePit)tileEntity).heatHandler.getLevel();
        }
        if (heatLevel > 0 && rand.nextInt(15 - heatLevel * 3) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.7f + 0.15f * (float)heatLevel + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < heatLevel; ++i) {
            float f = (float)((double)rand.nextFloat() * Math.PI * 2.0);
            double x = (double)MathHelper.func_76126_a((float)f) * 0.1;
            double y = (double)pos.func_177956_o() + 0.12 + rand.nextDouble() * 0.05;
            double z = (double)MathHelper.func_76134_b((float)f) * 0.1;
            if (!this.hasComponent(stateIn, Component.WOK)) {
                if (heatLevel > 1) {
                    worldIn.func_190523_a(EnumParticleTypes.FLAME.func_179348_c(), (double)pos.func_177958_n() + 0.5 + x, y, (double)pos.func_177952_p() + 0.5 + z, x * 0.2, 0.01 * (double)heatLevel, z * 0.2, new int[0]);
                    continue;
                }
                worldIn.func_190523_a(EnumParticleTypes.FLAME.func_179348_c(), (double)pos.func_177958_n() + 0.5 + x, y, (double)pos.func_177952_p() + 0.5 + z, 0.0, 0.0, 0.0, new int[0]);
                continue;
            }
            if (heatLevel > 1) {
                worldIn.func_190523_a(EnumParticleTypes.FLAME.func_179348_c(), (double)pos.func_177958_n() + 0.5 + x, y, (double)pos.func_177952_p() + 0.5 + z, x * 0.2 * ((double)heatLevel - 0.5), 0.005, z * 0.2 * (double)(heatLevel - 1), new int[0]);
            }
            if (rand.nextInt(5) != 0) continue;
            worldIn.func_190523_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), (double)pos.func_177958_n() + 0.5 + x * rand.nextDouble() * 0.5, y + 0.2, (double)pos.func_177952_p() + 0.5 + z * rand.nextDouble() * 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean hasComponent(IBlockState state, Component component) {
        return state.func_177229_b(COMPONENT) == component;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (meta >= 0 && meta < Component.values().length) {
            state = state.func_177226_a(COMPONENT, (Comparable)((Object)Component.values()[meta]));
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a(COMPONENT, (Comparable)((Object)Component.values()[MathHelper.func_76125_a((int)(meta / 4), (int)0, (int)(Component.values().length - 1))]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b() + ((Component)((Object)state.func_177229_b(COMPONENT))).ordinal() * 4;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, COMPONENT});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return !this.hasComponent(state, Component.NONE);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((Component)((Object)state.func_177229_b(COMPONENT))) {
            case WOK: {
                return new TileWok();
            }
            case STICKS: {
                return new TileBarbecueRack();
            }
        }
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileBarbecueRack) {
            TileBarbecueRack teBR = (TileBarbecueRack)te;
            int output = 0;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = teBR.stacks.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                output += teBR.stacks.isItemValid(0, stack) ? 1 : 5;
            }
            return output;
        }
        return 0;
    }

    public static enum Component implements IStringSerializable
    {
        NONE,
        WOK,
        STICKS;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

