/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import snownee.cuisine.Cuisine;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.client.model.DrinkroMeshDefinition;
import snownee.cuisine.tiles.TileDrinkroBase;
import snownee.cuisine.tiles.TileDrinkroTank;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockModHorizontal;
import snownee.kiwi.tile.TileBase;
import snownee.kiwi.util.PlayerUtil;

public class BlockDrinkro
extends BlockModHorizontal {
    public static final PropertyBool NORMAL = PropertyBool.func_177716_a((String)"normal");
    public static final PropertyBool BASE = PropertyBool.func_177716_a((String)"base");
    public static final PropertyBool WORKING = PropertyBool.func_177716_a((String)"working");
    private static final AxisAlignedBB LOWER_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    private static final AxisAlignedBB UPPER_BLOCK_AABB = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);

    public BlockDrinkro(String name) {
        super(name, Material.field_151573_f);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORMAL, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        Item item = Item.func_150898_a((Block)this);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)DrinkroMeshDefinition.INSTANCE);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("cuisine", "drinkro"), new ResourceLocation("cuisine", "drinkro_special")});
    }

    public void func_149666_a(CreativeTabs itemGroup, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    public boolean hasItem() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)BASE) != false ? LOWER_BLOCK_AABB : UPPER_BLOCK_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a());
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos pos2;
        IBlockState state2;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null) {
            StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), true);
        }
        if ((state2 = worldIn.func_180495_p(pos2 = (Boolean)state.func_177229_b((IProperty)BASE) != false ? pos.func_177984_a() : pos.func_177977_b())).func_177230_c() == this && state2.func_177229_b((IProperty)BASE) != state.func_177229_b((IProperty)BASE)) {
            worldIn.func_175698_g(pos2);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)this.getItemInternal(state));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItemInternal(state);
    }

    private ItemStack getItemInternal(IBlockState state) {
        ItemStack stack = new ItemStack((Block)this);
        if (!((Boolean)state.func_177229_b((IProperty)NORMAL)).booleanValue()) {
            stack.func_151001_c("SCP-294");
        }
        return stack;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileBase tileDrinkro;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile == null) {
            return true;
        }
        ItemStack held = playerIn.func_184586_b(hand);
        if (held.func_77973_b() != Items.field_151069_bo) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1));
            IFluidHandler container = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            if (handler != null && container != null) {
                FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)container);
                return true;
            }
        }
        ItemStackHandler inv = null;
        if (tile instanceof TileDrinkroBase) {
            tileDrinkro = (TileDrinkroBase)tile;
            inv = tileDrinkro.inventory;
        } else if (tile instanceof TileDrinkroTank) {
            Ingredient ingredient;
            tileDrinkro = (TileDrinkroTank)tile;
            if (tileDrinkro.builder != null && (ingredient = CulinaryHub.API_INSTANCE.findIngredient(held)) != null && ingredient.getForm() == Form.JUICE) {
                tileDrinkro.builder.addIngredient(playerIn, ingredient, (CookingVessel)tileDrinkro);
                ItemStack container = held.func_77973_b().getContainerItem(held);
                if (!playerIn.func_184812_l_()) {
                    held.func_190918_g(1);
                } else if (!container.func_190926_b()) {
                    PlayerUtil.mergeItemStack((ItemStack)container, (EntityPlayer)playerIn, (EnumHand)hand);
                }
                return true;
            }
            inv = tileDrinkro.inventory;
        }
        if (inv != null) {
            if (held.func_190926_b() || ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)held, (boolean)true).func_190916_E() == held.func_190916_E()) {
                for (int i = inv.getSlots() - 1; i >= 0; --i) {
                    ItemStack stack = inv.getStackInSlot(i);
                    if (!(playerIn instanceof FakePlayer) && stack.hasCapability(CulinaryCapabilities.FOOD_CONTAINER, null)) {
                        playerIn.openGui((Object)Cuisine.getInstance(), 1, worldIn, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                    } else {
                        if (stack.func_190926_b()) continue;
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)stack);
                        inv.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    break;
                }
            } else {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (!inv.getStackInSlot(i).func_190926_b()) continue;
                    ItemStack ramain = inv.insertItem(i, held, false);
                    if (playerIn.func_184812_l_()) break;
                    playerIn.func_184611_a(hand, ramain);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile;
        if (!((Boolean)state.func_177229_b((IProperty)BASE)).booleanValue() && (tile = worldIn.func_175625_s(pos)) instanceof TileDrinkroTank) {
            TileDrinkroTank tileDrinkro = (TileDrinkroTank)tile;
            state = state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(tileDrinkro.isWorking()));
        }
        return state;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int color) {
        if (id == 0) {
            pos = pos.func_177977_b();
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int j = 0; j < 30; ++j) {
                worldIn.func_190523_a(EnumParticleTypes.SPELL_MOB.func_179348_c(), (double)pos.func_177958_n() + RANDOM.nextDouble(), (double)pos.func_177956_o() + RANDOM.nextDouble(), (double)pos.func_177952_p() + RANDOM.nextDouble(), r, g, b, new int[0]);
            }
            return true;
        }
        if (id == 1) {
            BlockDrinkro.spawnWorkingParticles(worldIn, pos);
            return true;
        }
        return false;
    }

    private static void spawnWorkingParticles(World world, BlockPos pos) {
        for (int j = 0; j < 10; ++j) {
            world.func_190523_a(EnumParticleTypes.CRIT.func_179348_c(), (double)pos.func_177958_n() + RANDOM.nextDouble() * 0.4 + 0.3, (double)pos.func_177956_o() + RANDOM.nextDouble() * 0.4 + 0.3, (double)pos.func_177952_p() + RANDOM.nextDouble() * 0.4 + 0.3, RANDOM.nextDouble() * 2.0 - 1.0, RANDOM.nextDouble() * 2.0 - 1.0, RANDOM.nextDouble() * 2.0 - 1.0, new int[0]);
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BASE) != false ? new TileDrinkroBase() : new TileDrinkroTank();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (((Boolean)state.func_177229_b((IProperty)BASE)).booleanValue()) {
            pos = pos.func_177984_a();
            state = worldIn.func_180495_p(pos);
        }
        if ((tile = worldIn.func_175625_s(pos)) instanceof TileDrinkroTank) {
            ((TileDrinkroTank)tile).neighborChanged(state);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileDrinkroTank tileDrinkro;
        if (((Boolean)state.func_177229_b((IProperty)BASE)).booleanValue()) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileDrinkroTank && (tileDrinkro = (TileDrinkroTank)tile).isWorking()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.FALSE));
            worldIn.func_175656_a(pos.func_177977_b(), worldIn.func_180495_p(pos.func_177977_b()).func_177226_a((IProperty)WORKING, (Comparable)Boolean.FALSE));
            tileDrinkro.stopProcess();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BASE) != false ? EnumBlockRenderType.MODEL : EnumBlockRenderType.INVISIBLE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WORKING)).booleanValue() && !((Boolean)stateIn.func_177229_b((IProperty)BASE)).booleanValue()) {
            BlockDrinkro.spawnWorkingParticles(worldIn, pos);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)NORMAL, (Comparable)Boolean.valueOf(meta == 0));
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)NORMAL, (Comparable)Boolean.valueOf((meta & 7) < 4)).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(meta < 8));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) + ((Boolean)state.func_177229_b((IProperty)NORMAL) != false ? 0 : 4) + ((Boolean)state.func_177229_b((IProperty)BASE) != false ? 0 : 8);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, NORMAL, WORKING, BASE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BASE);
    }

    public boolean func_149721_r(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BASE) == false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return (Boolean)state.func_177229_b((IProperty)BASE) != false && state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == face ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }
}

