/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import snownee.cuisine.blocks.BlockCuisineCrops;
import snownee.kiwi.util.definition.ItemDefinition;

public class BlockDoubleCrops
extends BlockCuisineCrops {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)8);

    public BlockDoubleCrops(String name, ItemDefinition crop) {
        super(name, crop);
    }

    public boolean isUpper(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) == 8;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.isUpper(state)) {
            super.func_180650_b(worldIn, pos, state, rand);
        }
    }

    @Override
    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            BlockDoubleCrops blockDown;
            boolean upper = this.isUpper(state);
            BlockPos posUp = upper ? pos : pos.func_177984_a();
            BlockPos posDown = upper ? pos.func_177977_b() : pos;
            BlockDoubleCrops blockUp = upper ? this : worldIn.func_180495_p(posUp).func_177230_c();
            BlockDoubleCrops blockDoubleCrops = blockDown = upper ? worldIn.func_180495_p(posDown).func_177230_c() : this;
            if (!upper) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            if (blockUp == this) {
                worldIn.func_180501_a(posUp, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (blockDown == this) {
                worldIn.func_180501_a(posDown, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    @Override
    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.canBlockStay(worldIn, pos, state);
        }
        if (this.isUpper(state)) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        return worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this && super.canBlockStay(worldIn, pos, state);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this.isUpper(state)) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (player.field_71075_bZ.field_75098_d) {
                    worldIn.func_175698_g(pos.func_177977_b());
                } else {
                    worldIn.func_175655_b(pos.func_177977_b(), true);
                }
            }
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!this.isUpper(state)) {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    @Override
    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        super.func_176474_b(worldIn, rand, this.isUpper(state) ? pos.func_177977_b() : pos, this.getPlantBase(state, (IBlockAccess)worldIn, pos));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && !this.isUpper(state) && (worldIn.func_175623_d(pos.func_177984_a()) || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this)) {
            worldIn.func_180501_a(pos.func_177984_a(), this.withAge(8), 2);
        }
    }

    @Override
    public PropertyInteger getAgeProperty() {
        return AGE;
    }

    @Override
    public int getAge(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Integer)this.getPlantBase(state, world, pos).func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState getPlantBase(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState newState;
        if (this.isUpper(state) && (newState = world.func_180495_p(pos.func_177977_b())).func_177230_c() == this && !this.isUpper(newState)) {
            return newState;
        }
        return state;
    }
}

