/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.Cuisine;
import snownee.cuisine.blocks.BlockCorn;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.library.RarityManager;
import snownee.kiwi.block.BlockMod;
import snownee.kiwi.util.definition.ItemDefinition;

public class BlockCuisineCrops
extends BlockMod
implements IGrowable,
IPlantable {
    private final EnumPlantType plantType;
    private final ItemDefinition seed;
    private final ItemDefinition crop;

    public BlockCuisineCrops(String name, ItemDefinition crop) {
        this(name, crop, crop);
    }

    public BlockCuisineCrops(String name, ItemDefinition crop, ItemDefinition seed) {
        this(name, EnumPlantType.Crop, crop, seed);
    }

    public BlockCuisineCrops(String name, EnumPlantType plantType, ItemDefinition crop) {
        this(name, plantType, crop, crop);
    }

    public BlockCuisineCrops(String name, EnumPlantType plantType, ItemDefinition crop, ItemDefinition seed) {
        super(name, Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_149675_a(true);
        this.func_149649_H();
        this.plantType = plantType;
        this.crop = crop;
        this.seed = seed;
    }

    public boolean hasItem() {
        return false;
    }

    public String func_149739_a() {
        return this.getCrop().getItemStack().func_77977_a();
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        boolean lightSufficient = worldIn.func_175699_k(pos) >= 8;
        boolean exposedUnderSunlight = worldIn.func_175710_j(pos);
        return (lightSufficient || exposedUnderSunlight) && this.canSustain(worldIn, pos, worldIn.func_180495_p(pos.func_177977_b()));
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    protected boolean canSustain(World world, BlockPos pos, IBlockState state) {
        IBlockState soilState = world.func_180495_p(pos.func_177977_b());
        if (this.getPlantType((IBlockAccess)world, pos) == EnumPlantType.Water) {
            if (soilState.func_177230_c() != Blocks.field_150355_j && soilState.func_177230_c() != Blocks.field_150358_i) {
                return false;
            }
            if (soilState.func_177227_a().contains(BlockLiquid.field_176367_b) && (Integer)soilState.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                return false;
            }
            soilState = world.func_180495_p(pos.func_177979_c(2));
            return soilState.func_185904_a() == Material.field_151578_c || soilState.func_185904_a() == Material.field_151577_b;
        }
        return soilState.func_177230_c().canSustainPlant(soilState, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public ItemDefinition getSeed() {
        return this.seed;
    }

    public ItemDefinition getCrop() {
        return this.crop;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)this.getSeed().getItemStack());
        int age = this.getAge(state, world, pos);
        if (age == this.getMaxAge()) {
            for (int i = 0; i < EnumRarity.EPIC.ordinal() - this.getCrop().getItemStack().func_77953_t().ordinal() + 2; ++i) {
                if (RANDOM.nextInt(2 * this.getMaxAge()) > age) continue;
                drops.add((Object)this.getCrop().getItemStack());
            }
            if (this.getCrop().getItemStack().func_77973_b() instanceof ItemBasicFood && RANDOM.nextInt(99) < (1 + age - this.getMaxAge()) * 10) {
                ItemStack stack = this.getCrop().getItemStack();
                RarityManager.setRarity(stack, this.getCrop().getItemStack().func_77953_t().ordinal() + 1);
                drops.add((Object)stack);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int i;
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.getPlantType((IBlockAccess)worldIn, pos) == EnumPlantType.Water) {
            this.checkAndDropBlock(worldIn, pos, state);
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.getAge(state, (IBlockAccess)worldIn, pos)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / (f = BlockCuisineCrops.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)3);
    }

    public PropertyInteger getAgeProperty() {
        return BlockCrops.field_176488_a;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state, World world, BlockPos pos) {
        return this.getAge(state, (IBlockAccess)world, pos) == this.getMaxAge();
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state, worldIn, pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state, (IBlockAccess)worldIn, pos) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
        if (state.func_177230_c() instanceof BlockCorn && i > 1) {
            worldIn.func_180501_a(pos.func_177984_a(), this.withAge(8), 2);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getAgeProperty()});
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.plantType;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Blocks.field_150464_aj.func_185496_a(state, source, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getSeed().getItemStack();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }
}

