/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockDoubleCrops;
import snownee.cuisine.items.ItemCrops;
import snownee.kiwi.util.definition.ItemDefinition;

public class BlockCorn
extends BlockDoubleCrops {
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockCorn(String name) {
        super(name, ItemDefinition.of((ItemStack)CuisineRegistry.CROPS.getItemStack(ItemCrops.Variant.CORN)));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState state2;
        if (this.isUpper(state) && (state2 = source.func_180495_p(pos.func_177977_b())).func_177230_c() == this && !this.isUpper(state2)) {
            return CROPS_AABB[(Integer)state2.func_177229_b((IProperty)this.getAgeProperty())];
        }
        return field_185505_j;
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState target = state;
        if (this.isUpper(target) && ((target = worldIn.func_180495_p(pos = pos.func_177977_b())).func_177230_c() != this || this.isUpper(target))) {
            return false;
        }
        BlockPos upPos = pos.func_177984_a();
        IBlockState upState = worldIn.func_180495_p(upPos);
        return !worldIn.func_189509_E(upPos) && (upState.func_177230_c() == this || upState.func_177230_c().func_176200_f((IBlockAccess)worldIn, upPos));
    }

    @Override
    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.canBlockStay(worldIn, pos, state);
        }
        if (this.isUpper(state)) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        return this.getAge(state, (IBlockAccess)worldIn, pos) < 2 || super.canBlockStay(worldIn, pos, state);
    }

    @SubscribeEvent
    public static void onCropsGrowPost(BlockEvent.CropGrowEvent event) {
        IBlockState state = event.getState();
        if (state.func_177230_c() instanceof BlockCorn && ((BlockCorn)state.func_177230_c()).getAge(state, (IBlockAccess)event.getWorld(), event.getPos()) > 1) {
            event.getWorld().func_175656_a(event.getPos().func_177984_a(), ((BlockCorn)state.func_177230_c()).withAge(8));
        }
    }
}

