/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.library.UnlistedPropertyItemStack;
import snownee.cuisine.network.PacketCustomEvent;
import snownee.cuisine.tiles.TileChoppingBoard;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockMod;
import snownee.kiwi.network.NetworkChannel;
import snownee.kiwi.network.PacketMod;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.OreUtil;

@Mod.EventBusSubscriber(modid="cuisine")
public class BlockChoppingBoard
extends BlockMod {
    public static final UnlistedPropertyItemStack COVER_KEY = UnlistedPropertyItemStack.of("cover");
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private static final PropertyBool HAS_KITCHEN_KNIFE = PropertyBool.func_177716_a((String)"kitchen_knife");

    public BlockChoppingBoard(String name) {
        super(name, Material.field_151575_d);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HAS_KITCHEN_KNIFE, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{HAS_KITCHEN_KNIFE, BlockHorizontal.field_185512_D}, new IUnlistedProperty[]{COVER_KEY});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileChoppingBoard) {
            TileChoppingBoard board = (TileChoppingBoard)tile;
            return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)board.getFacing()).func_177226_a((IProperty)HAS_KITCHEN_KNIFE, (Comparable)(board.hasKitchenKnife() ? Boolean.TRUE : Boolean.FALSE));
        }
        return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HAS_KITCHEN_KNIFE, (Comparable)Boolean.FALSE);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileChoppingBoard) {
            return this.func_176221_a((IBlockState)((IExtendedBlockState)state).withProperty((IUnlistedProperty)COVER_KEY, (Object)((TileChoppingBoard)tile).getCover()), world, pos);
        }
        return this.func_176221_a((IBlockState)((IExtendedBlockState)state).withProperty((IUnlistedProperty)COVER_KEY, (Object)ItemStack.field_190927_a), world, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileChoppingBoard) {
            TileChoppingBoard teCB = (TileChoppingBoard)te;
            ItemStack held = playerIn.func_184586_b(hand);
            boolean empty = teCB.stacks.getStackInSlot(0).func_190926_b();
            if (!empty && hand == EnumHand.MAIN_HAND && OreUtil.doesItemHaveOreName((ItemStack)held, (String)"itemFoodCutter")) {
                if (!worldIn.field_72995_K) {
                    NetworkChannel.INSTANCE.sendToAllAround((PacketMod)new PacketCustomEvent(2, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), worldIn.field_73011_w.getDimension(), pos);
                }
                teCB.process(playerIn, held, TileChoppingBoard.ProcessionType.KNIFE_VERTICAL, null);
            } else if (empty) {
                if (hand == EnumHand.MAIN_HAND && teCB.isItemValidForSlot(0, playerIn.func_184592_cb())) {
                    return false;
                }
                teCB.setFacing(playerIn.func_174811_aO());
                if (!worldIn.field_72995_K) {
                    held = teCB.insertItem(playerIn, held);
                    if (!playerIn.func_184812_l_()) {
                        playerIn.func_184611_a(hand, held);
                    }
                }
                worldIn.func_184138_a(pos, state, state, 11);
            } else {
                StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)teCB.stacks, false);
                teCB.resetProcess();
                worldIn.func_184138_a(pos, state, state, 11);
            }
            return true;
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileChoppingBoard) {
            int harvestLevel;
            ItemStack held = playerIn.func_184614_ca();
            if (OreUtil.doesItemHaveOreName((ItemStack)held, (String)"itemFoodCutter")) {
                ((TileChoppingBoard)te).process(playerIn, held, TileChoppingBoard.ProcessionType.KNIFE_HORIZONTAL, null);
            } else if (!worldIn.field_72995_K && CuisineConfig.GENERAL.axeChopping && (double)playerIn.func_184825_o(0.0f) > 0.5 && (harvestLevel = held.func_77973_b().getHarvestLevel(held, "axe", playerIn, null)) >= 0) {
                ((TileChoppingBoard)te).process(playerIn, held, TileChoppingBoard.ProcessionType.AXE, harvestLevel);
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileChoppingBoard) {
            TileChoppingBoard teCB = (TileChoppingBoard)te;
            ItemStack stack = teCB.stacks.getStackInSlot(0);
            if (stack.func_190926_b()) {
                return 0;
            }
            Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(stack);
            if (ingredient != null) {
                return ingredient.getForm().ordinal() + 1;
            }
        }
        return 0;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileChoppingBoard();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getItemStack(ItemStack cover) {
        ItemStack stack = new ItemStack((Block)this);
        if (stack.func_77973_b() instanceof ItemBlock) {
            NBTHelper.of((ItemStack)stack).setTag("BlockEntityTag.cover", (NBTBase)cover.serializeNBT());
        }
        return stack;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileChoppingBoard) {
            return ((TileChoppingBoard)te).getSelfItem();
        }
        return new ItemStack((Block)this);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileChoppingBoard) {
            BlockChoppingBoard.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)((TileChoppingBoard)te).getSelfItem());
            StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)((TileChoppingBoard)te).stacks, true);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static List<ItemStack> getSuitableCovers() {
        return OreUtil.getItemsFromOre((String)"logWood", (int)1).stream().filter(i -> i.func_77973_b() instanceof ItemBlock).collect(Collectors.toList());
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        BlockChoppingBoard.getSuitableCovers().forEach(cover -> items.add((Object)this.getItemStack((ItemStack)cover)));
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        NBTHelper helper = NBTHelper.of((ItemStack)stack);
        if (helper.hasTag("BlockEntityTag.cover", 10)) {
            ItemStack cover = new ItemStack(helper.getTag("BlockEntityTag.cover", false));
            tooltip.add(cover.func_82833_r());
        } else {
            tooltip.add(TileChoppingBoard.DEFAULT_COVER.func_82833_r());
        }
        super.func_190948_a(stack, world, tooltip, flagIn);
    }

    @SubscribeEvent
    public static void onChoppingBoardClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack held;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        if (event.getEntityPlayer().func_184812_l_() && state.func_177230_c() == CuisineRegistry.CHOPPING_BOARD && (OreUtil.doesItemHaveOreName((ItemStack)(held = event.getEntityPlayer().func_184586_b(event.getHand())), (String)"itemFoodCutter") || held.func_77973_b().getToolClasses(held).contains("axe"))) {
            event.setCanceled(true);
            state.func_177230_c().func_180649_a(world, pos, event.getEntityPlayer());
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }
}

