/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.tiles.TileBasin;
import snownee.cuisine.tiles.TileBasinHeatable;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockMod;

public class BlockBasin
extends BlockMod {
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockBasin(String name, Material materialIn) {
        super(name, materialIn);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_180430_e(fallDistance, 0.5f);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileBasin) {
            TileBasin tileBasin = (TileBasin)tile;
            if (fallDistance >= 1.0f && entityIn instanceof EntityLivingBase) {
                ItemStack input = tileBasin.stacks.getStackInSlot(0);
                if (!input.func_190926_b() || tileBasin.tank.getFluidAmount() > 0) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187888_ft, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() / 4.0f + 0.6f);
                }
                if (input.func_190926_b()) {
                    return;
                }
                if (input.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150434_aF)) {
                    entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
                } else if (input.func_77973_b() == CuisineRegistry.BASIC_FOOD && input.func_77960_j() == ItemBasicFood.Variant.EMPOWERED_CITRON.getMeta() && entityIn instanceof EntityPlayer && tileBasin.tank.getFluidAmount() == 0) {
                    ItemBasicFood.citronSays((EntityLivingBase)entityIn, "squeeze");
                }
                tileBasin.process(Processing.SQUEEZING, input, false);
                if (entityIn instanceof EntityIronGolem) {
                    tileBasin.process(Processing.SQUEEZING, input, false);
                }
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileBasin) {
            TileBasin tileBasin = (TileBasin)tile;
            if (entityIn.getClass() == EntityItem.class) {
                if (tileBasin.tickCheckThrowing > 0) {
                    --tileBasin.tickCheckThrowing;
                    return;
                }
                List items = worldIn.func_72872_a(EntityItem.class, new AxisAlignedBB(pos)).stream().filter(e -> !e.field_70128_L && e.field_70122_E).map(EntityItem::func_92059_d).collect(Collectors.toList());
                for (ItemStack stack : items) {
                    tileBasin.process(Processing.BASIN_THROWING, stack, false);
                }
                tileBasin.tickCheckThrowing = 25;
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return state.func_185904_a() == Material.field_151575_d ? new TileBasin() : new TileBasinHeatable();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileBasin) {
            StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)((TileBasin)te).stacks, true);
            ((TileBasin)te).spillFluids();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileBasin) {
            ItemStack held = playerIn.func_184586_b(hand);
            if (facing == EnumFacing.UP && held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150331_J)) {
                return false;
            }
            TileBasin tileBasin = (TileBasin)tile;
            ItemStack inv = tileBasin.stacks.getStackInSlot(0);
            if (held.func_190926_b()) {
                if (inv.func_190926_b()) {
                    return false;
                }
                StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)tileBasin.stacks, false);
                return true;
            }
            ItemStack heldCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1);
            if (FluidUtil.getFluidHandler((ItemStack)heldCopy) != null) {
                FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing);
            } else if (inv.func_190926_b()) {
                playerIn.func_184611_a(hand, tileBasin.stacks.insertItem(0, held, false));
            } else {
                StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)tileBasin.stacks, false);
            }
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        IFluidTankProperties tank;
        IFluidHandler handler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, null);
        if (handler != null && handler.getTankProperties().length > 0 && (tank = handler.getTankProperties()[0]).getContents() != null) {
            return 1 + tank.getContents().amount * 14 / tank.getCapacity();
        }
        return 0;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.func_189540_a(state, worldIn, pos, (Block)this, pos.func_177984_a());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (CuisineConfig.GENERAL.enableSqueezer && pos.func_177984_a().equals((Object)fromPos)) {
            IBlockState fromState = worldIn.func_180495_p(fromPos);
            if (fromState.func_177230_c() == Blocks.field_150331_J) {
                worldIn.func_175656_a(fromPos, CuisineRegistry.SQUEEZER.func_176223_P());
            }
        } else if (pos.func_177977_b().equals((Object)fromPos) && (tile = worldIn.func_175625_s(pos)) instanceof TileBasinHeatable) {
            ((TileBasinHeatable)tile).updateHeat();
        }
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
        IFluidHandler handler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, (EnumFacing)EnumFacing.UP);
        if (handler != null) {
            handler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

