/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.items.ItemCrops;
import snownee.cuisine.world.feature.WorldFeatureBamboo;
import snownee.kiwi.block.BlockMod;

public class BlockBambooPlant
extends BlockMod
implements IPlantable,
IGrowable {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    public static final AxisAlignedBB AABB_SHOOT = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.6875, 0.6875);
    public static final AxisAlignedBB AABB_LEAVES = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625, 0.8125);
    public static long LAST_RAIN_TIME = -12000L;

    public BlockBambooPlant(String name) {
        super(name, Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)Type.A_0)));
        this.func_149675_a(true);
        this.func_149711_c(0.25f);
    }

    public boolean hasItem() {
        return false;
    }

    public boolean generateBamboo(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        WorldFeatureBamboo generator = new WorldFeatureBamboo(true);
        return generator.func_180709_b(worldIn, rand, pos);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_72896_J()) {
                LAST_RAIN_TIME = worldIn.func_82737_E();
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(6) == 0) {
                Biome biome = worldIn.func_180494_b(pos);
                if (!biome.func_76738_d() || biome.func_150559_j()) {
                    return;
                }
                if (((Type)((Object)state.func_177229_b(TYPE))).ordinal() < 2) {
                    this.func_176474_b(worldIn, rand, pos, state);
                } else if (((Type)((Object)state.func_177229_b(TYPE))).ordinal() < 6 && !worldIn.func_72896_J() && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this && worldIn.func_175678_i(pos)) {
                    for (int i = 1; i < 6; ++i) {
                        if (worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this) continue;
                        return;
                    }
                    long interval = worldIn.func_82737_E() - LAST_RAIN_TIME;
                    if (!worldIn.func_82736_K().func_82766_b("doWeatherCycle") || interval > 0L && interval < 9000L) {
                        boolean flag = false;
                        int count = Math.min(1 + rand.nextInt(3), 2);
                        while (--count != 0) {
                            BlockPos position = pos.func_177982_a(rand.nextInt(7) - 3, 3, rand.nextInt(7) - 3);
                            IBlockState iblockstate = worldIn.func_180495_p(position);
                            while (iblockstate.func_177230_c().func_176200_f((IBlockAccess)worldIn, position) && !(iblockstate.func_177230_c() instanceof IFluidBlock) && !(iblockstate.func_177230_c() instanceof BlockLiquid) && position.func_177956_o() + 3 >= pos.func_177956_o()) {
                                position = position.func_177977_b();
                                iblockstate = worldIn.func_180495_p(position);
                            }
                            if ((iblockstate.func_177230_c() != Blocks.field_150458_ak || (Integer)iblockstate.func_177229_b((IProperty)BlockFarmland.field_176531_a) != 7) && rand.nextBoolean() || !this.func_176196_c(worldIn, position = position.func_177984_a())) continue;
                            worldIn.func_175656_a(position, this.func_176223_P());
                            worldIn.func_175718_b(2005, position, 0);
                            worldIn.func_175718_b(2001, position, Block.func_176210_f((IBlockState)this.func_176223_P()));
                            flag = true;
                        }
                        if (flag) {
                            worldIn.func_175656_a(pos, state.func_177231_a(TYPE));
                        }
                    }
                }
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return ((Type)((Object)state.func_177229_b(TYPE))).ordinal() < 2;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return worldIn.field_73012_v.nextFloat() < 0.45f;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(TYPE) == Type.A_0) {
            worldIn.func_180501_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)Type.A_1)), 4);
        } else if (this.generateBamboo(worldIn, pos, state, rand)) {
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return BlockBambooPlant.getItemInternal((IBlockAccess)world, pos, state);
    }

    public static ItemStack getItemInternal(IBlockAccess blockAccess, BlockPos pos, IBlockState state) {
        int ordinal = ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
        if (ordinal < 2) {
            return CuisineRegistry.CROPS.getItemStack(ItemCrops.Variant.BAMBOO_SHOOT);
        }
        if (ordinal < 7) {
            return new ItemStack((Block)CuisineRegistry.BAMBOO);
        }
        return ItemStack.field_190927_a;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)BlockBambooPlant.getItemInternal(world, pos, state));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && !(state.func_177230_c() instanceof IFluidBlock) && !(state.func_177230_c() instanceof IFluidBlock) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    protected final boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag;
        int ordinal = ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
        if (ordinal < 7) {
            if (this.canBlockStay(worldIn, pos)) {
                return true;
            }
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        BlockPos basePos = pos.func_177972_a(EnumFacing.func_176731_b((int)(ordinal - 7)).func_176734_d());
        boolean bl = flag = worldIn.func_180495_p(basePos).func_177230_c() == this;
        if (!flag) {
            worldIn.func_175698_g(pos);
        }
        return flag;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (((Type)((Object)state.func_177229_b(TYPE))).ordinal() < 2) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        Type[] values = Type.values();
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(values.length - 1));
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)values[meta]));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN && ((Type)((Object)blockState.func_177229_b(TYPE))).ordinal() < 7;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos basePos;
        IBlockState baseState;
        int ordinal = ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
        if (ordinal > 6 && (baseState = worldIn.func_180495_p(basePos = pos.func_177972_a(EnumFacing.func_176731_b((int)(ordinal - 7)).func_176734_d()))).func_177230_c() == this && ((Type)((Object)baseState.func_177229_b(TYPE))).ordinal() < 7) {
            return baseState.func_191059_e(worldIn, basePos);
        }
        return super.func_190949_e(state, worldIn, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return ((Type)((Object)blockState.func_177229_b(TYPE))).ordinal() < 2 ? field_185506_k : super.func_180646_a(blockState, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int ordinal = ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
        AxisAlignedBB aabb = ordinal < 2 ? AABB_SHOOT : (ordinal < 7 ? AABB : AABB_LEAVES);
        return aabb.func_191194_a(state.func_191059_e(source, pos));
    }

    public static enum Type implements IStringSerializable
    {
        A_0,
        A_1,
        A_2,
        A_3,
        A_4,
        A_5,
        A_6,
        B_S,
        B_W,
        B_N,
        B_E;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

