/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockBambooPlant;
import snownee.cuisine.entities.EntitySeed;
import snownee.cuisine.items.ItemCrops;
import snownee.kiwi.block.BlockMod;
import snownee.kiwi.util.AABBUtil;

public class BlockBamboo
extends BlockMod {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NE = PropertyBool.func_177716_a((String)"ne");
    public static final PropertyBool NW = PropertyBool.func_177716_a((String)"nw");
    public static final PropertyBool SE = PropertyBool.func_177716_a((String)"se");
    public static final PropertyBool SW = PropertyBool.func_177716_a((String)"sw");
    private static final AxisAlignedBB PLATE_AABB = new AxisAlignedBB(0.3125, 0.625, 0.3125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_AABB = new AxisAlignedBB(0.375, 0.625, 0.375, 1.0, 0.875, 0.625);

    public BlockBamboo(String name) {
        super(name, Material.field_151575_d);
        IBlockState stateDefault = this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)EAST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)WEST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)DOWN, (Comparable)Boolean.FALSE).func_177226_a((IProperty)NE, (Comparable)Boolean.FALSE).func_177226_a((IProperty)NW, (Comparable)Boolean.FALSE).func_177226_a((IProperty)SE, (Comparable)Boolean.FALSE).func_177226_a((IProperty)SW, (Comparable)Boolean.FALSE);
        this.func_180632_j(stateDefault);
        this.func_149711_c(0.25f);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        if (CuisineConfig.GENERAL.bambooBlowpipe) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return (Boolean)(state = this.func_176221_a(state, world, pos)).func_177229_b((IProperty)DOWN) != false || (Boolean)state.func_177229_b((IProperty)NE) != false || (Boolean)state.func_177229_b((IProperty)NW) != false || (Boolean)state.func_177229_b((IProperty)SE) != false || (Boolean)state.func_177229_b((IProperty)SW) != false || entity.field_70163_u < (double)pos.func_177956_o() + 0.875;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        BlockBamboo.addCollisionBoxToListInternal(state, source, pos, new AxisAlignedBB(pos), aabbs, null, false);
        if (aabbs.size() == 0) {
            return field_185505_j;
        }
        AxisAlignedBB aabb = (AxisAlignedBB)aabbs.get(0);
        for (int i = 1; i < aabbs.size(); ++i) {
            aabb = aabb.func_111270_a((AxisAlignedBB)aabbs.get(i));
        }
        return aabb.func_186670_a(new BlockPos(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p()));
    }

    private static void addCollisionBoxToListInternal(IBlockState state, IBlockAccess worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b(worldIn, pos);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue() || !((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockBambooPlant.AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)NW)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABBUtil.rotate((AxisAlignedBB)PLATE_AABB, (EnumFacing)EnumFacing.SOUTH));
        }
        if (((Boolean)state.func_177229_b((IProperty)NE)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABBUtil.rotate((AxisAlignedBB)PLATE_AABB, (EnumFacing)EnumFacing.EAST));
        }
        if (((Boolean)state.func_177229_b((IProperty)SW)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABBUtil.rotate((AxisAlignedBB)PLATE_AABB, (EnumFacing)EnumFacing.WEST));
        }
        if (((Boolean)state.func_177229_b((IProperty)SE)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PLATE_AABB);
        }
        if (!((Boolean)state.func_177229_b((IProperty)NW)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)NE)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABBUtil.rotate((AxisAlignedBB)SIDE_AABB, (EnumFacing)EnumFacing.EAST));
        }
        if (!((Boolean)state.func_177229_b((IProperty)SW)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)SE)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABBUtil.rotate((AxisAlignedBB)SIDE_AABB, (EnumFacing)EnumFacing.WEST));
        }
        if (!((Boolean)state.func_177229_b((IProperty)NW)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)SW)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABBUtil.rotate((AxisAlignedBB)SIDE_AABB, (EnumFacing)EnumFacing.SOUTH));
        }
        if (!((Boolean)state.func_177229_b((IProperty)SE)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)NE)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockBamboo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_AABB);
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        BlockBamboo.addCollisionBoxToListInternal(state, (IBlockAccess)worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, WEST, EAST, DOWN, NE, NW, SE, SW});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos posFaced;
        IBlockState stateFaced;
        ImmutableMap map = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)NORTH, (Object)EnumFacing.SOUTH, (Object)SOUTH, (Object)EnumFacing.EAST, (Object)EAST, (Object)EnumFacing.WEST, (Object)WEST, (Object)EnumFacing.DOWN, (Object)DOWN);
        for (Map.Entry entry : map.entrySet()) {
            BlockPos pos2 = pos.func_177972_a((EnumFacing)entry.getKey());
            IBlockState stateFaced2 = worldIn.func_180495_p(pos2);
            if (stateFaced2.func_177230_c() != this && !stateFaced2.isSideSolid(worldIn, pos2, ((EnumFacing)entry.getKey()).func_176734_d())) continue;
            state = state.func_177226_a((IProperty)entry.getValue(), (Comparable)Boolean.TRUE);
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() && ((stateFaced = worldIn.func_180495_p(posFaced = pos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST))).func_177230_c() == this || stateFaced.func_185913_b())) {
            state = state.func_177226_a((IProperty)NE, (Comparable)Boolean.TRUE);
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue() && ((stateFaced = worldIn.func_180495_p(posFaced = pos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.WEST))).func_177230_c() == this || stateFaced.func_185913_b())) {
            state = state.func_177226_a((IProperty)NW, (Comparable)Boolean.TRUE);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() && ((stateFaced = worldIn.func_180495_p(posFaced = pos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST))).func_177230_c() == this || stateFaced.func_185913_b())) {
            state = state.func_177226_a((IProperty)SE, (Comparable)Boolean.TRUE);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue() && ((stateFaced = worldIn.func_180495_p(posFaced = pos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.WEST))).func_177230_c() == this || stateFaced.func_185913_b())) {
            state = state.func_177226_a((IProperty)SW, (Comparable)Boolean.TRUE);
        }
        return state;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue() || !((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
                return BlockFaceShape.CENTER;
            }
            return BlockFaceShape.UNDEFINED;
        }
        if (face == EnumFacing.UP) {
            boolean flag = (Boolean)state.func_177229_b((IProperty)NW) != false && (Boolean)state.func_177229_b((IProperty)NE) != false && (Boolean)state.func_177229_b((IProperty)SW) != false && (Boolean)state.func_177229_b((IProperty)SE) != false;
            return flag ? BlockFaceShape.SOLID : BlockFaceShape.CENTER;
        }
        if (face == EnumFacing.NORTH) {
            return (Boolean)state.func_177229_b((IProperty)NORTH) != false ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        }
        if (face == EnumFacing.SOUTH) {
            return (Boolean)state.func_177229_b((IProperty)SOUTH) != false ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        }
        if (face == EnumFacing.WEST) {
            return (Boolean)state.func_177229_b((IProperty)WEST) != false ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        }
        if (face == EnumFacing.EAST) {
            return (Boolean)state.func_177229_b((IProperty)EAST) != false ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return (Boolean)blockState.func_177229_b((IProperty)NORTH) != false || (Boolean)blockState.func_177229_b((IProperty)SOUTH) != false || (Boolean)blockState.func_177229_b((IProperty)WEST) != false || (Boolean)blockState.func_177229_b((IProperty)EAST) != false;
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == EnumHand.MAIN_HAND && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)this)) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184592_cb();
            if (stack.func_190926_b()) {
                return;
            }
            if (stack.func_77973_b() instanceof ItemSeeds || stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 3 || stack.func_77973_b() == CuisineRegistry.CROPS && (stack.func_77960_j() == ItemCrops.Variant.SOYBEAN.getMeta() || stack.func_77960_j() == ItemCrops.Variant.PEANUT.getMeta())) {
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.FAIL);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getHand() == EnumHand.MAIN_HAND && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)this)) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184592_cb();
            if (stack.func_190926_b()) {
                return;
            }
            if (stack.func_77973_b() instanceof ItemSeeds || stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 3 || stack.func_77973_b() == CuisineRegistry.CROPS && (stack.func_77960_j() == ItemCrops.Variant.SOYBEAN.getMeta() || stack.func_77960_j() == ItemCrops.Variant.PEANUT.getMeta())) {
                if (!event.getWorld().field_72995_K) {
                    EntitySeed seed = new EntitySeed(event.getWorld(), (EntityLivingBase)player, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    seed.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                    event.getWorld().func_72838_d((Entity)seed);
                }
                player.func_184811_cZ().func_185145_a(Item.func_150898_a((Block)CuisineRegistry.BAMBOO), 20);
                event.getWorld().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187511_aA, SoundCategory.PLAYERS, 0.5f, 0.4f / (event.getWorld().field_73012_v.nextFloat() * 0.4f + 0.8f));
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }
}

