/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.util;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinarySkill;
import snownee.cuisine.api.CulinarySkillManager;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.api.CulinarySkillPointContainer;
import snownee.cuisine.api.events.SkillPointUpdateEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SkillUtil {
    public static int MAX_LEVEL = 3;

    public static int getPoint(EntityPlayer player, CulinarySkillPoint skillPoint) {
        CulinarySkillPointContainer cap = (CulinarySkillPointContainer)player.getCapability(CulinaryCapabilities.CULINARY_SKILL, null);
        if (cap != null) {
            return cap.getSkillPoint(skillPoint);
        }
        return 0;
    }

    public static void setPoint(EntityPlayer player, CulinarySkillPoint skillPoint, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("negative skill level");
        }
        CulinarySkillPointContainer cap = (CulinarySkillPointContainer)player.getCapability(CulinaryCapabilities.CULINARY_SKILL, null);
        if (cap != null) {
            SkillPointUpdateEvent event = new SkillPointUpdateEvent(player, skillPoint, value);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                cap.setSkillPoint(event.getSkillPoint(), event.getNewValue());
            }
        }
    }

    public static int getLevel(EntityPlayer player, CulinarySkillPoint skillPoint) {
        return SkillUtil.getLevel(SkillUtil.getPoint(player, skillPoint));
    }

    public static int getLevel(int point) {
        return MathHelper.func_76125_a((int)(point / 50), (int)0, (int)MAX_LEVEL);
    }

    public static void setLevel(EntityPlayer player, CulinarySkillPoint skillPoint, int level) {
        SkillUtil.setPoint(player, skillPoint, level * 50);
    }

    public static void increasePoint(EntityPlayer player, CulinarySkillPoint skillPoint, int delta) {
        SkillUtil.setPoint(player, skillPoint, SkillUtil.getPoint(player, skillPoint) + delta);
    }

    public static void increaseLevel(EntityPlayer player, CulinarySkillPoint skillPoint, int delta) {
        SkillUtil.setLevel(player, skillPoint, SkillUtil.getLevel(player, skillPoint) + delta);
    }

    public static boolean hasPlayerLearnedSkill(EntityPlayer player, CulinarySkill skill) {
        int pointReq;
        if (player instanceof FakePlayer) {
            return false;
        }
        int pointPlayer = SkillUtil.getLevel(player, skill.skillPointRequirement());
        return pointPlayer >= (pointReq = CulinarySkillManager.getLevelRequirement(skill));
    }

    public static List<String> getKnownSkillNames() {
        return CulinarySkillManager.getSkills().stream().map(CulinarySkill::getName).collect(Collectors.toList());
    }
}

