/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.process.prefab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import snownee.cuisine.api.process.CuisineProcessingRecipe;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;

public final class ProcessingManagerImpl<R extends CuisineProcessingRecipe>
implements CuisineProcessingRecipeManager<R> {
    private final List<R> recipes = new ArrayList<R>(16);

    @Override
    @Nonnull
    public List<R> preview() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Override
    public void add(@Nonnull R recipe) {
        this.recipes.add(Objects.requireNonNull(recipe, "Attempt to register a recipe without identifier"));
    }

    @Override
    public boolean remove(Object ... inputs) {
        return this.recipes.removeIf((? super E recipe) -> recipe.matches(inputs));
    }

    @Override
    public boolean remove(R recipe) {
        return this.recipes.removeIf(arg_0 -> recipe.equals(arg_0));
    }

    @Override
    public boolean remove(ResourceLocation identifier) {
        return this.recipes.removeIf((? super E r) -> r.getIdentifier().equals((Object)identifier));
    }

    @Override
    public boolean removeIf(Predicate<? super R> filter) {
        return this.recipes.removeIf(filter);
    }

    @Override
    public void removeAll() {
        this.recipes.clear();
    }

    @Override
    @Nullable
    public R findRecipe(ResourceLocation locator) {
        for (CuisineProcessingRecipe r : this.recipes) {
            if (!locator.equals((Object)r.getIdentifier())) continue;
            return (R)r;
        }
        return null;
    }

    @Override
    @Nullable
    public R findRecipe(Object ... inputs) {
        for (CuisineProcessingRecipe r : this.recipes) {
            if (!r.matches(inputs)) continue;
            return (R)r;
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<R> findAllPossibleRecipes(Object ... inputs) {
        ArrayList<CuisineProcessingRecipe> list = new ArrayList<CuisineProcessingRecipe>();
        for (CuisineProcessingRecipe recipe : this.recipes) {
            if (!recipe.matches(inputs)) continue;
            list.add(recipe);
        }
        return Collections.unmodifiableList(list);
    }
}

