/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.process.prefab;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.process.AbstractCuisineProcessingRecipe;
import snownee.cuisine.api.process.BasinInteracting;

public class MaterialSqueezing
extends AbstractCuisineProcessingRecipe
implements BasinInteracting {
    private final Material material;

    public MaterialSqueezing(Material material) {
        super(new ResourceLocation("cuisine", "squeezing_" + material.getID()));
        if (!material.isValidForm(Form.JUICE)) {
            throw new IllegalArgumentException(String.format("material '%s' cannot make juice", material));
        }
        this.material = material;
    }

    @Override
    public boolean matches(ItemStack item, @Nullable FluidStack fluid) {
        return this.matchesItem(item) && (fluid == null || this.material == CulinaryHub.API_INSTANCE.findMaterial(fluid));
    }

    @Override
    public boolean matchesItem(ItemStack item) {
        Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(item);
        return ingredient != null && ingredient.getMaterial() == this.material;
    }

    @Override
    public BasinInteracting.Output getOutput(ItemStack item, @Nullable FluidStack fluid, Random rand) {
        Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(item);
        if (ingredient == null) {
            return new BasinInteracting.Output(fluid, ItemStack.field_190927_a);
        }
        int amount = fluid == null ? 0 : fluid.amount;
        FluidStack outputFluid = CulinaryHub.API_INSTANCE.makeJuiceFluid(this.material, amount += CuisineConfig.GENERAL.juiceSqueezingAmount);
        return new BasinInteracting.Output(outputFluid, ItemStack.field_190927_a);
    }

    public Material getMaterial() {
        return this.material;
    }
}

