/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.process;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.process.AbstractCuisineProcessingRecipe;
import snownee.cuisine.api.process.CuisineProcessingRecipe;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.definition.ItemDefinition;

public final class Vessel
extends AbstractCuisineProcessingRecipe
implements CuisineProcessingRecipe {
    private final ProcessingInput input;
    private final Fluid solvent;
    private final ItemDefinition output;
    private final FluidStack outputFluid;
    private final ProcessingInput extraRequirement;

    public Vessel(ResourceLocation identifier, ProcessingInput input, Fluid solvent, ItemDefinition output, @Nullable FluidStack outputFluid, ProcessingInput extraRequirement) {
        super(identifier);
        this.input = input;
        this.solvent = solvent;
        this.output = output;
        this.outputFluid = outputFluid;
        this.extraRequirement = extraRequirement;
    }

    public Vessel(ResourceLocation identifier, ProcessingInput input, Fluid solvent, ItemDefinition output, @Nullable FluidStack outputFluid) {
        this(identifier, input, solvent, output, outputFluid, (ProcessingInput)ItemDefinition.of((ItemStack)ItemStack.field_190927_a));
    }

    public ProcessingInput getInput() {
        return this.input;
    }

    public Fluid getSolvent() {
        return this.solvent;
    }

    public ItemDefinition getOutput() {
        return this.output;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public ProcessingInput getExtraRequirement() {
        return this.extraRequirement;
    }

    @Override
    public boolean matches(Object ... inputs) {
        Object secondInput;
        if (inputs.length < 2) {
            return false;
        }
        Object firstInput = inputs[0];
        if (firstInput instanceof FluidStack && ((FluidStack)firstInput).getFluid() == this.solvent && (secondInput = inputs[1]) instanceof ItemStack && this.input.matches((ItemStack)secondInput)) {
            int countItem = ((ItemStack)secondInput).func_190916_E();
            int countFluid = ((FluidStack)firstInput).amount;
            if (this.outputFluid == null ? countFluid < countItem * 100 : countFluid > countItem * 100) {
                return false;
            }
            if (this.extraRequirement.isEmpty()) {
                return true;
            }
            int countExtra = 0;
            for (int i = 2; i < inputs.length; ++i) {
                if (!(inputs[i] instanceof ItemStack) || ((ItemStack)inputs[i]).func_190926_b() || !this.extraRequirement.matches((ItemStack)inputs[i]) || (countExtra += ((ItemStack)inputs[i]).func_190916_E()) < countItem) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vessel vessel = (Vessel)o;
        if (!this.input.equals((Object)vessel.input)) {
            return false;
        }
        if (this.solvent != vessel.solvent) {
            return false;
        }
        return this.extraRequirement.isEmpty() ? vessel.extraRequirement.isEmpty() : this.extraRequirement.equals((Object)vessel.extraRequirement);
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = 31 * result + this.solvent.hashCode();
        result = 31 * result + this.extraRequirement.hashCode();
        return result;
    }
}

