/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.process;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.process.AbstractCuisineProcessingRecipe;
import snownee.cuisine.api.process.CuisineProcessingRecipe;
import snownee.cuisine.api.process.Processing;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.crafting.input.RegularItemStackInput;

public final class Milling
extends AbstractCuisineProcessingRecipe
implements CuisineProcessingRecipe {
    private final ProcessingInput input;
    private final ItemStack output;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;

    public Milling(ResourceLocation identifier, ItemStack input, ItemStack output, @Nullable FluidStack inputFluid, @Nullable FluidStack outputFluid) {
        this(identifier, (ProcessingInput)RegularItemStackInput.of((ItemStack)input), output, inputFluid, outputFluid);
    }

    public Milling(ResourceLocation identifier, ProcessingInput input, ItemStack output, @Nullable FluidStack inputFluid, @Nullable FluidStack outputFluid) {
        super(identifier);
        this.input = input;
        this.output = output;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
    }

    public Milling(ResourceLocation identifier, ItemStack input, ItemStack output) {
        this(identifier, input, output, null, null);
    }

    public Milling(ResourceLocation identifier, ProcessingInput input, ItemStack output) {
        this(identifier, input, output, null, null);
    }

    @Nonnull
    public ProcessingInput getInput() {
        return this.input;
    }

    @Nonnull
    public ItemStack getOutput() {
        return this.output;
    }

    @Nullable
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    @Nullable
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public boolean matches(Object ... inputs) {
        if (inputs == null || inputs.length != 2) {
            return false;
        }
        Object itemStackToCheck = inputs[0];
        if (itemStackToCheck instanceof ItemStack && this.input.matches((ItemStack)itemStackToCheck)) {
            if (this.inputFluid == null) {
                return inputs[1] == null;
            }
            return this.inputFluid.equals(inputs[1]) && this.inputFluid.amount <= ((FluidStack)inputs[1]).amount;
        }
        return false;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Milling) {
            Milling another = (Milling)obj;
            if (this.input.equals((Object)another.input)) {
                if (this.inputFluid == null) {
                    return another.inputFluid == null;
                }
                return this.inputFluid.isFluidEqual(another.inputFluid) && this.inputFluid.amount == another.inputFluid.amount;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.input.hashCode() * 17 + this.inputFluid.hashCode();
    }

    public static boolean isKnownMillingInput(ItemStack stack) {
        for (Milling recipe : Processing.MILLING.preview()) {
            if (!recipe.input.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownMillingInput(@Nullable FluidStack stack) {
        for (Milling recipe : Processing.MILLING.preview()) {
            if (!(recipe.inputFluid == null ? stack == null : recipe.inputFluid.isFluidEqual(stack))) continue;
            return true;
        }
        return false;
    }
}

