/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.process;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import snownee.cuisine.api.process.CuisineProcessingRecipe;

public final class Hybridization
implements CuisineProcessingRecipe {
    private ResourceLocation id;
    private final List<IBlockState> statesA;
    private final List<IBlockState> statesB;
    private final IBlockState resultState;
    private final List<ItemStack> displayItemsA;
    private final List<ItemStack> displayItemsB;
    private final List<ItemStack> displayResultItems;

    public Hybridization(List<IBlockState> statesA, List<IBlockState> statesB, IBlockState resultState, List<ItemStack> displayItemsA, List<ItemStack> displayItemsB, List<ItemStack> displayResultItems) {
        this.statesA = statesA;
        this.statesB = statesB;
        this.resultState = resultState;
        this.displayItemsA = displayItemsA;
        this.displayItemsB = displayItemsB;
        this.displayResultItems = displayResultItems;
    }

    @Override
    public boolean matches(Object ... inputs) {
        return inputs.length == 2 && this.statesA.contains(inputs[0]) && this.statesB.contains(inputs[1]);
    }

    public List<ItemStack> getDisplayItemsA() {
        return this.displayItemsA;
    }

    public List<ItemStack> getDisplayItemsB() {
        return this.displayItemsB;
    }

    public List<ItemStack> getDisplayResultItems() {
        return this.displayResultItems;
    }

    public List<IBlockState> getStatesA() {
        return this.statesA;
    }

    public List<IBlockState> getStatesB() {
        return this.statesB;
    }

    public IBlockState getResultState() {
        return this.resultState;
    }

    public void setIdentifier(ResourceLocation locator) {
        this.id = locator;
    }

    @Override
    @Nonnull
    public ResourceLocation getIdentifier() {
        return this.id;
    }
}

