/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.api.process.AbstractCuisineProcessingRecipe;
import snownee.cuisine.api.process.CuisineProcessingRecipe;
import snownee.kiwi.crafting.input.ProcessingInput;

public final class Grinding
extends AbstractCuisineProcessingRecipe
implements CuisineProcessingRecipe {
    private final List<ProcessingInput> ingredients;
    private final ItemStack output;
    private final int step;
    private final int totalCount;

    public Grinding(ResourceLocation id, List<ProcessingInput> inputs, ItemStack output, int step) {
        super(id);
        this.ingredients = inputs;
        this.output = output;
        this.step = step;
        this.totalCount = inputs.stream().mapToInt(ProcessingInput::count).sum();
    }

    @Override
    public boolean matches(Object ... inputs) {
        ArrayList<ItemStack> actualInputs = new ArrayList<ItemStack>();
        for (Object o : inputs) {
            if (!(o instanceof ItemStack) || ((ItemStack)o).func_190926_b()) continue;
            actualInputs.add((ItemStack)o);
        }
        ArrayList<ProcessingInput> recipeInputs = new ArrayList<ProcessingInput>(this.ingredients);
        Iterator itr = recipeInputs.iterator();
        block1: while (itr.hasNext()) {
            ProcessingInput recipeInput = (ProcessingInput)itr.next();
            for (ItemStack actualInput : actualInputs) {
                if (!recipeInput.matches(actualInput)) continue;
                itr.remove();
                continue block1;
            }
        }
        return recipeInputs.isEmpty();
    }

    public List<ProcessingInput> getInputs() {
        return this.ingredients;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getStep() {
        return this.step;
    }

    public static int descendingCompare(Grinding a, Grinding b) {
        return Integer.compare(b.totalCount, a.totalCount);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grinding grinding = (Grinding)o;
        return this.ingredients.equals(grinding.ingredients);
    }

    public int hashCode() {
        return this.ingredients.hashCode();
    }

    public void consume(IItemHandler inv) {
        ArrayList<ProcessingInput> stacks = new ArrayList<ProcessingInput>(this.ingredients);
        int invSize = inv.getSlots();
        block0: for (ProcessingInput ingredient : stacks) {
            for (int i = 0; i < invSize; ++i) {
                if (!ingredient.matches(inv.getStackInSlot(i))) continue;
                inv.extractItem(i, ingredient.count(), false);
                continue block0;
            }
        }
    }
}

