/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.process;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.api.process.AbstractCuisineProcessingRecipe;
import snownee.cuisine.api.process.CuisineProcessingRecipe;
import snownee.kiwi.crafting.input.ProcessingInput;

public class Chopping
extends AbstractCuisineProcessingRecipe
implements CuisineProcessingRecipe {
    public final ProcessingInput input;
    private final ItemStack output;

    public Chopping(ResourceLocation identifier, ProcessingInput input, ItemStack output) {
        super(identifier);
        this.input = Chopping.checkFalseFor(input, input.isEmpty(), "Trying to add an invalid chopping recipe with input: " + input);
        this.output = Chopping.checkFalseFor(output, output.func_190926_b(), "Trying to add an invalid chopping recipe with output: " + output);
    }

    private static <T> T checkFalseFor(T target, boolean premise, @Nullable String errorMessage) {
        if (errorMessage == null) {
            errorMessage = "Assertion failed";
        }
        if (premise) {
            throw new IllegalArgumentException(errorMessage);
        }
        return target;
    }

    public static int descendingCompare(Chopping a, Chopping b) {
        return 0;
    }

    @Override
    public boolean matches(Object ... inputs) {
        if (inputs == null || inputs.length != 1) {
            return false;
        }
        if (inputs[0] instanceof ItemStack) {
            return this.input.matches((ItemStack)inputs[0]);
        }
        if (inputs[0].getClass() == Item.class) {
            return this.input.matches(new ItemStack((Item)inputs[0]));
        }
        return false;
    }

    public void consume(IItemHandler inv) {
        int invSize = inv.getSlots();
        for (int i = 0; i < invSize; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.input.matches(stack)) continue;
            stack = inv.extractItem(i, 1, false);
            if (stack.func_190926_b()) break;
            inv.insertItem(i, stack.func_77973_b().getContainerItem(stack), false);
            break;
        }
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

