/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.prefab;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.MaterialCategory;

public class SimpleMaterialImpl
implements Material {
    private final String id;
    private final int rawColor;
    private final int cookedColor;
    private final int waterValue;
    private final int oilValue;
    private final float saturationModifier;
    private final EnumSet<MaterialCategory> categories;
    private float boilHeat = 90.0f;
    private int boilTime = 150;
    private EnumSet<Form> validForms = EnumSet.noneOf(Form.class);

    public SimpleMaterialImpl(String id, int rawColor, int cookedColor, int waterValue, int oilValue, int heatValue) {
        this(id, rawColor, cookedColor, waterValue, oilValue, heatValue, 0.0f);
    }

    public SimpleMaterialImpl(String id, int rawColor, int cookedColor, int waterValue, int oilValue, int heatValue, float foodSaturationModifier) {
        this.id = id;
        if (rawColor >> 24 == 0) {
            rawColor |= 0xFF000000;
        }
        this.rawColor = rawColor;
        if (cookedColor == 0) {
            int a = rawColor >> 24 & 0xFF;
            int r = (int)Math.min(255.0f, (float)(rawColor >> 16 & 0xFF) * 1.1f);
            int g = (int)Math.min(255.0f, (float)(rawColor >> 8 & 0xFF) * 1.1f);
            int b = (int)((float)(rawColor & 0xFF) * 0.8f);
            cookedColor = a << 24 | r << 16 | g << 8 | b;
        } else if (cookedColor >> 24 == 0) {
            cookedColor |= 0xFF000000;
        }
        this.cookedColor = cookedColor;
        this.waterValue = waterValue;
        this.oilValue = oilValue;
        this.saturationModifier = foodSaturationModifier;
        this.categories = EnumSet.noneOf(MaterialCategory.class);
    }

    public SimpleMaterialImpl(String id, int rawColor, int cookedColor, int waterValue, int oilValue, int heatValue, float foodSaturationModifier, MaterialCategory ... categories) {
        this(id, rawColor, cookedColor, waterValue, oilValue, heatValue, foodSaturationModifier);
        this.categories.addAll(Arrays.asList(categories));
    }

    public SimpleMaterialImpl(String id, int rawColor, int cookedColor, int waterValue, int oilValue, int heatValue, float foodSaturationModifier, float boilHeat, int boilTime, MaterialCategory ... categories) {
        this(id, rawColor, cookedColor, waterValue, oilValue, heatValue, foodSaturationModifier, categories);
        this.boilHeat = boilHeat;
        this.boilTime = boilTime;
    }

    @Override
    public float getBoilHeat() {
        return this.boilHeat;
    }

    @Override
    public int getBoilTime() {
        return this.boilTime;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getTranslationKey() {
        return "cuisine.material." + this.getID();
    }

    @Override
    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    @Override
    public int getRawColorCode() {
        return this.rawColor;
    }

    @Override
    public int getCookedColorCode() {
        return this.cookedColor;
    }

    @Override
    public int getInitialWaterValue() {
        return this.waterValue;
    }

    @Override
    public int getInitialOilValue() {
        return this.oilValue;
    }

    @Override
    public boolean isUnderCategoryOf(MaterialCategory category) {
        return this.categories.contains((Object)category);
    }

    @Override
    public Set<MaterialCategory> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public SimpleMaterialImpl setValidForms(EnumSet<Form> validForms) {
        this.validForms = validForms;
        return this;
    }

    @Override
    public boolean isValidForm(Form form) {
        return form == Form.FULL || this.validForms.contains((Object)form);
    }

    @Override
    public EnumSet<Form> getValidForms() {
        return this.validForms;
    }

    public String toString() {
        return "Material{" + this.getID() + "}";
    }
}

