/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.prefab;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.api.prefab.SimpleMaterialImpl;
import snownee.cuisine.internal.material.MaterialWithEffect;

public class MaterialBuilder {
    private final String id;
    private int rawColor;
    private int cookedColor;
    private int waterValue;
    private int oilValue;
    private int heatValue;
    private float saturationModifier;
    private EnumSet<MaterialCategory> categories = EnumSet.noneOf(MaterialCategory.class);
    private EnumSet<Form> validForms = EnumSet.noneOf(Form.class);
    private Effect effect;
    private float boilHeat = 90.0f;
    private int boilTime = 150;

    public MaterialBuilder(String id) {
        this.id = id;
    }

    public static MaterialBuilder of(String id) {
        return new MaterialBuilder(id);
    }

    public MaterialBuilder rawColor(int rawColor) {
        this.rawColor = rawColor;
        return this;
    }

    public MaterialBuilder effect(Effect effect) {
        this.effect = effect;
        return this;
    }

    public MaterialBuilder cookedColor(int cookedColor) {
        this.cookedColor = cookedColor;
        return this;
    }

    public MaterialBuilder waterValue(int waterValue) {
        this.waterValue = waterValue;
        return this;
    }

    public MaterialBuilder oilValue(int oilValue) {
        this.oilValue = oilValue;
        return this;
    }

    public MaterialBuilder heatValue(int heatValue) {
        this.heatValue = heatValue;
        return this;
    }

    public MaterialBuilder saturation(float saturationModifier) {
        this.saturationModifier = saturationModifier;
        return this;
    }

    public MaterialBuilder form(Form ... forms) {
        this.validForms.addAll(Arrays.asList(forms));
        return this;
    }

    public MaterialBuilder form(Collection<? extends Form> forms) {
        this.validForms.addAll(forms);
        return this;
    }

    public MaterialBuilder form(EnumSet<Form> forms) {
        this.validForms = forms;
        return this;
    }

    public MaterialBuilder category(MaterialCategory ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    public MaterialBuilder category(Collection<? extends MaterialCategory> categories) {
        this.categories.addAll(categories);
        return this;
    }

    public MaterialBuilder boilHeat(float boilHeat) {
        this.boilHeat = boilHeat;
        return this;
    }

    public MaterialBuilder boilTime(int boilTime) {
        this.boilTime = boilTime;
        return this;
    }

    public SimpleMaterialImpl build() {
        if (this.effect != null) {
            return new MaterialWithEffect(this.id, this.effect, this.rawColor, this.cookedColor, this.waterValue, this.oilValue, this.heatValue, this.saturationModifier, this.boilHeat, this.boilTime, this.categories.toArray(new MaterialCategory[0])).setValidForms(this.validForms);
        }
        return new SimpleMaterialImpl(this.id, this.rawColor, this.cookedColor, this.waterValue, this.oilValue, this.heatValue, this.saturationModifier, this.boilHeat, this.boilTime, this.categories.toArray(new MaterialCategory[0])).setValidForms(this.validForms);
    }
}

