/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.prefab;

import net.minecraft.entity.player.EntityPlayer;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.EffectCollector;
import snownee.cuisine.api.EffectType;
import snownee.cuisine.api.prefab.DefaultTypes;

public class DefaultCookedCollector
implements EffectCollector {
    protected float durationModifier = 1.0f;
    protected int serveAmount = 0;

    public DefaultCookedCollector(int defaultServeAmount) {
        this.serveAmount = defaultServeAmount;
    }

    @Override
    public void apply(CompositeFood food, EntityPlayer player) {
        food.setUseDurationModifier(this.durationModifier);
        food.setMaxServes(this.serveAmount);
        food.setServes(this.serveAmount);
    }

    @Override
    public <T> void addEffect(EffectType<T> type, T effect) {
        if (type == DefaultTypes.USE_DURATION_MODIFIER) {
            this.durationModifier *= ((Float)effect).floatValue();
        }
        if (type == DefaultTypes.SERVE_AMOUNT) {
            this.serveAmount += ((Integer)effect).intValue();
        }
    }

    @Override
    public <T> T getEffect(EffectType<T> type) {
        if (type == DefaultTypes.USE_DURATION_MODIFIER) {
            return (T)DefaultTypes.USE_DURATION_MODIFIER.cast(Float.valueOf(this.durationModifier));
        }
        if (type == DefaultTypes.SERVE_AMOUNT) {
            return (T)DefaultTypes.SERVE_AMOUNT.cast(this.serveAmount);
        }
        return null;
    }

    @Override
    public <T> void clear(EffectType<T> type) {
        if (type == DefaultTypes.USE_DURATION_MODIFIER) {
            this.durationModifier = 1.0f;
        }
    }
}

