/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api.prefab;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.EffectCollector;
import snownee.cuisine.api.EffectType;
import snownee.cuisine.api.prefab.DefaultTypes;

public class DefaultConsumedCollector
implements EffectCollector {
    private final Map<Potion, PotionEffectInfo> mapPotions = new HashMap<Potion, PotionEffectInfo>();
    private final float durationModifier;
    private int foodLevel;

    public DefaultConsumedCollector(int foodLevel) {
        this(foodLevel, 1.0f);
    }

    public DefaultConsumedCollector(int foodLevel, float durationModifier) {
        this.durationModifier = Math.max(durationModifier, 0.0f);
        this.foodLevel = Math.max(foodLevel, 0);
    }

    @Override
    public void apply(CompositeFood food, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        boolean cure_potions = food.contains(CulinaryHub.CommonEffects.CURE_POTIONS);
        boolean resistance = player.func_70644_a(CulinaryHub.API_INSTANCE.getEffectResistancePotion());
        int maxDuration = 0;
        for (Map.Entry<Potion, PotionEffectInfo> entry : this.mapPotions.entrySet()) {
            if (resistance && !entry.getKey().func_76398_f() || cure_potions && entry.getKey().getCurativeItems().stream().anyMatch(i -> i.func_77973_b() == Items.field_151117_aB)) continue;
            PotionEffectInfo info = entry.getValue();
            player.func_70690_d(new PotionEffect(entry.getKey(), (int)((float)info.duration * this.durationModifier), info.amplifier, false, info.showParticles));
            if (info.duration <= maxDuration) continue;
            maxDuration = info.duration;
        }
        if (maxDuration > 0) {
            player.func_70690_d(new PotionEffect(CulinaryHub.API_INSTANCE.getEffectResistancePotion(), (int)((float)maxDuration * this.durationModifier * 2.0f), 0, true, false));
        }
    }

    public int getNewFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public <T> void addEffect(EffectType<T> type, T effect) {
        if (type == DefaultTypes.POTION) {
            PotionEffect potionEffect = (PotionEffect)effect;
            if (this.mapPotions.containsKey(potionEffect.func_188419_a())) {
                PotionEffectInfo info = this.mapPotions.get(potionEffect.func_188419_a());
                if (potionEffect.func_76458_c() > info.amplifier) {
                    info.duration = (int)((double)info.duration * Math.pow(2.0, potionEffect.func_76458_c() - info.amplifier));
                    info.amplifier = potionEffect.func_76458_c();
                }
                if (!potionEffect.func_188418_e()) {
                    info.showParticles = false;
                }
                info.duration += (int)((double)potionEffect.func_76459_b() * Math.pow(2.0, info.amplifier - potionEffect.func_76458_c()));
            } else {
                PotionEffectInfo info = new PotionEffectInfo(potionEffect);
                this.mapPotions.put(potionEffect.func_188419_a(), info);
            }
        } else if (type == DefaultTypes.FOOD_LEVEL) {
            this.foodLevel += ((Integer)effect).intValue();
        } else {
            System.err.println(String.format("Try to add an uncaught effect: %s", effect));
        }
    }

    @Override
    public <T> T getEffect(EffectType<T> type) {
        if (type == DefaultTypes.FOOD_LEVEL) {
            return (T)DefaultTypes.FOOD_LEVEL.cast(this.foodLevel);
        }
        return null;
    }

    @Override
    public <T> void clear(EffectType<T> type) {
        if (type == DefaultTypes.POTION) {
            this.mapPotions.clear();
        } else {
            System.err.println(String.format("Try to clear an uncaught type: %s", type));
        }
    }

    public static class PotionEffectInfo {
        public int amplifier;
        public int duration;
        public boolean showParticles;

        public PotionEffectInfo(PotionEffect effect) {
            this.amplifier = effect.func_76458_c();
            this.duration = effect.func_76459_b();
            this.showParticles = effect.func_188418_e();
        }
    }
}

