/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import org.apache.commons.lang3.Validate;
import snownee.cuisine.api.Spice;

public final class Seasoning {
    private final Spice spice;
    private int quantity;

    public Seasoning(Spice spice) {
        this(spice, 1);
    }

    public Seasoning(Spice spice, int quantity) {
        this.spice = spice;
        this.quantity = quantity;
    }

    public boolean matchType(Seasoning another) {
        return this.spice == another.spice;
    }

    public void merge(Seasoning another) {
        Validate.isTrue((boolean)this.matchType(another));
        this.quantity += another.quantity;
    }

    public int getSize() {
        return this.quantity;
    }

    public Spice getSpice() {
        return this.spice;
    }

    public void decreaseSizeBy(int decrement) {
        this.quantity -= decrement;
    }

    public final boolean hasKeyword(String keyword) {
        return this.spice.getKeywords().contains(keyword);
    }
}

