/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.util.math.MathHelper;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.EffectCollector;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.MaterialCategory;

public interface Material {
    public String getID();

    public boolean isValidForm(Form var1);

    public EnumSet<Form> getValidForms();

    public float getSaturationModifier();

    public int getRawColorCode();

    public int getCookedColorCode();

    public float getBoilHeat();

    public int getBoilTime();

    default public int getColorCode(int doneness) {
        if (doneness < 100) {
            return Material.mixColor(this.getRawColorCode(), this.getCookedColorCode(), (float)doneness / 100.0f);
        }
        return Material.mixColor(this.getCookedColorCode(), 0, (float)(doneness - 100) / 100.0f);
    }

    default public boolean hasGlowingOverlay(Ingredient ingredient) {
        return false;
    }

    public int getInitialWaterValue();

    public int getInitialOilValue();

    default public float getSaturationModifier(Ingredient ingredient) {
        return this.getSaturationModifier();
    }

    default public void onAddedInto(CompositeFood.Builder<?> dish, Ingredient ingredient, CookingVessel vessel) {
    }

    default public boolean canAddInto(CompositeFood.Builder<?> dish, Ingredient ingredient) {
        return true;
    }

    default public void onMade(CompositeFood.Builder<?> dish, Ingredient ingredient, CookingVessel vessel, EffectCollector collector) {
    }

    default public void onCrafted(Ingredient ingredient) {
        if (this.isUnderCategoryOf(MaterialCategory.FRUIT) && this.isUnderCategoryOf(MaterialCategory.SUPERNATURAL) && this.isUnderCategoryOf(MaterialCategory.UNKNOWN)) {
            ingredient.addTrait(IngredientTrait.UNDERCOOKED);
        }
    }

    public boolean isUnderCategoryOf(MaterialCategory var1);

    public Set<MaterialCategory> getCategories();

    public String getTranslationKey();

    public static int mixColor(int color1, int color2, float weight) {
        if (weight <= 0.0f) {
            return color1;
        }
        if (weight >= 1.0f) {
            return color2;
        }
        float a = color1 >> 24 & 0xFF;
        float r = color1 >> 16 & 0xFF;
        float g = color1 >> 8 & 0xFF;
        float b = color1 & 0xFF;
        float a1 = color2 >> 24 & 0xFF;
        float r1 = color2 >> 16 & 0xFF;
        float g1 = color2 >> 8 & 0xFF;
        float b1 = color2 & 0xFF;
        a += (a1 - a) * weight;
        r += (r1 - r) * weight;
        g += (g1 - g) * weight;
        b += (b1 - b) * weight;
        a = MathHelper.func_76131_a((float)a, (float)0.0f, (float)255.0f);
        r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)255.0f);
        g = MathHelper.func_76131_a((float)g, (float)0.0f, (float)255.0f);
        b = MathHelper.func_76131_a((float)b, (float)0.0f, (float)255.0f);
        return (int)a << 24 | (int)r << 16 | (int)g << 8 | (int)b;
    }
}

