/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Material;
import snownee.cuisine.util.I18nUtil;

public final class Ingredient {
    private final Material material;
    private Form form;
    private int water;
    private int oil;
    private int doneness;
    private final EnumSet<IngredientTrait> traits;
    private final Set<Effect> effects;

    public Ingredient(Material material) {
        this(material, Form.FULL);
    }

    public Ingredient(Material material, Form form) {
        this(material, form, EnumSet.noneOf(IngredientTrait.class));
    }

    public Ingredient(Material material, Form form, EnumSet<IngredientTrait> traits) {
        this.material = material;
        this.form = form;
        this.traits = traits;
        this.effects = new HashSet<Effect>(4);
        this.water = material.getInitialWaterValue();
        this.oil = material.getInitialOilValue();
        this.doneness = 0;
        material.onCrafted(this);
    }

    public double getFoodLevel() {
        return this.getMaterial().getCategories().size();
    }

    public Material getMaterial() {
        return this.material;
    }

    public float getSaturationModifier() {
        return this.material.getSaturationModifier(this);
    }

    public void setForm(Form form) {
        if (this.material.isValidForm(form)) {
            this.form = form;
        }
    }

    public Form getForm() {
        return this.form;
    }

    public void addTrait(IngredientTrait characteristic) {
        this.traits.add(characteristic);
    }

    public void removeTrait(IngredientTrait trait) {
        this.traits.remove((Object)trait);
    }

    public Set<IngredientTrait> getAllTraits() {
        return Collections.unmodifiableSet(this.traits);
    }

    public boolean hasTrait(IngredientTrait trait) {
        return this.traits.contains((Object)trait);
    }

    public void addEffect(Effect effect) {
        this.effects.add(effect);
    }

    public void removeEffect(Effect effect) {
        this.effects.remove(effect);
    }

    public Set<Effect> getEffects() {
        return Collections.unmodifiableSet(this.effects);
    }

    public int getWater() {
        return this.water;
    }

    public void setWater(int water) {
        this.water = water;
    }

    public int getOil() {
        return this.oil;
    }

    public void setOil(int oil) {
        this.oil = oil;
    }

    public int getDoneness() {
        return this.doneness;
    }

    public void setDoneness(int doneness) {
        if (doneness >= 150 && this.doneness < 150) {
            this.addTrait(IngredientTrait.OVERCOOKED);
        } else if (doneness < 150 && this.doneness >= 150) {
            this.removeTrait(IngredientTrait.OVERCOOKED);
        }
        this.doneness = doneness;
    }

    public boolean equalsIgnoreSize(@Nonnull Ingredient other) {
        return this.getMaterial().equals(other.getMaterial()) && this.getForm().equals((Object)other.getForm()) && this.traits.equals(other.traits);
    }

    public final Ingredient copy() {
        Ingredient theCopy = new Ingredient(this.material, this.form, (EnumSet<IngredientTrait>)this.traits.clone());
        theCopy.water = this.water;
        theCopy.oil = this.oil;
        theCopy.doneness = this.doneness;
        theCopy.effects.addAll(this.effects);
        return theCopy;
    }

    @Deprecated
    public String getTranslation() {
        String ingredientForm = this.getForm().func_176610_l();
        String ingredientMaterial = this.getMaterial().getID();
        if (I18nUtil.canTranslate("ingredient." + ingredientMaterial + '.' + ingredientForm)) {
            return I18nUtil.translate("ingredient." + ingredientMaterial + '.' + ingredientForm);
        }
        String material = I18nUtil.translate("material." + this.getMaterial().getID());
        return I18nUtil.translate("shape." + ingredientForm, material);
    }
}

