/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;

public enum Form implements IStringSerializable
{
    FULL,
    CUBED,
    SLICED,
    SHREDDED,
    DICED,
    MINCED,
    PASTE,
    JUICE;

    public static final EnumSet<Form> ALL_FORMS;
    public static final EnumSet<Form> ALL_FORMS_INCLUDING_JUICE;
    public static final EnumSet<Form> JUICE_ONLY;
    private static final Map<String, Form> LOOKUP_TABLE;
    private final double heatAbsorptionModifier;

    @Nullable
    public static Form of(String name) {
        return LOOKUP_TABLE.get(name);
    }

    @Deprecated
    private Form() {
        this(1.0);
    }

    private Form(double heatAbsorptionModifier) {
        this.heatAbsorptionModifier = heatAbsorptionModifier;
    }

    public double getHeatAbsorptionModifier() {
        return this.heatAbsorptionModifier;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public static Form byActions(int horizontal, int vertical) {
        int min = Math.min(horizontal, vertical);
        int max = Math.max(horizontal, vertical);
        if (max + min > 18) {
            return PASTE;
        }
        if (max + min > 15) {
            return MINCED;
        }
        if (max > 5 && min > 5) {
            return DICED;
        }
        if (max > 5 && min > 1) {
            return SHREDDED;
        }
        if (max > 5) {
            return SLICED;
        }
        if (max > 0) {
            return CUBED;
        }
        return FULL;
    }

    public int[] getStandardActions() {
        switch (this) {
            case PASTE: {
                return new int[]{10, 10};
            }
            case MINCED: {
                return new int[]{8, 8};
            }
            case SLICED: {
                return new int[]{6, 0};
            }
            case SHREDDED: {
                return new int[]{6, 2};
            }
            case DICED: {
                return new int[]{6, 6};
            }
            case CUBED: {
                return new int[]{1, 1};
            }
        }
        return new int[]{0, 0};
    }

    static {
        ALL_FORMS = EnumSet.complementOf(EnumSet.of(FULL, JUICE));
        ALL_FORMS_INCLUDING_JUICE = EnumSet.complementOf(EnumSet.of(FULL));
        JUICE_ONLY = EnumSet.of(JUICE);
        LOOKUP_TABLE = new HashMap<String, Form>(8);
        for (Form form : Form.values()) {
            LOOKUP_TABLE.put(form.name(), form);
        }
    }
}

