/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import mcp.MethodsReturnNonnullByDefault;
import snownee.cuisine.api.CulinarySkill;

@MethodsReturnNonnullByDefault
public final class CulinarySkillManager {
    private Map<CulinarySkill, Integer> mapSkillToLevelRequirement = new IdentityHashMap<CulinarySkill, Integer>();
    private static CulinarySkillManager INSTANCE;

    public static CulinarySkillManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new CulinarySkillManager();
        }
        return INSTANCE;
    }

    public static CulinarySkill register(CulinarySkill type) {
        if (CulinarySkillManager.instance().mapSkillToLevelRequirement.containsKey(type)) {
            throw new IllegalArgumentException("Already registered");
        }
        CulinarySkillManager.instance().mapSkillToLevelRequirement.put(type, type.defaultLevelRequirement());
        return type;
    }

    public static int getLevelRequirement(CulinarySkill skill) {
        return CulinarySkillManager.instance().mapSkillToLevelRequirement.getOrDefault(skill, 0);
    }

    public static Set<CulinarySkill> getSkills() {
        return Collections.unmodifiableSet(CulinarySkillManager.instance().mapSkillToLevelRequirement.keySet());
    }
}

