/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import java.util.Objects;
import snownee.cuisine.api.CuisineAPI;
import snownee.cuisine.api.CulinarySkill;
import snownee.cuisine.api.CulinarySkillManager;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.Spice;
import snownee.cuisine.api.prefab.SimpleCulinarySkillImpl;

public final class CulinaryHub {
    public static CuisineAPI API_INSTANCE;

    public static final class CommonSkills {
        public static final CulinarySkill DOUBLE_CHOPPING = CulinarySkillManager.register(new SimpleCulinarySkillImpl("double_chopping", CulinarySkillPoint.PROFICIENCY, 1));
        public static final CulinarySkill SKILLED_CHOPPING = CulinarySkillManager.register(new SimpleCulinarySkillImpl("skilled_chopping", CulinarySkillPoint.EXPERTISE, 1));
        public static final CulinarySkill BIGGER_SIZE = CulinarySkillManager.register(new SimpleCulinarySkillImpl("bigger_size", CulinarySkillPoint.EXPERTISE, 2));

        public static void init() {
        }
    }

    public static final class CommonEffects {
        public static final Effect EXPERIENCED = CommonEffects.find("experienced");
        public static final Effect GOLDEN_APPLE = CommonEffects.find("golden_apple");
        public static final Effect GOLDEN_APPLE_ENCHANTED = CommonEffects.find("golden_apple_enchanted");
        public static final Effect FLAVOR_ENHANCER = CommonEffects.find("flavor_enhancer");
        public static final Effect HARMONY = CommonEffects.find("harmony");
        public static final Effect ALWAYS_EDIBLE = CommonEffects.find("always_edible");
        public static final Effect JUMP_BOOST = CommonEffects.find("jump_boost");
        public static final Effect POWER = CommonEffects.find("power");
        public static final Effect NIGHT_VISION = CommonEffects.find("night_vision");
        public static final Effect LONGER_NIGHT_VISION = CommonEffects.find("longer_night_vision");
        public static final Effect HOT = CommonEffects.find("hot");
        public static final Effect DISPERSAL = CommonEffects.find("dispersal");
        public static final Effect TELEPORT = CommonEffects.find("teleport");
        public static final Effect PUFFERFISH_POISON = CommonEffects.find("pufferfish_poison");
        public static final Effect WATER_BREATHING = CommonEffects.find("water_breathing");
        public static final Effect CURE_POTIONS = CommonEffects.find("cure_potions");
        public static final Effect HEAT_RESISTANCE = CommonEffects.find("heat_resistance");
        public static final Effect SUSTAINED_RELEASE = CommonEffects.find("sustained_release");
        public static final Effect SPOOKY = CommonEffects.find("spooky");
        public static final Effect RARE = CommonEffects.find("rare");

        private static Effect find(String uniqueName) {
            return API_INSTANCE.findEffect(uniqueName);
        }
    }

    public static final class CommonSpices {
        public static final Spice EDIBLE_OIL = CommonSpices.find("edible_oil");
        public static final Spice SESAME_OIL = CommonSpices.find("sesame_oil");
        public static final Spice SOY_SAUCE = CommonSpices.find("soy_sauce");
        public static final Spice RICE_VINEGAR = CommonSpices.find("rice_vinegar");
        public static final Spice FRUIT_VINEGAR = CommonSpices.find("fruit_vinegar");
        public static final Spice WATER = CommonSpices.find("water");
        public static final Spice CHILI_POWDER = CommonSpices.find("chili_powder");
        public static final Spice SICHUAN_PEPPER_POWDER = CommonSpices.find("sichuan_pepper_powder");
        public static final Spice CRUDE_SALT = CommonSpices.find("crude_salt");
        public static final Spice SALT = CommonSpices.find("salt");
        public static final Spice SUGAR = CommonSpices.find("sugar");
        public static final Spice UNREFINED_SUGAR = CommonSpices.find("unrefined_sugar");

        private static Spice find(String uniqueName) {
            return API_INSTANCE.findSpice(uniqueName);
        }

        private CommonSpices() {
        }
    }

    public static final class CommonMaterials {
        public static final Material PEANUT = CommonMaterials.find("peanut");
        public static final Material SESAME = CommonMaterials.find("sesame");
        public static final Material SOYBEAN = CommonMaterials.find("soybean");
        public static final Material RICE = CommonMaterials.find("rice");
        public static final Material TOMATO = CommonMaterials.find("tomato");
        public static final Material CHILI = CommonMaterials.find("chili");
        public static final Material GARLIC = CommonMaterials.find("garlic");
        public static final Material GINGER = CommonMaterials.find("ginger");
        public static final Material SICHUAN_PEPPER = CommonMaterials.find("sichuan_pepper");
        public static final Material SCALLION = CommonMaterials.find("scallion");
        public static final Material TURNIP = CommonMaterials.find("turnip");
        public static final Material CHINESE_CABBAGE = CommonMaterials.find("chinese_cabbage");
        public static final Material LETTUCE = CommonMaterials.find("lettuce");
        public static final Material CORN = CommonMaterials.find("corn");
        public static final Material CUCUMBER = CommonMaterials.find("cucumber");
        public static final Material GREEN_PEPPER = CommonMaterials.find("green_pepper");
        public static final Material RED_PEPPER = CommonMaterials.find("red_pepper");
        public static final Material LEEK = CommonMaterials.find("leek");
        public static final Material ONION = CommonMaterials.find("onion");
        public static final Material EGGPLANT = CommonMaterials.find("eggplant");
        public static final Material SPINACH = CommonMaterials.find("spinach");
        public static final Material TOFU = CommonMaterials.find("tofu");
        public static final Material CHORUS_FRUIT = CommonMaterials.find("chorus_fruit");
        public static final Material APPLE = CommonMaterials.find("apple");
        public static final Material GOLDEN_APPLE = CommonMaterials.find("golden_apple");
        public static final Material GOLDEN_APPLE_ENCHANTED = CommonMaterials.find("golden_apple_enchanted");
        public static final Material MELON = CommonMaterials.find("melon");
        public static final Material PUMPKIN = CommonMaterials.find("pumpkin");
        public static final Material CARROT = CommonMaterials.find("carrot");
        public static final Material GOLDEN_CARROT = CommonMaterials.find("golden_carrot");
        public static final Material POTATO = CommonMaterials.find("potato");
        public static final Material BEETROOT = CommonMaterials.find("beetroot");
        public static final Material MUSHROOM = CommonMaterials.find("mushroom");
        public static final Material EGG = CommonMaterials.find("egg");
        public static final Material CHICKEN = CommonMaterials.find("chicken");
        public static final Material BEEF = CommonMaterials.find("beef");
        public static final Material PORK = CommonMaterials.find("pork");
        public static final Material MUTTON = CommonMaterials.find("mutton");
        public static final Material RABBIT = CommonMaterials.find("rabbit");
        public static final Material FISH = CommonMaterials.find("fish");
        public static final Material PICKLED = CommonMaterials.find("pickled");
        public static final Material BAMBOO_SHOOT = CommonMaterials.find("bamboo_shoot");
        public static final Material PUFFERFISH = CommonMaterials.find("pufferfish");
        public static final Material CACTUS = CommonMaterials.find("cactus");
        public static final Material WATER = CommonMaterials.find("water");
        public static final Material MILK = CommonMaterials.find("milk");
        public static final Material SOY_MILK = CommonMaterials.find("soy_milk");
        public static final Material MANDARIN = CommonMaterials.find("mandarin");
        public static final Material CITRON = CommonMaterials.find("citron");
        public static final Material POMELO = CommonMaterials.find("pomelo");
        public static final Material ORANGE = CommonMaterials.find("orange");
        public static final Material LEMON = CommonMaterials.find("lemon");
        public static final Material GRAPEFRUIT = CommonMaterials.find("grapefruit");
        public static final Material LIME = CommonMaterials.find("lime");
        public static final Material EMPOWERED_CITRON = CommonMaterials.find("empowered_citron");

        private static Material find(String uniqueName) {
            return Objects.requireNonNull(API_INSTANCE.findMaterial(uniqueName), "Material '" + uniqueName + "' is not found in registry. Typo?");
        }

        private CommonMaterials() {
        }
    }
}

