/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.Recipe;
import snownee.cuisine.api.Spice;
import snownee.kiwi.util.definition.ItemDefinition;

public interface CuisineAPI {
    public Material register(Material var1);

    public Spice register(Spice var1);

    public Effect register(Effect var1);

    public Recipe register(Recipe var1);

    public <F extends CompositeFood> void registerFoodType(ResourceLocation var1, Class<F> var2, Function<F, NBTTagCompound> var3, Function<NBTTagCompound, F> var4);

    default public void registerMapping(ItemDefinition item, Material material) {
        this.registerMapping(item, new Ingredient(material));
    }

    default public void registerMapping(String ore, Material material) {
        this.registerMapping(ore, new Ingredient(material));
    }

    public void registerMapping(ItemDefinition var1, Ingredient var2);

    public void registerMapping(String var1, Ingredient var2);

    public void registerMapping(ItemDefinition var1, Spice var2);

    public void registerMapping(String var1, Spice var2);

    public <F extends CompositeFood> NBTTagCompound serialize(F var1);

    @Nullable
    public <F extends CompositeFood> F deserialize(ResourceLocation var1, NBTTagCompound var2);

    public Collection<Material> getKnownMaterials();

    public Collection<Spice> getKnownSpices();

    public Collection<Effect> getKnownEffects();

    @Deprecated
    @Nullable
    default public Recipe tryMatchRecipe(CompositeFood food) {
        return null;
    }

    public Material findMaterial(String var1);

    public Spice findSpice(String var1);

    public Effect findEffect(String var1);

    @Deprecated
    default public Material findMaterial(ItemStack item) {
        Ingredient ingredient = this.findIngredient(item);
        return ingredient == null ? null : ingredient.getMaterial();
    }

    @Deprecated
    default public Material findMaterial(@Nullable FluidStack fluid) {
        Ingredient ingredient = this.findIngredient(fluid);
        return ingredient == null ? null : ingredient.getMaterial();
    }

    public Spice findSpice(ItemStack var1);

    public Spice findSpice(@Nullable FluidStack var1);

    public boolean isKnownIngredient(ItemStack var1);

    public boolean isKnownIngredient(@Nullable FluidStack var1);

    public boolean isKnownSpice(ItemStack var1);

    public boolean isKnownSpice(@Nullable FluidStack var1);

    @Nullable
    public Ingredient findIngredient(ItemStack var1);

    @Nullable
    public Ingredient findIngredient(@Nullable FluidStack var1);

    public Potion getEffectResistancePotion();

    public FluidStack makeJuiceFluid(Material var1, int var2);
}

