/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import snownee.cuisine.api.CookingStrategy;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.api.Spice;
import snownee.cuisine.api.prefab.DefaultConsumedCollector;

public abstract class CompositeFood {
    protected static final int DEFAULT_SERVE_AMOUNT = 8;
    private static final double DEFAULT_MAX_SIZE = 8.0;
    protected final List<Ingredient> ingredients;
    protected final List<Seasoning> seasonings;
    protected final List<Effect> effects;
    private final float saturationModifier;
    private final int foodLevel;
    private float useDurationModifier = 1.0f;
    private double qualityBonus = 1.0;
    private int durability;
    private int maxServeSize;

    protected CompositeFood(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects) {
        this(ingredients, seasonings, effects, 0, 0.0f);
    }

    public CompositeFood(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects, int hungerRestore, float saturation) {
        this(ingredients, seasonings, effects, hungerRestore, saturation, 8);
    }

    protected CompositeFood(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects, int hungerRestore, float saturation, int serve_amount) {
        this.ingredients = ingredients;
        this.seasonings = seasonings;
        this.effects = effects;
        this.maxServeSize = this.durability = serve_amount;
        this.foodLevel = hungerRestore;
        this.saturationModifier = saturation;
    }

    public abstract ResourceLocation getIdentifier();

    public abstract Collection<String> getKeywords();

    public final List<Ingredient> getIngredients() {
        return Collections.unmodifiableList(this.ingredients);
    }

    public final List<Seasoning> getSeasonings() {
        return Collections.unmodifiableList(this.seasonings);
    }

    public final List<Effect> getEffects() {
        return Collections.unmodifiableList(this.effects);
    }

    public final Set<Effect> getMergedEffects() {
        Set<Effect> effects = this.getIngredients().stream().map(Ingredient::getEffects).flatMap(Collection::stream).collect(Collectors.toSet());
        effects.addAll(this.getEffects());
        return effects;
    }

    public final boolean isEmpty() {
        return this.durability < 1 || this.maxServeSize < 1 || this.ingredients.isEmpty();
    }

    public boolean contains(Material material) {
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.getMaterial() != material) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Spice spice) {
        for (Seasoning seasoning : this.seasonings) {
            if (seasoning.getSpice() != spice) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Effect effect) {
        return this.effects.contains(effect) || this.ingredients.stream().anyMatch(i -> i.getEffects().contains(effect));
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public void setQualityBonus(double qualityBonus) {
        this.qualityBonus = qualityBonus;
    }

    public double getQualityBonus() {
        return this.qualityBonus;
    }

    public boolean alwaysEdible() {
        return this.contains(CulinaryHub.CommonEffects.ALWAYS_EDIBLE);
    }

    public double getMaxSize() {
        return 8.0;
    }

    public int getServes() {
        return this.durability;
    }

    public void setServes(int durability) {
        this.durability = MathHelper.func_76125_a((int)durability, (int)0, (int)this.getMaxServes());
    }

    public int getMaxServes() {
        return this.maxServeSize;
    }

    public void setMaxServes(int maxServes) {
        this.maxServeSize = maxServes;
    }

    public float getUseDurationModifier() {
        return this.useDurationModifier;
    }

    public void setUseDurationModifier(float useDurationModifier) {
        this.useDurationModifier = useDurationModifier;
    }

    public boolean isHavingSideEffect() {
        return !this.effects.isEmpty();
    }

    public void onEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        Collection<EffectBinding> bindings = this.getEffectBindings();
        DefaultConsumedCollector collector = new DefaultConsumedCollector(this.getFoodLevel());
        for (EffectBinding binding : bindings) {
            binding.effect.onEaten(stack, player, this, binding.ingredients, collector);
        }
        for (Seasoning seasoning : this.seasonings) {
            seasoning.getSpice().onConsumed(stack, player, worldIn, seasoning, collector);
        }
        collector.apply(this, player);
        int countOvercooked = (int)this.getIngredients().stream().filter(i -> i.getAllTraits().contains((Object)IngredientTrait.OVERCOOKED)).count();
        int newFoodLevel = collector.getNewFoodLevel() - countOvercooked;
        if (newFoodLevel > 0) {
            player.func_71024_bL().func_75122_a(newFoodLevel, this.getSaturationModifier());
        }
    }

    protected Collection<EffectBinding> getEffectBindings() {
        HashMultimap effectMap = HashMultimap.create();
        for (Ingredient ingredient : this.ingredients) {
            ingredient.getEffects().forEach(arg_0 -> CompositeFood.lambda$getEffectBindings$2((Multimap)effectMap, ingredient, arg_0));
        }
        this.effects.forEach(arg_0 -> CompositeFood.lambda$getEffectBindings$3((Multimap)effectMap, arg_0));
        ArrayList<EffectBinding> bindings = new ArrayList<EffectBinding>();
        effectMap.keySet().forEach(arg_0 -> CompositeFood.lambda$getEffectBindings$4(bindings, (Multimap)effectMap, arg_0));
        Collections.sort(bindings);
        return bindings;
    }

    public ItemStack makeItemStack() {
        ItemStack dishItem = this.getBaseItem();
        FoodContainer container = (FoodContainer)dishItem.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container == null) {
            throw new NullPointerException("Target ItemStack does not supports FoodContainer capability");
        }
        container.set(this);
        return dishItem;
    }

    public abstract ItemStack getBaseItem();

    public abstract String getOrComputeModelType();

    @Deprecated
    public abstract void setModelType(String var1);

    private static /* synthetic */ void lambda$getEffectBindings$4(List bindings, Multimap effectMap, Effect effect) {
        bindings.add(new EffectBinding(effectMap.get((Object)effect).stream().collect(Collectors.toList()), effect));
    }

    private static /* synthetic */ void lambda$getEffectBindings$3(Multimap effectMap, Effect effect) {
        effectMap.put((Object)effect, null);
    }

    private static /* synthetic */ void lambda$getEffectBindings$2(Multimap effectMap, Ingredient ingredient, Effect effect) {
        effectMap.put((Object)effect, (Object)ingredient);
    }

    public static abstract class Builder<F extends CompositeFood> {
        private List<Ingredient> ingredients;
        private List<Seasoning> seasonings;
        private List<Effect> effects;

        protected Builder() {
            this(new ArrayList<Ingredient>(), new ArrayList<Seasoning>(), new ArrayList<Effect>());
        }

        protected Builder(CompositeFood finishedDish) {
            this(finishedDish.ingredients, finishedDish.seasonings, finishedDish.effects);
        }

        protected Builder(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects) {
            this.ingredients = ingredients;
            this.seasonings = seasonings;
            this.effects = effects;
        }

        public abstract Class<F> getType();

        public List<Ingredient> getIngredients() {
            return this.ingredients;
        }

        public List<Seasoning> getSeasonings() {
            return this.seasonings;
        }

        public List<Effect> getEffects() {
            return this.effects;
        }

        public boolean contains(Material mat) {
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient.getMaterial() != mat) continue;
                return true;
            }
            return false;
        }

        public boolean contains(Spice spice) {
            for (Seasoning seasoning : this.seasonings) {
                if (seasoning.getSpice() != spice) continue;
                return true;
            }
            return false;
        }

        public int getMaxIngredientLimit() {
            return 6;
        }

        public boolean canAddIntoThis(EntityPlayer cook, Ingredient ingredient, CookingVessel vessel) {
            return this.ingredients.size() >= this.getMaxIngredientLimit() || ingredient.getMaterial().canAddInto(this, ingredient);
        }

        public boolean canAddIntoThis(EntityPlayer cook, Seasoning seasoning, CookingVessel vessel) {
            return true;
        }

        public boolean addIngredient(EntityPlayer cook, Ingredient ingredient, CookingVessel vessel) {
            if (this.canAddIntoThis(cook, ingredient, vessel)) {
                if (this.ingredients.size() >= this.getMaxIngredientLimit()) {
                    return false;
                }
                this.ingredients.add(ingredient);
                ingredient.getMaterial().onAddedInto(this, ingredient, vessel);
                return true;
            }
            return false;
        }

        public boolean addSeasoning(EntityPlayer cook, Seasoning seasoning, CookingVessel vessel) {
            if (this.canAddIntoThis(cook, seasoning, vessel)) {
                boolean merged = false;
                for (Seasoning s : this.seasonings) {
                    if (!s.matchType(seasoning)) continue;
                    s.merge(seasoning);
                    merged = true;
                    break;
                }
                if (!merged) {
                    this.seasonings.add(seasoning);
                }
                seasoning.getSpice().onAddedInto(this, vessel);
                return true;
            }
            return false;
        }

        public void addEffect(Effect e) {
            this.effects.add(e);
        }

        public boolean removeIngredient(Ingredient ingredient) {
            return this.ingredients.remove(ingredient);
        }

        public boolean removeSeasoning(Seasoning seasoning) {
            boolean changed = false;
            Iterator<Seasoning> itr = this.seasonings.iterator();
            while (itr.hasNext()) {
                Seasoning s = itr.next();
                if (!s.matchType(seasoning)) continue;
                s.decreaseSizeBy(seasoning.getSize());
                if (s.getSize() <= 0) {
                    s.getSpice().onRemovedFrom(this);
                    itr.remove();
                }
                changed = true;
                break;
            }
            return changed;
        }

        public final void apply(CookingStrategy strategy, CookingVessel vessel) {
            strategy.beginCook(this);
            for (Seasoning seasoning : this.seasonings) {
                strategy.preCook(seasoning, vessel);
            }
            for (Ingredient ingredient : this.ingredients) {
                strategy.cook(ingredient, vessel);
            }
            strategy.postCook(this, vessel);
            strategy.endCook();
        }

        public abstract Optional<F> build(CookingVessel var1, EntityPlayer var2);
    }

    public static class EffectBinding
    implements Comparable<EffectBinding> {
        public final Effect effect;
        public final List<Ingredient> ingredients;

        public EffectBinding(List<Ingredient> ingredients, @Nonnull Effect effect) {
            this.ingredients = ingredients;
            this.effect = effect;
        }

        @Override
        public int compareTo(@Nonnull EffectBinding another) {
            return Integer.compare(another.effect.getPriority(), this.effect.getPriority());
        }
    }
}

