/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.client.model.ChoppingBoardModel;
import snownee.cuisine.plugins.jei.JEICompat;

@Config(modid="cuisine", name="cuisine", category="")
@Mod.EventBusSubscriber(modid="cuisine")
public final class CuisineConfig {
    @Config.Comment(value={"General settings of Cuisine."})
    @Config.LangKey(value="cuisine.config.general")
    @Config.Name(value="General")
    public static final General GENERAL = new General();
    @Config.Comment(value={"Config options of Cuisine Hardcore Module."})
    @Config.LangKey(value="cuisine.config.hardcore")
    @Config.Name(value="Hardcore")
    public static final Hardcore HARDCORE = new Hardcore();
    @Config.Comment(value={"Configurable variables related to world generation"})
    @Config.LangKey(value="cuisine.config.world_gen")
    @Config.Name(value="WorldGen")
    public static final WorldGen WORLD_GEN = new WorldGen();
    @Config.Name(value="Client")
    public static final Client CLIENT = new Client();
    @Config.Name(value="Compat")
    public static final Compat COMPAT = new Compat();

    private CuisineConfig() {
        throw new UnsupportedOperationException("No instance for you");
    }

    @SubscribeEvent
    public static void onConfigReload(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("cuisine")) {
            ConfigManager.sync((String)"cuisine", (Config.Type)Config.Type.INSTANCE);
            ChoppingBoardModel.updateSpecialItemList(CuisineConfig.CLIENT.useBlockModelForChoppingBoardFirst);
            try {
                if (Loader.isModLoaded((String)"jei")) {
                    JEICompat.updateAxesList(CuisineConfig.CLIENT.axeList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class Compat {
        @Config.Name(value="NormalNutrientModifier")
        public float normalNutrientModifier = 0.5f;
        @Config.Name(value="SupernaturalNutrientModifier")
        public float supernaturalNutrientModifier = 0.2f;
    }

    public static final class Client {
        @Config.Comment(value={"List of axes that will show in JEI recipes. Does not affect chopping board behavior."})
        @Config.LangKey(value="cuisine.config.progression.axe_list")
        @Config.Name(value="AxeList")
        public String[] axeList = new String[]{"minecraft:wooden_axe", "minecraft:stone_axe", "minecraft:iron_axe", "minecraft:golden_axe", "minecraft:diamond_axe"};
        @Config.LangKey(value="cuisine.config.general.always_render_drinkro")
        @Config.Comment(value={"Rendering contents in all directions. WIP feature."})
        @Config.Name(value="AlwaysRenderDrinkro")
        public boolean alwaysRenderDrinkro = false;
        @Config.Name(value="ShowHoloGui")
        public boolean showHoloGui = true;
        @Config.Name(value="ShowTooltipIcons")
        public boolean showTooltipIcons = true;
        @Config.Comment(value={"List of items that, when functions as chopping board base, will attempt to find the correct block model when the board is rendered. See https://github.com/Snownee/Cuisine/issues/80 for more details."})
        @Config.LangKey(value="cuisine.config.progression.block_model_for_chopping_board")
        @Config.Name(value="PrioritizedBlockModelForChoppingBoard")
        public String[] useBlockModelForChoppingBoardFirst = new String[]{"tfc:wood/log/acacia", "tfc:wood/log/ash", "tfc:wood/log/aspen", "tfc:wood/log/birch", "tfc:wood/log/blackwood", "tfc:wood/log/chestnut", "tfc:wood/log/douglas_fir", "tfc:wood/log/hickory", "tfc:wood/log/kapok", "tfc:wood/log/maple", "tfc:wood/log/oak", "tfc:wood/log/palm", "tfc:wood/log/pine", "tfc:wood/log/rosewood", "tfc:wood/log/sequoia", "tfc:wood/log/spruce", "tfc:wood/log/sycamore", "tfc:wood/log/white_cedar", "tfc:wood/log/willow"};
    }

    public static final class WorldGen {
        @Config.Comment(value={"Generation rate of fruit trees; larger value means higher generation rate; set to 0 to disable."})
        @Config.LangKey(value="cuisine.config.general.fruit_trees_gen_rate")
        @Config.Name(value="FruitTreesGenWeight")
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int fruitTreesGenRate = 50;
        @Config.Name(value="FruitTreesGenDimensions")
        @Config.RequiresMcRestart
        public int[] fruitTreesGenDimensions = new int[]{0};
        @Config.Comment(value={"Generation rate of bamboo; larger value means higher generation rate; set to 0 to disable."})
        @Config.LangKey(value="cuisine.config.general.bamboos_gen_rate")
        @Config.Name(value="BamboosGenWeight")
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int bamboosGenRate = 6;
        @Config.Name(value="BamboosGenDimensions")
        @Config.RequiresMcRestart
        public int[] bamboosGenDimensions = new int[]{0};
        @Config.Name(value="LegacyBamboosGen")
        public boolean legacyBambooGen = false;
        @Config.Comment(value={"Generation rate of wild crops; larger value means higher generation rate; set to 0 to disable."})
        @Config.LangKey(value="cuisine.config.general.crops_gen_rate")
        @Config.Name(value="CropsGenWeight")
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int cropsGenRate = 40;
        @Config.Name(value="CropsGenDimensions")
        @Config.RequiresMcRestart
        public int[] cropsGenDimensions = new int[]{0};
        @Config.Name(value="DisableCropGenIdList")
        @Config.RequiresMcRestart
        public String[] disableCropGenIdList = new String[0];
    }

    public static final class Hardcore {
        @Config.Comment(value={"If true, hardcore module will be turned on."})
        @Config.LangKey(value="cuisine.config.hardcore.enable")
        @Config.Name(value="Enable")
        @Config.RequiresMcRestart
        public boolean enable = true;
        @Config.Comment(value={"If true, bread will require mill to make."})
        @Config.LangKey(value="cuisine.config.hardcore.bread")
        @Config.Name(value="HardcoreBread")
        @Config.RequiresMcRestart
        public boolean harderBreadProduction = true;
        @Config.Comment(value={"If true, cookie will require furnace to make."})
        @Config.LangKey(value="cuisine.config.hardcore.cookie")
        @Config.Name(value="HardcoreCookie")
        @Config.RequiresMcRestart
        public boolean harderCookieProduction = true;
        @Config.Comment(value={"If true, sugar will require mill to make."})
        @Config.LangKey(value="cuisine.config.hardcore.sugar")
        @Config.Name(value="HardcoreSugar")
        @Config.RequiresMcRestart
        public boolean harderSugarProduction = true;
        @Config.Comment(value={"If true, certain foods will give you fewer heal amount and saturation."})
        @Config.LangKey(value="cuisine.config.hardcore.food_level_lose")
        @Config.Name(value="HardcoreFoodLevel")
        @Config.RequiresMcRestart
        public boolean lowerFoodLevel = true;
        @Config.Comment(value={"If HardcoreFoodLevel is enabled, this will determine how much heal amount and saturation you can still get."})
        @Config.LangKey(value="cuisine.config.hardcore.food_level_retain_ratio")
        @Config.Name(value="FoodLevelRetainRatio")
        public double foodLevelRetainRatio = 0.5;
        @Config.Name(value="DisableGenericFood")
        @Config.RequiresMcRestart
        public boolean disableGenericFood = false;
        @Config.Name(value="DisableGenericFoodBlacklist")
        @Config.RequiresMcRestart
        public String[] disableGenericFoodBlacklist = new String[0];
        @Config.Comment(value={"If HardcoreFoodLevel is enabled, food item that is listed here will NOT be affected."})
        @Config.LangKey(value="cuisine.config.hardcore.food_level_lose_blacklist")
        @Config.Name(value="FoodLevelDowngradeBlacklist")
        public String[] lowerFoodLevelBlacklist = new String[0];
        @Config.Comment(value={"If true, player will lose culinary skill points when they died."})
        @Config.LangKey(value="cuisine.config.general.skill_lose_on_death")
        @Config.Name(value="HardcoreCulinarySkill")
        public boolean loseSkillPointsOnDeath = false;
        @Config.Comment(value={"If Culinary Skill Downgrade on Death is enabled, this will determines how many point are kept.", "For example, 0.5 means 50% are kept."})
        @Config.LangKey(value="cuisine.config.general.skill_retain_ratio")
        @Config.Name(value="CulinarySkillRetainRatio")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double skillPointsRetainRatio = 1.0;
        @Config.Name(value="BadSkillPunishment")
        public boolean badSkillPunishment = true;

        Hardcore() {
        }
    }

    public static final class General {
        @Config.Comment(value={"Automatically unlock all recipes for all newly spawned players."})
        @Config.LangKey(value="cuisine.config.general.auto_recipe_unlocking")
        @Config.Name(value="AutoRecipeUnlocking")
        public boolean autoRecipeUnlocking = true;
        @Config.Comment(value={"Give player the manual of Cuisine Mod when they firstly spawn in world."})
        @Config.LangKey(value="cuisine.config.general.spawn_book")
        @Config.Name(value="SpawnBook")
        @Config.RequiresMcRestart
        public boolean spawnBook = true;
        @Config.LangKey(value="cuisine.config.general.fruit_growing_speed")
        @Config.Name(value="FruitGrowingSpeed")
        @Config.RangeInt(min=0, max=100)
        public int fruitGrowingSpeed = 10;
        @Config.LangKey(value="cuisine.config.general.fruit_drops")
        @Config.Name(value="FruitDrops")
        public boolean fruitDrops = true;
        @Config.Name(value="PassableLeaves")
        public boolean passableLeaves = false;
        @Config.Comment(value={"If true, bamboo can be used as a blowpipe which can shoot seeds."})
        @Config.LangKey(value="cuisine.config.general.bamboo_blowpipe")
        @Config.Name(value="BambooBlowpipe")
        @Config.RequiresMcRestart
        public boolean bambooBlowpipe = false;
        @Config.Comment(value={"Allow axes to chop things on chopping board. Provided for mod pack creators."})
        @Config.LangKey(value="cuisine.config.progression.axe_chopping")
        @Config.Name(value="AxeChopping")
        public boolean axeChopping = true;
        @Config.Name(value="AxeChoppingPlanksOutput")
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1, max=64)
        public int axeChoppingPlanksOutput = 6;
        @Config.Name(value="AxeChoppingStickOutput")
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1, max=64)
        public int axeChoppingStickOutput = 4;
        @Config.Comment(value={"Length of one mill working cycle, measured in ticks. Ideally, there are 20 ticks in 1 second."})
        @Config.LangKey(value="cuisine.config.general.mill_work_cycle")
        @Config.Name(value="MillWorkCycle")
        @Config.RangeInt(min=5)
        public int millWorkPeriod = 160;
        @Config.Comment(value={"If true, natural sunlight will be considered as a valid heat source for earthen basin."})
        @Config.LangKey(value="cuisine.config.general.basin_heating_in_daylight")
        @Config.Name(value="BasinHeatingInDaylight")
        @Config.RequiresMcRestart
        public boolean basinHeatingInDaylight = true;
        @Config.Name(value="BasinConvertingConcrete")
        @Config.RequiresMcRestart
        public boolean basinConvertingConcrete = true;
        @Config.Name(value="EnableSqueezer")
        public boolean enableSqueezer = true;
        @Config.Name(value="SqueezerUsesFE")
        @Config.RequiresMcRestart
        public int squeezerUsesFE = 0;
        @Config.Name(value="DrinkroUsesFE")
        @Config.RequiresMcRestart
        public int drinkroUsesFE = 0;
        @Config.Name(value="BasicSeedsWeight")
        @Config.RequiresMcRestart
        public int basicSeedsWeight = 5;
        @Config.Name(value="BetterHarvest")
        @Config.RequiresMcRestart
        public boolean betterHarvest = true;
        @Config.Name(value="BetterHarvestBlacklist")
        @Config.RequiresMcRestart
        public String[] betterHarvestBlacklist = new String[0];
        @Config.Name(value="AttachWaterBottleCapability")
        @Config.Comment(value={"one = 250mB"})
        @Config.RequiresMcRestart
        public boolean attachWaterBottleCapability = true;
        @Config.Name(value="WinePotionDurationModifier")
        public float winePotionDurationModifier = 1.0f;
        @Config.Name(value="JuiceSqueezingAmount")
        @Config.Comment(value={"Juice squeezing amount in mB"})
        public int juiceSqueezingAmount = 250;
        @Config.Name(value="RareCrops")
        public boolean rareCrops = true;

        General() {
        }
    }
}

