/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine;

import java.util.Arrays;
import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineItemGroup;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.CuisineSidedProxy;
import snownee.cuisine.command.CommandRegistry;
import snownee.cuisine.crafting.DrinkBrewingRecipe;
import snownee.cuisine.crafting.RecipeRegistry;
import snownee.cuisine.events.BetterHarvest;
import snownee.cuisine.events.DisableGenericFood;
import snownee.cuisine.events.OreDictHandler;
import snownee.cuisine.events.SpawnHandler;
import snownee.cuisine.internal.CuisineInternalGateway;
import snownee.cuisine.internal.capabilities.CulinarySkillCapability;
import snownee.cuisine.internal.capabilities.FoodContainerCapability;
import snownee.cuisine.items.BehaviorArmDispense;
import snownee.cuisine.items.BehaviorWokInteraction;
import snownee.cuisine.items.ItemCrops;
import snownee.cuisine.network.CuisineGuiHandler;
import snownee.cuisine.network.PacketCustomEvent;
import snownee.cuisine.network.PacketNameFood;
import snownee.cuisine.network.PacketSkillLevelIncreased;
import snownee.cuisine.world.gen.WorldGenBamboo;
import snownee.cuisine.world.gen.WorldGenCitrusTrees;
import snownee.cuisine.world.gen.WorldGenGarden;
import snownee.kiwi.item.IVariant;
import snownee.kiwi.network.NetworkChannel;

@Mod(modid="cuisine", name="Cuisine", version="0.5.22-build929", useMetadata=true, acceptedMinecraftVersions="[1.12, 1.13)")
public class Cuisine {
    public static final String MODID = "cuisine";
    public static final String NAME = "Cuisine";
    public static final CreativeTabs CREATIVE_TAB = new CuisineItemGroup();
    public static Logger logger;
    private static final Cuisine INSTANCE;
    @SidedProxy(serverSide="snownee.cuisine.server.CuisineServerProxy", clientSide="snownee.cuisine.client.CuisineClientProxy")
    public static CuisineSidedProxy sidedDelegate;
    public static boolean aprilFools;

    @Mod.InstanceFactory
    public static Cuisine getInstance() {
        return INSTANCE;
    }

    private Cuisine() {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Calendar calendar = Calendar.getInstance();
        aprilFools = calendar.get(2) == 3 && calendar.get(5) == 1;
        CuisineInternalGateway.init();
        CulinarySkillCapability.init();
        FoodContainerCapability.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CuisineInternalGateway.deferredInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new CuisineGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpawnHandler());
        if (CuisineConfig.GENERAL.betterHarvest) {
            MinecraftForge.EVENT_BUS.register((Object)new BetterHarvest());
        }
        if (CuisineConfig.HARDCORE.enable && CuisineConfig.HARDCORE.disableGenericFood) {
            MinecraftForge.EVENT_BUS.register((Object)new DisableGenericFood());
        }
        BlockDispenser.field_149943_a.func_82595_a((Object)CuisineRegistry.MATERIAL, (Object)new BehaviorArmDispense());
        BehaviorWokInteraction behaviorWokInteraction = new BehaviorWokInteraction();
        BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)CuisineRegistry.PLACED_DISH), (Object)behaviorWokInteraction);
        BlockDispenser.field_149943_a.func_82595_a((Object)CuisineRegistry.SPICE_BOTTLE, (Object)behaviorWokInteraction);
        BlockDispenser.field_149943_a.func_82595_a((Object)CuisineRegistry.IRON_SPATULA, (Object)behaviorWokInteraction);
        BlockDispenser.field_149943_a.func_82595_a((Object)CuisineRegistry.INGREDIENT, (Object)behaviorWokInteraction);
        OreDictHandler.init();
        RecipeRegistry.init();
        NetworkChannel.INSTANCE.register(PacketCustomEvent.class);
        NetworkChannel.INSTANCE.register(PacketSkillLevelIncreased.class);
        NetworkChannel.INSTANCE.register(PacketNameFood.class);
        if (CuisineConfig.GENERAL.basicSeedsWeight > 0) {
            MinecraftForge.addGrassSeed((ItemStack)CuisineRegistry.CROPS.getItemStack(ItemCrops.Variant.SESAME), (int)CuisineConfig.GENERAL.basicSeedsWeight);
            MinecraftForge.addGrassSeed((ItemStack)CuisineRegistry.CROPS.getItemStack(ItemCrops.Variant.SOYBEAN), (int)CuisineConfig.GENERAL.basicSeedsWeight);
            MinecraftForge.addGrassSeed((ItemStack)CuisineRegistry.CROPS.getItemStack(ItemCrops.Variant.PEANUT), (int)CuisineConfig.GENERAL.basicSeedsWeight);
        }
        Arrays.sort(CuisineConfig.WORLD_GEN.bamboosGenDimensions);
        Arrays.sort(CuisineConfig.WORLD_GEN.fruitTreesGenDimensions);
        Arrays.sort(CuisineConfig.WORLD_GEN.cropsGenDimensions);
        if (CuisineConfig.WORLD_GEN.cropsGenRate > 0 && CuisineConfig.WORLD_GEN.cropsGenDimensions.length > 0) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new WorldGenGarden());
        }
        if (CuisineConfig.WORLD_GEN.bamboosGenRate > 0 && CuisineConfig.WORLD_GEN.bamboosGenDimensions.length > 0) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new WorldGenBamboo());
        }
        if (CuisineConfig.WORLD_GEN.fruitTreesGenRate > 0 && CuisineConfig.WORLD_GEN.fruitTreesGenDimensions.length > 0) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new WorldGenCitrusTrees());
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new DrinkBrewingRecipe());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeRegistry.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        CommandRegistry.registryCommands(e);
    }

    static {
        INSTANCE = new Cuisine();
        FluidRegistry.enableUniversalBucket();
    }

    public static enum Materials implements IVariant<Void>
    {
        WOODEN_ARM,
        WOODEN_HANDLE,
        SALT,
        CRUDE_SALT,
        CHILI_POWDER,
        SICHUAN_PEPPER_POWDER,
        BAMBOO_CHARCOAL,
        UNREFINED_SUGAR;


        public int getMeta() {
            return this.ordinal();
        }

        public Void getValue() {
            return null;
        }
    }
}

