/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.tileentitiy;

import cjminecraft.doubleslabs.util.WorldWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityVerticalSlab
extends TileEntity
implements ITickable {
    protected IBlockState negativeState;
    protected IBlockState positiveState;
    protected TileEntity negativeTile;
    protected TileEntity positiveTile;
    private WorldWrapper negativeWorld;
    private WorldWrapper positiveWorld;

    public WorldWrapper getNegativeWorld() {
        return this.negativeWorld;
    }

    public WorldWrapper getPositiveWorld() {
        return this.positiveWorld;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.negativeWorld = new WorldWrapper(world);
        this.negativeWorld.setVerticalSlab(this, false);
        this.positiveWorld = new WorldWrapper(world);
        this.positiveWorld.setVerticalSlab(this, true);
        if (this.negativeTile != null) {
            this.negativeTile.func_145834_a((World)this.negativeWorld);
        }
        if (this.positiveTile != null) {
            this.positiveTile.func_145834_a((World)this.positiveWorld);
        }
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        if (this.negativeTile != null) {
            this.negativeTile.func_174878_a(this.field_174879_c);
        }
        if (this.positiveTile != null) {
            this.positiveTile.func_174878_a(this.field_174879_c);
        }
    }

    public IBlockState getNegativeState() {
        return this.negativeState;
    }

    public IBlockState getPositiveState() {
        return this.positiveState;
    }

    public void setNegativeState(IBlockState negativeState) {
        if (this.negativeState != null && this.negativeState.func_177230_c().func_149716_u() && this.negativeTile != null) {
            this.negativeTile.func_145836_u();
        }
        if (this.negativeState != null && negativeState != null && (this.negativeState.func_177230_c() != negativeState.func_177230_c() || !negativeState.func_177230_c().func_149716_u()) && this.negativeState.func_177230_c().func_149716_u()) {
            this.setNegativeTile(null);
        }
        if (this.negativeState == null) {
            this.setNegativeTile(null);
        }
        this.negativeState = negativeState;
        if (negativeState != null && negativeState.func_177230_c().func_149716_u()) {
            if (this.negativeTile == null) {
                this.setNegativeTile(negativeState.func_177230_c().createTileEntity((World)this.negativeWorld, this.negativeState));
            } else {
                this.negativeTile.func_145836_u();
            }
        }
        this.markDirtyClient();
    }

    public void setPositiveState(IBlockState positiveState) {
        if (this.positiveState != null && this.positiveState.func_177230_c().func_149716_u() && this.positiveTile != null) {
            this.positiveTile.func_145836_u();
        }
        if (this.positiveState != null && positiveState != null && (this.positiveState.func_177230_c() != positiveState.func_177230_c() || !positiveState.func_177230_c().func_149716_u()) && this.positiveState.func_177230_c().func_149716_u()) {
            this.setPositiveTile(null);
        }
        if (this.positiveState == null) {
            this.setPositiveTile(null);
        }
        this.positiveState = positiveState;
        if (positiveState != null && positiveState.func_177230_c().func_149716_u()) {
            if (this.positiveTile == null) {
                this.setPositiveTile(positiveState.func_177230_c().createTileEntity((World)this.positiveWorld, this.positiveState));
            } else {
                this.positiveTile.func_145836_u();
            }
        }
        this.markDirtyClient();
    }

    public TileEntity getNegativeTile() {
        return this.negativeTile;
    }

    public void setNegativeTile(TileEntity negativeTile) {
        this.prepareTile(negativeTile, false);
        this.negativeTile = negativeTile;
    }

    public TileEntity getPositiveTile() {
        return this.positiveTile;
    }

    public void setPositiveTile(TileEntity positiveTile) {
        this.prepareTile(positiveTile, true);
        this.positiveTile = positiveTile;
    }

    private void prepareTile(TileEntity tile, boolean positive) {
        if (tile != null) {
            tile.func_145834_a(this.field_145850_b);
            tile.func_174878_a(this.field_174879_c);
            if (positive) {
                if (this.positiveTile != null) {
                    this.positiveTile.func_145843_s();
                } else if (this.negativeTile != null) {
                    this.negativeTile.func_145843_s();
                }
            }
            tile.onLoad();
            tile.func_145834_a((World)(positive ? this.positiveWorld : this.negativeWorld));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.negativeState != null) {
            nbt.func_74782_a("negative", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.negativeState));
        }
        if (this.negativeTile != null) {
            nbt.func_74782_a("negative_tile", (NBTBase)this.negativeTile.func_189515_b(new NBTTagCompound()));
        }
        if (this.positiveState != null) {
            nbt.func_74782_a("positive", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.positiveState));
        }
        if (this.positiveTile != null) {
            nbt.func_74782_a("positive_tile", (NBTBase)this.positiveTile.func_189515_b(new NBTTagCompound()));
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound read) {
        super.func_145839_a(read);
        if (read.func_74764_b("negative")) {
            this.negativeState = NBTUtil.func_190008_d((NBTTagCompound)read.func_74775_l("negative"));
        }
        if (read.func_74764_b("negative_tile")) {
            this.negativeTile = TileEntity.func_190200_a((World)this.field_145850_b, (NBTTagCompound)read.func_74775_l("negative_tile"));
        }
        if (read.func_74764_b("positive")) {
            this.positiveState = NBTUtil.func_190008_d((NBTTagCompound)read.func_74775_l("positive"));
        }
        if (read.func_74764_b("positive_tile")) {
            this.positiveTile = TileEntity.func_190200_a((World)this.field_145850_b, (NBTTagCompound)read.func_74775_l("positive_tile"));
        }
        this.markDirtyClient();
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.func_145839_a(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        int metadata = this.func_145832_p();
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound getTileData() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_175664_x(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && this.positiveWorld != null && this.negativeWorld != null) {
            if (this.positiveTile != null && this.positiveTile instanceof ITickable) {
                if (this.positiveTile.func_145831_w() == null) {
                    this.positiveTile.func_145834_a((World)this.positiveWorld);
                    this.positiveTile.func_174878_a(this.field_174879_c);
                }
                ((ITickable)this.positiveTile).func_73660_a();
            }
            if (this.negativeTile != null && this.negativeTile instanceof ITickable) {
                if (this.negativeTile.func_145831_w() == null) {
                    this.negativeTile.func_145834_a((World)this.negativeWorld);
                    this.negativeTile.func_174878_a(this.field_174879_c);
                }
                ((ITickable)this.negativeTile).func_73660_a();
            }
        }
    }

    public void onLoad() {
        if (this.positiveTile != null) {
            this.positiveTile.func_145834_a((World)this.positiveWorld);
            this.positiveTile.func_174878_a(this.field_174879_c);
            this.positiveTile.onLoad();
        }
        if (this.negativeTile != null) {
            this.negativeTile.func_145834_a((World)this.negativeWorld);
            this.negativeTile.func_174878_a(this.field_174879_c);
            this.negativeTile.onLoad();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.positiveTile != null) {
            this.positiveTile.onChunkUnload();
        }
        if (this.negativeTile != null) {
            this.negativeTile.onChunkUnload();
        }
    }

    public void func_189667_a(Rotation rotation) {
        super.func_189667_a(rotation);
        if (this.positiveTile != null) {
            this.positiveTile.func_189667_a(rotation);
        }
        if (this.negativeTile != null) {
            this.negativeTile.func_189667_a(rotation);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.positiveTile != null) {
            this.positiveTile.func_145834_a(this.field_145850_b);
            this.positiveTile.func_145843_s();
        }
        if (this.negativeTile != null) {
            this.negativeTile.func_145834_a(this.field_145850_b);
            this.negativeTile.func_145843_s();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.positiveTile != null) {
            this.positiveTile.func_145829_t();
        }
        if (this.negativeTile != null) {
            this.negativeTile.func_145829_t();
        }
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.positiveTile != null) {
            this.positiveTile.func_145836_u();
        }
        if (this.negativeTile != null) {
            this.negativeTile.func_145836_u();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.positiveTile != null && this.positiveTile.hasCapability(capability, facing) || this.negativeTile != null && this.negativeTile.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.positiveTile != null && this.negativeTile == null) {
            return (T)this.positiveTile.getCapability(capability, facing);
        }
        if (this.negativeTile != null && this.positiveTile == null) {
            return (T)this.negativeTile.getCapability(capability, facing);
        }
        if (this.positiveTile != null && this.negativeTile != null) {
            if (this.positiveTile.hasCapability(capability, facing)) {
                return (T)this.positiveTile.getCapability(capability, facing);
            }
            if (this.negativeTile.hasCapability(capability, facing)) {
                return (T)this.negativeTile.getCapability(capability, facing);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

