/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.network;

import cjminecraft.doubleslabs.tileentitiy.TileEntityVerticalSlab;
import cjminecraft.doubleslabs.util.WorldWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketOpenGui
implements IMessage {
    private int windowId;
    private String modId;
    private int modGuiId;
    private int x;
    private int y;
    private int z;
    private boolean positive;

    public PacketOpenGui() {
    }

    public PacketOpenGui(int windowId, String modId, int modGuiId, int x, int y, int z, boolean positive) {
        this.windowId = windowId;
        this.modId = modId;
        this.modGuiId = modGuiId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.positive = positive;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.modId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.modGuiId = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.positive = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modId);
        buf.writeInt(this.modGuiId);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.positive);
    }

    public static class Handler
    implements IMessageHandler<PacketOpenGui, IMessage> {
        public IMessage onMessage(PacketOpenGui message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                return null;
            }
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
            if (thread.func_152345_ab()) {
                this.process(message);
            } else {
                thread.func_152344_a(() -> this.process(message));
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void process(PacketOpenGui message) {
            EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
            World world = player.field_70170_p;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof TileEntityVerticalSlab) {
                WorldWrapper worldWrapper = world = message.positive ? ((TileEntityVerticalSlab)tile).getPositiveWorld() : ((TileEntityVerticalSlab)tile).getNegativeWorld();
            }
            if ((tile = world.func_175625_s(pos)) != null) {
                tile.func_145834_a(world);
            }
            player.openGui((Object)message.modId, message.modGuiId, world, message.x, message.y, message.z);
            player.field_71070_bA.field_75152_c = message.windowId;
        }
    }
}

