/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.DoubleSlabsConfig;
import cjminecraft.doubleslabs.Utils;
import cjminecraft.doubleslabs.blocks.BlockVerticalSlab;
import cjminecraft.doubleslabs.client.model.DoubleSlabBakedModel;
import cjminecraft.doubleslabs.util.Quaternion;
import cjminecraft.doubleslabs.util.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class VerticalSlabBakedModel
extends DoubleSlabBakedModel {
    public static final ModelResourceLocation variantTag = new ModelResourceLocation(new ResourceLocation("doubleslabs", "vertical_slab"), "normal");
    private static final Quaternion NORTH_ROTATION = Vector3f.XP.rotationDegrees(90.0f);
    private static final Quaternion SOUTH_ROTATION = Vector3f.XN.rotationDegrees(90.0f);
    private static final Quaternion WEST_ROTATION = Vector3f.ZN.rotationDegrees(90.0f);
    private static final Quaternion EAST_ROTATION = Vector3f.ZP.rotationDegrees(90.0f);
    private static final Quaternion ROTATE_X_90 = Vector3f.XP.rotationDegrees(90.0f);
    private static final Quaternion ROTATE_X_270 = Vector3f.XP.rotationDegrees(270.0f);
    private static final Quaternion ROTATE_Z_180 = Vector3f.ZP.rotationDegrees(180.0f);
    private final Map<String, List<BakedQuad>> cache = new HashMap<String, List<BakedQuad>>();
    private final Map<IBlockState, IBakedModel> models = new HashMap<IBlockState, IBakedModel>();

    public void addModel(IBakedModel model, IBlockState state) {
        this.models.put(state, model);
    }

    private static int[] rotateVertexData(int[] vertexData, EnumFacing direction, @Nullable EnumFacing side, boolean positiveState) {
        int[] data = new int[vertexData.length];
        int[] vertexOrder = new int[vertexData.length / 7];
        for (int i = 0; i < vertexData.length / 7; ++i) {
            float x = Float.intBitsToFloat(vertexData[i * 7]) - 0.5f;
            float y = Float.intBitsToFloat(vertexData[i * 7 + 1]) - 0.5f;
            float z = Float.intBitsToFloat(vertexData[i * 7 + 2]) - 0.5f;
            Vector3f vec = new Vector3f(x, y, z);
            vertexOrder[i] = i;
            switch (direction) {
                case NORTH: {
                    if (side != null) {
                        vertexOrder[i] = side == EnumFacing.NORTH ? i % 4 : (side == EnumFacing.SOUTH ? (i + 2) % 4 : (side == EnumFacing.WEST ? (i + 1) % 4 : (side == EnumFacing.EAST ? (i + 3) % 4 : (side == EnumFacing.UP ? (i + 2) % 4 : i % 4))));
                    }
                    vec.transform(NORTH_ROTATION);
                    if (side != direction) break;
                    vec.transform(ROTATE_Z_180);
                    break;
                }
                case SOUTH: {
                    if (side != null) {
                        vertexOrder[i] = side == EnumFacing.NORTH ? (i + 2) % 4 : (side == EnumFacing.SOUTH ? i % 4 : (side == EnumFacing.WEST ? (i + 3) % 4 : (side == EnumFacing.EAST ? (i + 1) % 4 : (side == EnumFacing.UP ? i % 4 : (i + 2) % 4))));
                    }
                    vec.transform(SOUTH_ROTATION);
                    if (side == direction) break;
                    vec.transform(ROTATE_Z_180);
                    break;
                }
                case WEST: {
                    if (side != null) {
                        vertexOrder[i] = side == EnumFacing.NORTH ? (i + 3) % 4 : (side == EnumFacing.SOUTH ? (i + 1) % 4 : (side == EnumFacing.EAST ? (i + 2) % 4 : i % 4));
                    }
                    vec.transform(WEST_ROTATION);
                    if (side != direction) {
                        vec.transform(ROTATE_X_90);
                        break;
                    }
                    vec.transform(ROTATE_X_270);
                    break;
                }
                case EAST: {
                    if (side != null) {
                        vertexOrder[i] = side == EnumFacing.NORTH ? (i + 1) % 4 : (side == EnumFacing.SOUTH ? (i + 3) % 4 : (side == EnumFacing.EAST ? i % 4 : (i + 2) % 4));
                    }
                    vec.transform(EAST_ROTATION);
                    if (side != direction) {
                        vec.transform(ROTATE_X_90);
                        break;
                    }
                    vec.transform(ROTATE_X_270);
                    break;
                }
            }
            if (side == null) {
                vertexOrder[i] = i;
            }
            float transformedX = vec.getX() + 0.5f;
            float transformedY = vec.getY() + 0.5f;
            float transformedZ = vec.getZ() + 0.5f;
            data[i * 7] = Float.floatToRawIntBits(transformedX);
            data[i * 7 + 1] = Float.floatToRawIntBits(transformedY);
            data[i * 7 + 2] = Float.floatToRawIntBits(transformedZ);
            data[i * 7 + 3] = vertexData[i * 7 + 3];
            data[i * 7 + 4] = vertexData[i * 7 + 4];
            data[i * 7 + 5] = vertexData[i * 7 + 5];
        }
        int[] finalData = new int[data.length];
        for (int i = 0; i < vertexOrder.length; ++i) {
            int j = !Utils.isOptiFineInstalled() ? vertexOrder[i] * 7 : i * 7;
            finalData[i * 7] = data[j];
            finalData[i * 7 + 1] = data[j + 1];
            finalData[i * 7 + 2] = data[j + 2];
            finalData[i * 7 + 3] = data[j + 3];
            finalData[i * 7 + 4] = data[j + 4];
            finalData[i * 7 + 5] = data[j + 5];
        }
        ForgeHooksClient.fillNormal((int[])finalData, (EnumFacing)direction);
        return finalData;
    }

    private List<BakedQuad> getQuadsForState(@Nullable IBlockState state, @Nullable EnumFacing side, long rand, int tintOffset, IBlockState slabState, boolean positiveState, boolean rotate) {
        if (state == null) {
            return new ArrayList<BakedQuad>();
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (!rotate) {
            return new ArrayList<BakedQuad>(model.func_188616_a(state, side, rand));
        }
        EnumFacing direction = (EnumFacing)slabState.func_177229_b((IProperty)BlockVerticalSlab.FACING);
        List quads = model.func_188616_a(state, Utils.rotateFace(side, direction), rand);
        if (DoubleSlabsConfig.useLazyModel(state)) {
            IBlockState state1 = (positiveState ? slabState : slabState.func_177226_a((IProperty)BlockVerticalSlab.FACING, (Comparable)direction.func_176734_d())).func_177226_a((IProperty)BlockVerticalSlab.DOUBLE, (Comparable)Boolean.valueOf(false));
            if (quads.size() == 0) {
                return new ArrayList<BakedQuad>();
            }
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).func_187508_a();
            IBakedModel blockModel = this.models.get(state1);
            if (blockModel != null) {
                return new SimpleBakedModel.Builder(state, blockModel, sprite, BlockPos.field_177992_a).func_177645_b().func_188616_a(state, side, rand);
            }
        }
        return new ArrayList<BakedQuad>(quads.stream().map(quad -> {
            int[] vertexData = VerticalSlabBakedModel.rotateVertexData(quad.func_178209_a(), direction, side, positiveState);
            return new BakedQuad(vertexData, quad.func_178212_b() ? quad.func_178211_c() + tintOffset : -1, FaceBakery.func_178410_a((int[])vertexData), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
        }).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return VerticalSlabBakedModel.getFallback().func_188616_a(null, side, rand);
        }
        IBlockState negativeState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockVerticalSlab.NEGATIVE);
        IBlockState positiveState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockVerticalSlab.POSITIVE);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BlockVerticalSlab.FACING);
        String cacheKey = (negativeState != null ? negativeState.toString() : "null") + "," + (positiveState != null ? positiveState.toString() : "null") + ":" + (side != null ? side.func_176610_l() : "null") + ":" + (MinecraftForgeClient.getRenderLayer() != null ? MinecraftForgeClient.getRenderLayer().toString() : "null") + "," + direction.func_176610_l();
        if (!this.cache.containsKey(cacheKey)) {
            boolean shouldCull = positiveState != null && negativeState != null && DoubleSlabsConfig.shouldCull(positiveState) && DoubleSlabsConfig.shouldCull(negativeState);
            boolean negativeTransparent = negativeState != null && Utils.isTransparent(negativeState);
            boolean positiveTransparent = positiveState != null && Utils.isTransparent(positiveState);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (positiveState != null && (MinecraftForgeClient.getRenderLayer() == positiveState.func_177230_c().func_180664_k() || MinecraftForgeClient.getRenderLayer() == null)) {
                List<BakedQuad> positiveQuads = this.getQuadsForState(positiveState, side, rand, 0, ((IExtendedBlockState)state).getClean(), true, (Boolean)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockVerticalSlab.ROTATE_POSITIVE));
                if (shouldCull && (!negativeTransparent && !positiveTransparent || positiveTransparent && !negativeTransparent || positiveTransparent && negativeTransparent)) {
                    positiveQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction.func_176734_d());
                }
                quads.addAll(positiveQuads);
            }
            if (negativeState != null && (MinecraftForgeClient.getRenderLayer() == negativeState.func_177230_c().func_180664_k() || MinecraftForgeClient.getRenderLayer() == null)) {
                List<BakedQuad> negativeQuads = this.getQuadsForState(negativeState, side, rand, 1000, ((IExtendedBlockState)state).getClean(), false, (Boolean)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockVerticalSlab.ROTATE_NEGATIVE));
                if (shouldCull && (!positiveTransparent && !negativeTransparent || negativeTransparent && !positiveTransparent || positiveTransparent && negativeTransparent)) {
                    negativeQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction);
                }
                quads.addAll(negativeQuads);
            }
            this.cache.put(cacheKey, quads);
            return quads;
        }
        return this.cache.get(cacheKey);
    }
}

