/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.DoubleSlabsConfig;
import cjminecraft.doubleslabs.Utils;
import cjminecraft.doubleslabs.blocks.BlockDoubleSlab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class DoubleSlabBakedModel
implements IBakedModel {
    public static final int TINT_OFFSET = 1000;
    public static final ModelResourceLocation variantTag = new ModelResourceLocation(new ResourceLocation("doubleslabs", "double_slab"), "normal");
    private static IBakedModel fallback;
    private final Map<String, List<BakedQuad>> cache = new HashMap<String, List<BakedQuad>>();

    static IBakedModel getFallback() {
        if (fallback != null) {
            return fallback;
        }
        fallback = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
        return fallback;
    }

    private List<BakedQuad> getQuadsForState(@Nullable IBlockState state, @Nullable EnumFacing side, long rand, int tintOffset) {
        if (state == null) {
            return new ArrayList<BakedQuad>();
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        return model.func_188616_a(state, side, rand).stream().map(quad -> new BakedQuad(quad.func_178209_a(), quad.func_178212_b() ? quad.func_178211_c() + tintOffset : -1, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat())).collect(Collectors.toList());
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return DoubleSlabBakedModel.getFallback().func_188616_a(null, side, rand);
        }
        IBlockState topState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockDoubleSlab.TOP);
        IBlockState bottomState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockDoubleSlab.BOTTOM);
        String cacheKey = (bottomState != null ? bottomState.toString() : "null") + "," + (topState != null ? topState.toString() : "null") + ":" + (side != null ? side.func_176610_l() : "null") + ":" + (MinecraftForgeClient.getRenderLayer() != null ? MinecraftForgeClient.getRenderLayer().toString() : "null");
        if (!this.cache.containsKey(cacheKey)) {
            if (topState == null || bottomState == null) {
                List quads = DoubleSlabBakedModel.getFallback().func_188616_a(null, side, rand);
                this.cache.put(cacheKey, quads);
                return quads;
            }
            boolean shouldCull = DoubleSlabsConfig.shouldCull(topState) && DoubleSlabsConfig.shouldCull(bottomState);
            boolean topTransparent = Utils.isTransparent(topState);
            boolean bottomTransparent = Utils.isTransparent(bottomState);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (MinecraftForgeClient.getRenderLayer() == topState.func_177230_c().func_180664_k() || MinecraftForgeClient.getRenderLayer() == null) {
                List<BakedQuad> topQuads = this.getQuadsForState(topState, side, rand, 0);
                if (shouldCull && (!bottomTransparent && !topTransparent || topTransparent && !bottomTransparent || topTransparent && bottomTransparent)) {
                    topQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == EnumFacing.DOWN);
                }
                quads.addAll(topQuads);
            }
            if (MinecraftForgeClient.getRenderLayer() == bottomState.func_177230_c().func_180664_k() || MinecraftForgeClient.getRenderLayer() == null) {
                List<BakedQuad> bottomQuads = this.getQuadsForState(bottomState, side, rand, 1000);
                if (shouldCull && (!topTransparent && !bottomTransparent || bottomTransparent && !topTransparent || topTransparent && bottomTransparent)) {
                    bottomQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == EnumFacing.UP);
                }
                quads.addAll(bottomQuads);
            }
            this.cache.put(cacheKey, quads);
            return quads;
        }
        return this.cache.get(cacheKey);
    }

    public boolean func_177555_b() {
        return DoubleSlabBakedModel.getFallback().func_177555_b();
    }

    public boolean func_177556_c() {
        return DoubleSlabBakedModel.getFallback().func_177556_c();
    }

    public boolean func_188618_c() {
        return DoubleSlabBakedModel.getFallback().func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return DoubleSlabBakedModel.getFallback().func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return DoubleSlabBakedModel.getFallback().func_188617_f();
    }
}

