/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.blocks;

import cjminecraft.doubleslabs.Registrar;
import cjminecraft.doubleslabs.Utils;
import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IContainerSupport;
import cjminecraft.doubleslabs.api.ISlabSupport;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.blocks.BlockDoubleSlab;
import cjminecraft.doubleslabs.blocks.properties.UnlistedPropertyBlockState;
import cjminecraft.doubleslabs.blocks.properties.UnlistedPropertyBoolean;
import cjminecraft.doubleslabs.network.NetworkUtils;
import cjminecraft.doubleslabs.tileentitiy.TileEntityVerticalSlab;
import cjminecraft.doubleslabs.util.WorldWrapper;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockVerticalSlab
extends Block {
    public static final UnlistedPropertyBlockState POSITIVE = new UnlistedPropertyBlockState();
    public static final UnlistedPropertyBlockState NEGATIVE = new UnlistedPropertyBlockState();
    public static final UnlistedPropertyBoolean ROTATE_POSITIVE = new UnlistedPropertyBoolean();
    public static final UnlistedPropertyBoolean ROTATE_NEGATIVE = new UnlistedPropertyBoolean();
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (com.google.common.base.Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool DOUBLE = PropertyBool.func_177716_a((String)"double");

    public BlockVerticalSlab() {
        super(Material.field_151576_e);
        this.setRegistryName("doubleslabs", "vertical_slab");
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(false)));
    }

    public static Optional<TileEntityVerticalSlab> getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return world.func_180495_p(pos).func_177230_c() == Registrar.VERTICAL_SLAB && tile instanceof TileEntityVerticalSlab ? Optional.of((TileEntityVerticalSlab)tile) : Optional.empty();
    }

    public static Optional<IBlockState> getAvailableState(IBlockAccess world, BlockPos pos) {
        return BlockVerticalSlab.getTile(world, pos).flatMap(tile -> tile.getPositiveState() != null ? Optional.of(tile.getPositiveState()) : Optional.of(tile.getNegativeState()));
    }

    public static Optional<IBlockState> getHalfState(IBlockAccess world, BlockPos pos, double x, double z) {
        IBlockState state = world.func_180495_p(pos);
        return BlockVerticalSlab.getTile(world, pos).flatMap(tile -> {
            Optional<IBlockState> optional;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() != EnumFacing.AxisDirection.POSITIVE) break block4;
                            double d = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z;
                            if (!(d > 0.5)) break block5;
                            break block6;
                        }
                        if ((((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z) < 0.5) break block6;
                    }
                    if (tile.getNegativeState() != null) break block7;
                }
                if (tile.getPositiveState() != null) {
                    optional = Optional.of(tile.getPositiveState());
                    return optional;
                }
            }
            optional = Optional.of(tile.getNegativeState());
            return optional;
        });
    }

    public static Optional<Pair<IBlockState, WorldWrapper>> getHalfStateWithWorld(IBlockAccess world, BlockPos pos, double x, double z) {
        IBlockState state = world.func_180495_p(pos);
        return BlockVerticalSlab.getTile(world, pos).flatMap(tile -> {
            Optional<Pair> optional;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() != EnumFacing.AxisDirection.POSITIVE) break block4;
                            double d = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z;
                            if (!(d > 0.5)) break block5;
                            break block6;
                        }
                        if ((((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z) < 0.5) break block6;
                    }
                    if (tile.getNegativeState() != null) break block7;
                }
                if (tile.getPositiveState() != null) {
                    optional = Optional.of(Pair.of((Object)tile.getPositiveState(), (Object)((Object)tile.getPositiveWorld())));
                    return optional;
                }
            }
            optional = Optional.of(Pair.of((Object)tile.getNegativeState(), (Object)((Object)tile.getNegativeWorld())));
            return optional;
        });
    }

    public static int min(IBlockAccess world, BlockPos pos, ToIntFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> Math.min(tile.getPositiveState() != null ? converter.applyAsInt(tile.getPositiveState()) : Integer.MAX_VALUE, tile.getNegativeState() != null ? converter.applyAsInt(tile.getNegativeState()) : Integer.MAX_VALUE)).orElse(0);
    }

    public static float minFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> Math.min(tile.getPositiveState() != null ? converter.applyAsDouble(tile.getPositiveState()) : 2.147483647E9, tile.getNegativeState() != null ? converter.applyAsDouble(tile.getNegativeState()) : 2.147483647E9)).orElse(0.0).floatValue();
    }

    public static int max(IBlockAccess world, BlockPos pos, ToIntFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> Math.max(tile.getPositiveState() != null ? converter.applyAsInt(tile.getPositiveState()) : 0, tile.getNegativeState() != null ? converter.applyAsInt(tile.getNegativeState()) : 0)).orElse(0);
    }

    public static int maxWithWorld(IBlockAccess world, BlockPos pos, ToIntFunction<Pair<IBlockState, WorldWrapper>> converter) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> Math.max(tile.getPositiveState() != null ? converter.applyAsInt(Pair.of((Object)tile.getPositiveState(), (Object)((Object)tile.getPositiveWorld()))) : 0, tile.getNegativeState() != null ? converter.applyAsInt(Pair.of((Object)tile.getNegativeState(), (Object)((Object)tile.getNegativeWorld()))) : 0)).orElse(0);
    }

    public static float maxFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> Math.max(tile.getPositiveState() != null ? converter.applyAsDouble(tile.getPositiveState()) : 0.0, tile.getNegativeState() != null ? converter.applyAsDouble(tile.getNegativeState()) : 0.0)).orElse(0.0).floatValue();
    }

    public static float addFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> (tile.getPositiveState() != null ? converter.applyAsDouble(tile.getPositiveState()) : 0.0) + (tile.getNegativeState() != null ? converter.applyAsDouble(tile.getNegativeState()) : 0.0)).orElse(0.0).floatValue();
    }

    public static void runIfAvailable(IBlockAccess world, BlockPos pos, Consumer<IBlockState> consumer) {
        BlockVerticalSlab.getTile(world, pos).map(tile -> {
            if (tile.getPositiveState() != null) {
                consumer.accept(tile.getPositiveState());
            }
            if (tile.getNegativeState() != null) {
                consumer.accept(tile.getNegativeState());
            }
            return null;
        });
    }

    public static boolean both(IBlockAccess world, BlockPos pos, Predicate<IBlockState> predicate) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null && tile.getNegativeState() != null && predicate.test(tile.getPositiveState()) && predicate.test(tile.getNegativeState())).orElse(false);
    }

    public static boolean either(IBlockAccess world, BlockPos pos, Predicate<IBlockState> predicate) {
        return BlockVerticalSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null && predicate.test(tile.getPositiveState()) || tile.getNegativeState() != null && predicate.test(tile.getNegativeState())).orElse(false);
    }

    public static Optional<IExtendedBlockState> getTileState(IBlockState state) {
        if (!(state.func_177230_c() instanceof BlockVerticalSlab)) {
            return Optional.empty();
        }
        if (state instanceof IExtendedBlockState) {
            return Optional.of((IExtendedBlockState)state);
        }
        return Optional.empty();
    }

    public static Optional<IBlockState> getAvailableState(IBlockState state) {
        return BlockVerticalSlab.getTileState(state).flatMap(s -> s.getValue((IUnlistedProperty)POSITIVE) != null ? Optional.of(s.getValue((IUnlistedProperty)POSITIVE)) : Optional.of(s.getValue((IUnlistedProperty)NEGATIVE)));
    }

    public static Optional<IBlockState> getHalfState(IBlockState state, double x, double z) {
        return BlockVerticalSlab.getTileState(state).flatMap(s -> {
            Optional<Object> optional;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() != EnumFacing.AxisDirection.POSITIVE) break block4;
                            double d = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z;
                            if (!(d > 0.5)) break block5;
                            break block6;
                        }
                        if ((((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z) < 0.5) break block6;
                    }
                    if (s.getValue((IUnlistedProperty)NEGATIVE) != null) break block7;
                }
                if (s.getValue((IUnlistedProperty)POSITIVE) != null) {
                    optional = Optional.of(s.getValue((IUnlistedProperty)POSITIVE));
                    return optional;
                }
            }
            optional = Optional.of(s.getValue((IUnlistedProperty)NEGATIVE));
            return optional;
        });
    }

    public static int min(IBlockState state, ToIntFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTileState(state).map(s -> Math.min(s.getValue((IUnlistedProperty)POSITIVE) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) : Integer.MAX_VALUE, s.getValue((IUnlistedProperty)NEGATIVE) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE)) : Integer.MAX_VALUE)).orElse(0);
    }

    public static float minFloat(IBlockState state, ToDoubleFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTileState(state).map(s -> Math.min(s.getValue((IUnlistedProperty)POSITIVE) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) : 2.147483647E9, s.getValue((IUnlistedProperty)NEGATIVE) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE)) : 2.147483647E9)).orElse(0.0).floatValue();
    }

    public static int max(IBlockState state, ToIntFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTileState(state).map(s -> Math.max(s.getValue((IUnlistedProperty)POSITIVE) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) : 0, s.getValue((IUnlistedProperty)NEGATIVE) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE)) : 0)).orElse(0);
    }

    public static float maxFloat(IBlockState state, ToDoubleFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTileState(state).map(s -> Math.max(s.getValue((IUnlistedProperty)POSITIVE) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) : 0.0, s.getValue((IUnlistedProperty)NEGATIVE) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE)) : 0.0)).orElse(0.0).floatValue();
    }

    public static float addFloat(IBlockState state, ToDoubleFunction<IBlockState> converter) {
        return BlockVerticalSlab.getTileState(state).map(s -> (s.getValue((IUnlistedProperty)POSITIVE) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) : 0.0) + (s.getValue((IUnlistedProperty)NEGATIVE) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE)) : 0.0)).orElse(0.0).floatValue();
    }

    public static void runIfAvailable(IBlockState state, Consumer<IBlockState> consumer) {
        BlockVerticalSlab.getTileState(state).map(s -> {
            if (s.getValue((IUnlistedProperty)POSITIVE) != null) {
                consumer.accept((IBlockState)s.getValue((IUnlistedProperty)POSITIVE));
            }
            if (s.getValue((IUnlistedProperty)NEGATIVE) != null) {
                consumer.accept((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE));
            }
            return null;
        });
    }

    public static boolean both(IBlockState state, Predicate<IBlockState> predicate) {
        return BlockVerticalSlab.getTileState(state).map(s -> s.getValue((IUnlistedProperty)POSITIVE) != null && s.getValue((IUnlistedProperty)NEGATIVE) != null && predicate.test((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) && predicate.test((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE))).orElse(false);
    }

    public static boolean either(IBlockState state, Predicate<IBlockState> predicate) {
        return BlockVerticalSlab.getTileState(state).map(s -> s.getValue((IUnlistedProperty)POSITIVE) != null && predicate.test((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) || s.getValue((IUnlistedProperty)NEGATIVE) != null && predicate.test((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE))).orElse(false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{POSITIVE, NEGATIVE, ROTATE_POSITIVE, ROTATE_NEGATIVE}).add(new IProperty[]{FACING, DOUBLE}).build();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityVerticalSlab && actualState instanceof IExtendedBlockState) {
            TileEntityVerticalSlab te = (TileEntityVerticalSlab)tile;
            boolean rotatePositive = true;
            boolean rotateNegative = true;
            if (te.getPositiveState() != null && SlabSupport.getVerticalSlabSupport(world, pos, te.getPositiveState()) != null) {
                rotatePositive = false;
            }
            if (te.getNegativeState() != null && SlabSupport.getVerticalSlabSupport(world, pos, te.getNegativeState()) != null) {
                rotateNegative = false;
            }
            return ((IExtendedBlockState)actualState).withProperty((IUnlistedProperty)POSITIVE, (Object)te.getPositiveState()).withProperty((IUnlistedProperty)NEGATIVE, (Object)te.getNegativeState()).withProperty((IUnlistedProperty)ROTATE_POSITIVE, (Object)rotatePositive).withProperty((IUnlistedProperty)ROTATE_NEGATIVE, (Object)rotateNegative);
        }
        return state;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityVerticalSlab();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DOUBLE);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DOUBLE);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)DOUBLE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)DOUBLE)).booleanValue()) {
            return field_185505_j;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        double min = 0.0;
        double max = 8.0;
        if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            min = 8.0;
            max = 16.0;
        }
        if (tileEntity != null) {
            boolean negative;
            TileEntityVerticalSlab tile = (TileEntityVerticalSlab)tileEntity;
            boolean positive = tile.getPositiveState() != null;
            boolean bl = negative = tile.getNegativeState() != null;
            if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.POSITIVE && positive || ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.NEGATIVE && negative) {
                min = 8.0;
                max = 16.0;
            } else {
                min = 0.0;
                max = 8.0;
            }
        }
        if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X) {
            return new AxisAlignedBB(min / 16.0, 0.0, 0.0, max / 16.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, min / 16.0, 1.0, 1.0, max / 16.0);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        boolean positive = BlockVerticalSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null).orElse(true);
        return (Boolean)state.func_177229_b((IProperty)DOUBLE) == false && face == (positive ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)FACING)) ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean func_189872_a(IBlockState state, Entity entity) {
        return BlockVerticalSlab.getTileState(state).map(s -> s.getValue((IUnlistedProperty)POSITIVE) != null && ((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)).func_189884_a(entity) && s.getValue((IUnlistedProperty)NEGATIVE) != null && ((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE)).func_189884_a(entity)).orElse(false);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (entity != null) {
            return BlockVerticalSlab.getHalfState((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(s -> s.func_177230_c().getSoundType(s, world, pos, entity)).orElse(super.getSoundType(state, world, pos, entity));
        }
        return BlockVerticalSlab.getAvailableState((IBlockAccess)world, pos).map(s -> s.func_177230_c().getSoundType(s, world, pos, entity)).orElse(super.getSoundType(state, world, pos, null));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return BlockVerticalSlab.maxFloat((IBlockAccess)world, pos, s -> s.func_177230_c().getExplosionResistance(world, pos, exploder, explosion));
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public boolean func_176214_u(IBlockState state) {
        return BlockVerticalSlab.getTileState(state).map(s -> s.getValue((IUnlistedProperty)POSITIVE) != null && !Utils.isTransparent((IBlockState)s.getValue((IUnlistedProperty)POSITIVE)) && s.getValue((IUnlistedProperty)NEGATIVE) != null && !Utils.isTransparent((IBlockState)s.getValue((IUnlistedProperty)NEGATIVE))).orElse(true);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getLightOpacity(state, world, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockVerticalSlab.max(world, pos, s -> s.getLightValue(world, pos));
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return null;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return BlockVerticalSlab.either(world, pos, s -> BlockDoubleSlab.canHarvestBlock(s.func_177230_c(), player, s));
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        Vec3d hitVec;
        RayTraceResult rayTraceResult = Utils.rayTrace(player);
        Vec3d vec3d = hitVec = rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK ? rayTraceResult.field_72307_f : null;
        if (hitVec == null) {
            return BlockVerticalSlab.minFloat((IBlockAccess)world, pos, s -> BlockDoubleSlab.blockStrength(s, player, world, pos));
        }
        return BlockVerticalSlab.getHalfState((IBlockAccess)world, pos, hitVec.field_72450_a - (double)pos.func_177958_n(), hitVec.field_72449_c - (double)pos.func_177952_p()).map(s -> Float.valueOf(BlockDoubleSlab.blockStrength(s, player, world, pos))).orElse(Float.valueOf(super.func_180647_a(state, player, world, pos))).floatValue();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return BlockVerticalSlab.getHalfState((IBlockAccess)world, pos, target.field_72307_f.field_72450_a - (double)pos.func_177958_n(), target.field_72307_f.field_72449_c - (double)pos.func_177952_p()).map(s -> s.func_177230_c().getPickBlock(s, target, world, pos, player)).orElse(ItemStack.field_190927_a);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        if (player.func_184812_l_() && player.func_70093_af()) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        BlockVerticalSlab.runIfAvailable(world, pos, s -> s.func_177230_c().getDrops(drops, world, pos, s, fortune));
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.func_184812_l_()) {
            TileEntityVerticalSlab tile = (TileEntityVerticalSlab)world.func_175625_s(pos);
            if (tile != null) {
                if (tile.getPositiveState() != null) {
                    tile.getPositiveState().func_177230_c().func_180663_b((World)tile.getPositiveWorld(), pos, Blocks.field_150350_a.func_176223_P());
                }
                if (tile.getNegativeState() != null) {
                    tile.getNegativeState().func_177230_c().func_180663_b((World)tile.getNegativeWorld(), pos, Blocks.field_150350_a.func_176223_P());
                }
            }
            super.func_176208_a(world, pos, state, player);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        Vec3d hitVec;
        RayTraceResult rayTraceResult = Utils.rayTrace(player);
        Vec3d vec3d = hitVec = rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK ? rayTraceResult.field_72307_f : null;
        if (hitVec == null || te == null) {
            super.func_180657_a(world, player, pos, state, te, stack);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else {
            IBlockState remainingState;
            if (((Boolean)state.func_177229_b((IProperty)DOUBLE)).booleanValue()) {
                IBlockState stateToRemove;
                double distance;
                TileEntityVerticalSlab tile = (TileEntityVerticalSlab)te;
                double d = distance = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? hitVec.field_72450_a - (double)pos.func_177958_n() : hitVec.field_72449_c - (double)pos.func_177952_p();
                boolean positive = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? distance > 0.5 : distance < 0.5;
                IBlockState iBlockState = stateToRemove = positive ? tile.getPositiveState() : tile.getNegativeState();
                if (!player.func_184812_l_()) {
                    stateToRemove.func_177230_c().func_180657_a((World)(positive ? tile.getPositiveWorld() : tile.getNegativeWorld()), player, pos, stateToRemove, positive ? tile.getPositiveTile() : tile.getNegativeTile(), stack);
                }
                if (!world.field_72995_K) {
                    stateToRemove.func_177230_c().func_180663_b((World)(positive ? tile.getPositiveWorld() : tile.getNegativeWorld()), pos, stateToRemove);
                }
                if (positive) {
                    tile.setPositiveState(null);
                } else {
                    tile.setNegativeState(null);
                }
                world.func_180501_a(pos, this.getExtendedState(state.func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(false)), (IBlockAccess)world, pos), 3);
                return;
            }
            TileEntityVerticalSlab tile = (TileEntityVerticalSlab)te;
            IBlockState iBlockState = remainingState = tile.getPositiveState() != null ? tile.getPositiveState() : tile.getNegativeState();
            if (!player.func_184812_l_()) {
                remainingState.func_177230_c().func_180657_a((World)(tile.getPositiveState() != null ? tile.getPositiveWorld() : tile.getNegativeWorld()), player, pos, remainingState, tile.getPositiveState() != null ? tile.getPositiveTile() : tile.getNegativeTile(), stack);
            }
            if (!world.field_72995_K) {
                remainingState.func_177230_c().func_180663_b((World)(tile.getPositiveState() != null ? tile.getPositiveWorld() : tile.getNegativeWorld()), pos, remainingState);
            }
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        world.func_175713_t(pos);
    }

    public boolean addLandingEffects(IBlockState state1, WorldServer worldserver, BlockPos pos, IBlockState state2, EntityLivingBase entity, int numberOfParticles) {
        float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
        double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int numOfParticles = (Boolean)state1.func_177229_b((IProperty)DOUBLE) != false ? (int)(75.0 * d0) : (int)(150.0 * d0);
        BlockVerticalSlab.runIfAvailable((IBlockAccess)worldserver, pos, s -> worldserver.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)s)}));
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            BlockVerticalSlab.runIfAvailable((IBlockAccess)world, pos, s -> world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)s)}));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            return BlockVerticalSlab.getHalfState((IBlockAccess)world, target.func_178782_a(), target.field_72307_f.field_72450_a, target.field_72307_f.field_72449_c).map(s -> {
                BlockPos pos = target.func_178782_a();
                EnumFacing side = target.field_178784_b;
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_185890_d((IBlockAccess)world, pos);
                double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                switch (side) {
                    case DOWN: {
                        d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
                        break;
                    }
                    case UP: {
                        d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
                        break;
                    }
                    case NORTH: {
                        d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
                        break;
                    }
                    case SOUTH: {
                        d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
                        break;
                    }
                    case WEST: {
                        d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
                        break;
                    }
                    case EAST: {
                        d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
                    }
                }
                ParticleDigging.Factory factory = new ParticleDigging.Factory();
                Particle particle = factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)s)});
                if (particle != null) {
                    ((ParticleDigging)particle).func_174846_a(pos);
                    particle = particle.func_70543_e(0.2f).func_70541_f(0.6f);
                    manager.func_78873_a(particle);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return BlockVerticalSlab.getTile((IBlockAccess)world, pos).map(tile -> {
            ParticleDigging.Factory factory = new ParticleDigging.Factory();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        Particle particle2;
                        Particle particle1;
                        double d0 = ((double)j + 0.5) / 4.0 + (double)pos.func_177958_n();
                        double d1 = ((double)k + 0.5) / 4.0 + (double)pos.func_177956_o();
                        double d2 = ((double)l + 0.5) / 4.0 + (double)pos.func_177952_p();
                        if (tile.getPositiveState() != null && (particle1 = factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)tile.getPositiveState())})) != null) {
                            manager.func_78873_a(particle1);
                        }
                        if (tile.getNegativeState() == null || (particle2 = factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)tile.getNegativeState())})) == null) continue;
                        manager.func_78873_a(particle2);
                    }
                }
            }
            return true;
        }).orElse(false);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BlockVerticalSlab.getTile(world, pos).map(tile -> {
                if (tintIndex < 1000) {
                    return tile.getPositiveState() != null ? Minecraft.func_71410_x().func_184125_al().func_186724_a(tile.getPositiveState(), world, pos, tintIndex) : -1;
                }
                return tile.getNegativeState() != null ? Minecraft.func_71410_x().func_184125_al().func_186724_a(tile.getNegativeState(), world, pos, tintIndex) : -1;
            }).orElse(-1);
        };
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180645_a(world, pos, state, random);
        BlockVerticalSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_177230_c().func_180645_a(world, pos, s, random));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        BlockVerticalSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_177230_c().func_180655_c(s, world, pos, rand));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        if (side == null) {
            return false;
        }
        EnumFacing face = Utils.rotateFace(side, (EnumFacing)state.func_177229_b((IProperty)FACING));
        return BlockVerticalSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null && tile.getPositiveState().func_177230_c().canConnectRedstone(tile.getPositiveState(), world, pos, face) || tile.getNegativeState() != null && tile.getNegativeState().func_177230_c().canConnectRedstone(tile.getNegativeState(), world, pos, face)).orElse(false);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        EnumFacing face = Utils.rotateFace(side, (EnumFacing)state.func_177229_b((IProperty)FACING));
        return BlockVerticalSlab.max(world, pos, s -> s.func_185911_a(world, pos, face));
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        EnumFacing face = Utils.rotateFace(side, (EnumFacing)state.func_177229_b((IProperty)FACING));
        return BlockVerticalSlab.max(world, pos, s -> s.func_185893_b(world, pos, face));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return BlockVerticalSlab.both(world, pos, s -> s.func_177230_c().canCreatureSpawn(s, world, pos, type));
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return BlockVerticalSlab.maxWithWorld((IBlockAccess)world, pos, pair -> ((IBlockState)pair.getLeft()).func_185888_a((World)pair.getRight(), pos));
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return BlockVerticalSlab.addFloat((IBlockAccess)world, pos, s -> s.func_177230_c().getEnchantPowerBonus(world, pos));
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        EnumFacing side = Utils.rotateFace(face, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
        return BlockVerticalSlab.max(world, pos, s -> s.func_177230_c().getFireSpreadSpeed(world, pos, side));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        EnumFacing side = Utils.rotateFace(face, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
        return BlockVerticalSlab.max(world, pos, s -> s.func_177230_c().getFlammability(world, pos, side));
    }

    public boolean func_149653_t() {
        return true;
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        return BlockVerticalSlab.either(world, pos, s -> s.func_177230_c().isBeaconBase(world, pos, beacon));
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return BlockVerticalSlab.either(world, pos, s -> s.func_177230_c().isBurning(world, pos));
    }

    public boolean isFertile(World world, BlockPos pos) {
        return BlockVerticalSlab.either((IBlockAccess)world, pos, s -> s.func_177230_c().isFertile(world, pos));
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        EnumFacing face = Utils.rotateFace(side, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
        return BlockVerticalSlab.either((IBlockAccess)world, pos, s -> s.func_177230_c().isFireSource(world, pos, face));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        EnumFacing side = Utils.rotateFace(face, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
        return BlockVerticalSlab.either(world, pos, s -> s.func_177230_c().isFlammable(world, pos, side));
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return BlockVerticalSlab.either(world, pos, s -> s.func_177230_c().isFoliage(world, pos));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        BlockVerticalSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_189546_a(world, pos, block, fromPos));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177230_c() != this) {
            return false;
        }
        return BlockVerticalSlab.getHalfStateWithWorld((IBlockAccess)world, pos, hitX, hitZ).map(pair -> {
            IContainerSupport support = ContainerSupport.getSupport((World)pair.getRight(), pos, (IBlockState)pair.getLeft());
            if (support == null) {
                boolean result;
                ISlabSupport slabSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)world, pos, (IBlockState)pair.getLeft());
                if (slabSupport == null) {
                    slabSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)world, pos, (IBlockState)pair.getLeft());
                }
                try {
                    result = slabSupport == null ? ((IBlockState)pair.getLeft()).func_177230_c().func_180639_a((World)pair.getRight(), pos, (IBlockState)pair.getLeft(), player, hand, facing, hitX, hitY, hitZ) : slabSupport.onActivated((IBlockState)pair.getLeft(), (World)pair.getRight(), pos, player, hand, facing, hitX, hitY, hitZ);
                }
                catch (Exception e) {
                    result = false;
                }
                return result;
            }
            if (!world.field_72995_K) {
                NetworkUtils.openGui(player, support.getMod(), support.getGuiId((World)pair.getRight(), pos, (IBlockState)pair.getLeft()), (World)pair.getRight(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ((WorldWrapper)((Object)((Object)pair.getRight()))).isPositive());
                support.onClicked((World)pair.getRight(), pos, (IBlockState)pair.getLeft(), player, hand, facing);
            }
            return true;
        }).orElse(false);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult result = Utils.rayTrace(player);
        if (result.field_72307_f != null) {
            BlockVerticalSlab.getHalfStateWithWorld((IBlockAccess)world, pos, result.field_72307_f.field_72450_a - (double)pos.func_177958_n(), result.field_72307_f.field_72449_c - (double)pos.func_177952_p()).ifPresent(pair -> ((IBlockState)pair.getLeft()).func_177230_c().func_180649_a((World)pair.getRight(), pos, player));
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        BlockVerticalSlab.runIfAvailable(world, pos, s -> s.func_177230_c().onNeighborChange(world, pos, neighbor));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        BlockVerticalSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_177230_c().func_180650_b(world, pos, s, rand));
    }

    public IBlockState func_176203_a(int meta) {
        return meta < 4 ? this.func_176223_P().func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)) : this.func_176223_P().func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta - 4)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)DOUBLE) != false ? 4 : 0);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!BlockVerticalSlab.getHalfStateWithWorld((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(pair -> {
            ((IBlockState)pair.getLeft()).func_177230_c().func_180658_a((World)pair.getRight(), pos, entity, fallDistance);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        BlockPos pos = entity.func_180425_c().func_177977_b();
        if (world.func_180495_p(pos).func_177230_c() == this && !BlockVerticalSlab.getHalfStateWithWorld((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(pair -> {
            ((IBlockState)pair.getLeft()).func_177230_c().func_176216_a((World)pair.getRight(), entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_176216_a(world, entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!BlockVerticalSlab.getHalfStateWithWorld((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(pair -> {
            ((IBlockState)pair.getLeft()).func_177230_c().func_176199_a((World)pair.getRight(), pos, entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_176199_a(world, pos, entity);
        }
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        boolean positive = BlockVerticalSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null).orElse(true);
        return (Boolean)state.func_177229_b((IProperty)DOUBLE) != false || facing != (positive ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        BlockVerticalSlab.getHalfState((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).ifPresent(s -> s.func_177230_c().func_180634_a(world, pos, s, entity));
    }
}

