/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.blocks;

import cjminecraft.doubleslabs.Registrar;
import cjminecraft.doubleslabs.Utils;
import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IContainerSupport;
import cjminecraft.doubleslabs.api.ISlabSupport;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.blocks.BlockVerticalSlab;
import cjminecraft.doubleslabs.blocks.properties.UnlistedPropertyBlockState;
import cjminecraft.doubleslabs.network.NetworkUtils;
import cjminecraft.doubleslabs.tileentitiy.TileEntityDoubleSlab;
import cjminecraft.doubleslabs.util.WorldWrapper;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockProperties;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockDoubleSlab
extends Block {
    public static final UnlistedPropertyBlockState TOP = new UnlistedPropertyBlockState();
    public static final UnlistedPropertyBlockState BOTTOM = new UnlistedPropertyBlockState();

    public BlockDoubleSlab() {
        super(Material.field_151576_e);
        this.setRegistryName("doubleslabs", "double_slab");
    }

    public static Optional<TileEntityDoubleSlab> getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return world.func_180495_p(pos).func_177230_c() == Registrar.DOUBLE_SLAB && tile instanceof TileEntityDoubleSlab && ((TileEntityDoubleSlab)tile).getPositiveState() != null && ((TileEntityDoubleSlab)tile).getNegativeState() != null ? Optional.of((TileEntityDoubleSlab)tile) : Optional.empty();
    }

    public static Optional<IBlockState> getAvailableState(IBlockAccess world, BlockPos pos) {
        return BlockDoubleSlab.getTile(world, pos).flatMap(tile -> tile.getPositiveState() != null ? Optional.of(tile.getPositiveState()) : Optional.of(tile.getNegativeState()));
    }

    public static Optional<IBlockState> getHalfState(IBlockAccess world, BlockPos pos, double y) {
        return BlockDoubleSlab.getTile(world, pos).flatMap(tile -> tile.getNegativeState() == null && tile.getPositiveState() == null ? Optional.empty() : ((y > 0.5 || tile.getNegativeState() == null) && tile.getPositiveState() != null ? Optional.of(tile.getPositiveState()) : Optional.of(tile.getNegativeState())));
    }

    public static Optional<Pair<IBlockState, WorldWrapper>> getHalfStateWithWorld(IBlockAccess world, BlockPos pos, double y) {
        return BlockDoubleSlab.getTile(world, pos).flatMap(tile -> tile.getNegativeState() == null && tile.getPositiveState() == null ? Optional.empty() : ((y > 0.5 || tile.getNegativeState() == null) && tile.getPositiveState() != null ? Optional.of(Pair.of((Object)tile.getPositiveState(), (Object)((Object)tile.getPositiveWorld()))) : Optional.of(Pair.of((Object)tile.getNegativeState(), (Object)((Object)tile.getNegativeWorld())))));
    }

    public static int min(IBlockAccess world, BlockPos pos, ToIntFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> Math.min(tile.getPositiveState() != null ? converter.applyAsInt(tile.getPositiveState()) : Integer.MAX_VALUE, tile.getNegativeState() != null ? converter.applyAsInt(tile.getNegativeState()) : Integer.MAX_VALUE)).orElse(0);
    }

    public static float minFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> Math.min(tile.getPositiveState() != null ? converter.applyAsDouble(tile.getPositiveState()) : 2.147483647E9, tile.getNegativeState() != null ? converter.applyAsDouble(tile.getNegativeState()) : 2.147483647E9)).orElse(0.0).floatValue();
    }

    public static int max(IBlockAccess world, BlockPos pos, ToIntFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> Math.max(tile.getPositiveState() != null ? converter.applyAsInt(tile.getPositiveState()) : 0, tile.getNegativeState() != null ? converter.applyAsInt(tile.getNegativeState()) : 0)).orElse(0);
    }

    public static int maxWithWorld(IBlockAccess world, BlockPos pos, ToIntFunction<Pair<IBlockState, WorldWrapper>> converter) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> Math.max(tile.getPositiveState() != null ? converter.applyAsInt(Pair.of((Object)tile.getPositiveState(), (Object)((Object)tile.getPositiveWorld()))) : 0, tile.getNegativeState() != null ? converter.applyAsInt(Pair.of((Object)tile.getNegativeState(), (Object)((Object)tile.getNegativeWorld()))) : 0)).orElse(0);
    }

    public static float maxFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> Math.max(tile.getPositiveState() != null ? converter.applyAsDouble(tile.getPositiveState()) : 0.0, tile.getNegativeState() != null ? converter.applyAsDouble(tile.getNegativeState()) : 0.0)).orElse(0.0).floatValue();
    }

    public static float addFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> (tile.getPositiveState() != null ? converter.applyAsDouble(tile.getPositiveState()) : 0.0) + (tile.getNegativeState() != null ? converter.applyAsDouble(tile.getNegativeState()) : 0.0)).orElse(0.0).floatValue();
    }

    public static void runIfAvailable(IBlockAccess world, BlockPos pos, Consumer<IBlockState> consumer) {
        BlockDoubleSlab.getTile(world, pos).map(tile -> {
            if (tile.getPositiveState() != null) {
                consumer.accept(tile.getPositiveState());
            }
            if (tile.getNegativeState() != null) {
                consumer.accept(tile.getNegativeState());
            }
            return null;
        });
    }

    public static boolean both(IBlockAccess world, BlockPos pos, Predicate<IBlockState> predicate) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null && tile.getNegativeState() != null && predicate.test(tile.getPositiveState()) && predicate.test(tile.getNegativeState())).orElse(false);
    }

    public static boolean either(IBlockAccess world, BlockPos pos, Predicate<IBlockState> predicate) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null && predicate.test(tile.getPositiveState()) || tile.getNegativeState() != null && predicate.test(tile.getNegativeState())).orElse(false);
    }

    public static Optional<IExtendedBlockState> getTileState(IBlockState state) {
        if (!(state.func_177230_c() instanceof BlockVerticalSlab)) {
            return Optional.empty();
        }
        if (state instanceof IExtendedBlockState) {
            return Optional.of((IExtendedBlockState)state);
        }
        return Optional.empty();
    }

    public static Optional<IBlockState> getAvailableState(IBlockState state) {
        return BlockDoubleSlab.getTileState(state).flatMap(s -> s.getValue((IUnlistedProperty)TOP) != null ? Optional.of(s.getValue((IUnlistedProperty)TOP)) : Optional.of(s.getValue((IUnlistedProperty)BOTTOM)));
    }

    public static Optional<IBlockState> getHalfState(IBlockState state, double y) {
        return BlockDoubleSlab.getTileState(state).flatMap(s -> (y > 0.5 || s.getValue((IUnlistedProperty)BOTTOM) == null) && s.getValue((IUnlistedProperty)TOP) != null ? Optional.of(s.getValue((IUnlistedProperty)TOP)) : Optional.of(s.getValue((IUnlistedProperty)BOTTOM)));
    }

    public static int min(IBlockState state, ToIntFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTileState(state).map(s -> Math.min(s.getValue((IUnlistedProperty)TOP) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)TOP)) : Integer.MAX_VALUE, s.getValue((IUnlistedProperty)BOTTOM) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)BOTTOM)) : Integer.MAX_VALUE)).orElse(0);
    }

    public static float minFloat(IBlockState state, ToDoubleFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTileState(state).map(s -> Math.min(s.getValue((IUnlistedProperty)TOP) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)TOP)) : 2.147483647E9, s.getValue((IUnlistedProperty)BOTTOM) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)BOTTOM)) : 2.147483647E9)).orElse(0.0).floatValue();
    }

    public static int max(IBlockState state, ToIntFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTileState(state).map(s -> Math.max(s.getValue((IUnlistedProperty)TOP) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)TOP)) : 0, s.getValue((IUnlistedProperty)BOTTOM) != null ? converter.applyAsInt((IBlockState)s.getValue((IUnlistedProperty)BOTTOM)) : 0)).orElse(0);
    }

    public static float maxFloat(IBlockState state, ToDoubleFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTileState(state).map(s -> Math.max(s.getValue((IUnlistedProperty)TOP) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)TOP)) : 0.0, s.getValue((IUnlistedProperty)BOTTOM) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)BOTTOM)) : 0.0)).orElse(0.0).floatValue();
    }

    public static float addFloat(IBlockState state, ToDoubleFunction<IBlockState> converter) {
        return BlockDoubleSlab.getTileState(state).map(s -> (s.getValue((IUnlistedProperty)TOP) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)TOP)) : 0.0) + (s.getValue((IUnlistedProperty)BOTTOM) != null ? converter.applyAsDouble((IBlockState)s.getValue((IUnlistedProperty)BOTTOM)) : 0.0)).orElse(0.0).floatValue();
    }

    public static void runIfAvailable(IBlockState state, Consumer<IBlockState> consumer) {
        BlockDoubleSlab.getTileState(state).map(s -> {
            if (s.getValue((IUnlistedProperty)TOP) != null) {
                consumer.accept((IBlockState)s.getValue((IUnlistedProperty)TOP));
            }
            if (s.getValue((IUnlistedProperty)BOTTOM) != null) {
                consumer.accept((IBlockState)s.getValue((IUnlistedProperty)BOTTOM));
            }
            return null;
        });
    }

    public static boolean both(IBlockState state, Predicate<IBlockState> predicate) {
        return BlockDoubleSlab.getTileState(state).map(s -> s.getValue((IUnlistedProperty)TOP) != null && s.getValue((IUnlistedProperty)BOTTOM) != null && predicate.test((IBlockState)s.getValue((IUnlistedProperty)TOP)) && predicate.test((IBlockState)s.getValue((IUnlistedProperty)BOTTOM))).orElse(false);
    }

    public static boolean either(IBlockState state, Predicate<IBlockState> predicate) {
        return BlockDoubleSlab.getTileState(state).map(s -> s.getValue((IUnlistedProperty)TOP) != null && predicate.test((IBlockState)s.getValue((IUnlistedProperty)TOP)) || s.getValue((IUnlistedProperty)BOTTOM) != null && predicate.test((IBlockState)s.getValue((IUnlistedProperty)BOTTOM))).orElse(false);
    }

    public static boolean canHarvestBlock(@Nonnull Block block, @Nonnull EntityPlayer player, @Nonnull IBlockState state) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        String tool = block.getHarvestTool(state);
        if (!stack.func_190926_b() && tool != null) {
            int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
            if (toolLevel < 0) {
                return player.func_184823_b(state);
            }
            return toolLevel >= block.getHarvestLevel(state);
        }
        return player.func_184823_b(state);
    }

    public static float blockStrength(@Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        float hardness = state.func_185887_b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        return !BlockDoubleSlab.canHarvestBlock(state.func_177230_c(), player, state) ? player.getDigSpeed(state, pos) / hardness / 100.0f : player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    private <T> T runOnDoubleSlab(IBlockState state, Function<Pair<IBlockState, IBlockState>, T> func, Supplier<T> orElse) {
        if (state.func_177230_c() != this) {
            return orElse.get();
        }
        if (state instanceof IExtendedBlockState) {
            IBlockState topState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)TOP);
            IBlockState bottomState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)BOTTOM);
            if (topState == null || bottomState == null) {
                return orElse.get();
            }
            return func.apply((Pair<IBlockState, IBlockState>)Pair.of((Object)topState, (Object)bottomState));
        }
        return orElse.get();
    }

    private <T> T runOnDoubleSlab(IBlockState state, IBlockAccess world, BlockPos pos, Function<Pair<IBlockState, IBlockState>, T> func, Supplier<T> orElse) {
        if (state.func_177230_c() != this) {
            return orElse.get();
        }
        IBlockState extendedState = this.getExtendedState(state, world, pos);
        return this.runOnDoubleSlab(extendedState, func, orElse);
    }

    public boolean func_185481_k(IBlockState state) {
        return BlockDoubleSlab.getTileState(state).map(s -> ((IBlockState)s.getValue((IUnlistedProperty)TOP)).func_185896_q()).orElse(true);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> {
            if (face == EnumFacing.UP) {
                return tile.getTopState().func_193401_d(world, pos, EnumFacing.UP);
            }
            if (face == EnumFacing.DOWN) {
                return tile.getBottomState().func_193401_d(world, pos, EnumFacing.DOWN);
            }
            BlockFaceShape topFace = tile.getTopState().func_193401_d(world, pos, EnumFacing.UP);
            BlockFaceShape bottomFace = tile.getBottomState().func_193401_d(world, pos, EnumFacing.DOWN);
            if (topFace == BlockFaceShape.SOLID && bottomFace == BlockFaceShape.SOLID) {
                return BlockFaceShape.SOLID;
            }
            return BlockFaceShape.UNDEFINED;
        }).orElse(BlockFaceShape.SOLID);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(side));
        return BlockDoubleSlab.getTile(world, pos).map(tile1 -> BlockDoubleSlab.getTile(world, pos.func_177972_a(side)).map(tile2 -> {
            boolean selfTransparent = Utils.isTransparent(tile1.getTopState()) || Utils.isTransparent(tile1.getBottomState());
            boolean otherTransparent = Utils.isTransparent(tile2.getTopState()) || Utils.isTransparent(tile2.getBottomState());
            return selfTransparent ^ otherTransparent;
        }).orElse(super.func_176225_a(state, world, pos, side))).orElse(super.func_176225_a(state, world, pos, side));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_189872_a(IBlockState state, Entity entity) {
        return BlockDoubleSlab.both(state, s -> s.func_189884_a(entity));
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public Material func_149688_o(IBlockState state) {
        return BlockDoubleSlab.getTileState(state).map(s -> ((IBlockState)s.getValue((IUnlistedProperty)TOP)).func_185904_a()).orElse(Material.field_151576_e);
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (entity != null) {
            return BlockDoubleSlab.getHalfState((IBlockAccess)world, pos, entity.field_70163_u - (double)pos.func_177956_o()).map(s -> s.func_177230_c().getSoundType(s, world, pos, entity)).orElse(super.getSoundType(state, world, pos, entity));
        }
        return BlockDoubleSlab.getAvailableState((IBlockAccess)world, pos).map(s -> s.func_177230_c().getSoundType(s, world, pos, null)).orElse(super.getSoundType(state, world, pos, null));
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public boolean func_176214_u(IBlockState state) {
        return BlockDoubleSlab.either(state, IBlockProperties::func_191058_s);
    }

    @Nullable
    public String getHarvestTool(@Nonnull IBlockState state) {
        return null;
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return BlockDoubleSlab.either(world, pos, s -> BlockDoubleSlab.canHarvestBlock(s.func_177230_c(), player, s));
    }

    public float func_180647_a(IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        Vec3d hitVec;
        RayTraceResult rayTraceResult = Utils.rayTrace(player);
        Vec3d vec3d = hitVec = rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK ? rayTraceResult.field_72307_f : null;
        if (hitVec == null) {
            return BlockDoubleSlab.minFloat((IBlockAccess)world, pos, s -> s.func_185903_a(player, world, pos));
        }
        return BlockDoubleSlab.getHalfState((IBlockAccess)world, pos, hitVec.field_72448_b - (double)pos.func_177956_o()).map(s -> Float.valueOf(BlockDoubleSlab.blockStrength(s, player, world, pos))).orElse(Float.valueOf(super.func_180647_a(state, player, world, pos))).floatValue();
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockDoubleSlab.max(world, pos, s -> s.getLightOpacity(world, pos));
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return BlockDoubleSlab.maxFloat((IBlockAccess)world, pos, s -> s.func_185887_b(world, pos));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return BlockDoubleSlab.maxFloat((IBlockAccess)world, pos, s -> s.func_177230_c().getExplosionResistance(world, pos, exploder, explosion));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockDoubleSlab.max(world, pos, s -> s.getLightValue(world, pos));
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityDoubleSlab();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{TOP, BOTTOM}).build();
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDoubleSlab && actualState instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)actualState).withProperty((IUnlistedProperty)TOP, (Object)((TileEntityDoubleSlab)tile).getTopState()).withProperty((IUnlistedProperty)BOTTOM, (Object)((TileEntityDoubleSlab)tile).getBottomState());
        }
        return state;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return BlockDoubleSlab.getHalfState((IBlockAccess)world, pos, target.field_72307_f.field_72448_b - (double)pos.func_177956_o()).map(s -> s.func_177230_c().getPickBlock(s, target, world, pos, player)).orElse(ItemStack.field_190927_a);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        if (player.func_184812_l_() && player.func_70093_af()) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntityDoubleSlab tile = (TileEntityDoubleSlab)world.func_175625_s(pos);
        if (tile != null) {
            tile.getTopState().func_177230_c().getDrops(drops, world, pos, tile.getTopState(), fortune);
            tile.getBottomState().func_177230_c().getDrops(drops, world, pos, tile.getBottomState(), fortune);
        }
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        Vec3d hitVec;
        RayTraceResult rayTraceResult = Utils.rayTrace(player);
        Vec3d vec3d = hitVec = rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK ? rayTraceResult.field_72307_f : null;
        if (hitVec == null || te == null) {
            super.func_180657_a(world, player, pos, state, te, stack);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_175713_t(pos);
        } else {
            IBlockState stateToRemove;
            TileEntityDoubleSlab tile = (TileEntityDoubleSlab)te;
            double y = hitVec.field_72448_b - (double)pos.func_177956_o();
            TileEntity remainingTile = y > 0.5 ? tile.getNegativeTile() : tile.getPositiveTile();
            IBlockState remainingState = y > 0.5 ? tile.getBottomState() : tile.getTopState();
            IBlockState iBlockState = stateToRemove = y > 0.5 ? tile.getTopState() : tile.getBottomState();
            if (!world.field_72995_K) {
                stateToRemove.func_177230_c().func_180663_b((World)(y > 0.5 ? tile.getPositiveWorld() : tile.getNegativeWorld()), pos, y > 0.5 ? tile.getPositiveState() : tile.getNegativeState());
            }
            if (!player.func_184812_l_()) {
                stateToRemove.func_177230_c().func_180657_a((World)(y > 0.5 ? tile.getPositiveWorld() : tile.getNegativeWorld()), player, pos, stateToRemove, y > 0.5 ? tile.getPositiveTile() : tile.getNegativeTile(), stack);
            }
            world.func_180501_a(pos, remainingState, 3);
            world.func_175690_a(pos, remainingTile);
        }
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return BlockDoubleSlab.getTile((IBlockAccess)world, pos).map(tile -> {
            float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
            double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
            int numOfParticles = (int)(150.0 * d0);
            world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)tile.getTopState())});
            return true;
        }).orElse(false);
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            BlockDoubleSlab.getTile((IBlockAccess)world, pos).ifPresent(tile -> world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)tile.getPositiveState())}));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            return BlockDoubleSlab.getHalfState((IBlockAccess)world, target.func_178782_a(), target.field_72307_f.field_72448_b).map(s -> {
                BlockPos pos = target.func_178782_a();
                EnumFacing side = target.field_178784_b;
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
                double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                switch (side) {
                    case DOWN: {
                        d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
                        break;
                    }
                    case UP: {
                        d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
                        break;
                    }
                    case NORTH: {
                        d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
                        break;
                    }
                    case SOUTH: {
                        d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
                        break;
                    }
                    case WEST: {
                        d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
                        break;
                    }
                    case EAST: {
                        d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
                    }
                }
                ParticleDigging.Factory factory = new ParticleDigging.Factory();
                ParticleDigging particle = (ParticleDigging)factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)s)});
                if (particle == null) {
                    return false;
                }
                particle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f);
                manager.func_78873_a((Particle)particle);
                return true;
            }).orElse(false);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return BlockDoubleSlab.getTile((IBlockAccess)world, pos).map(tile -> {
            ParticleDigging.Factory factory = new ParticleDigging.Factory();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        if (tile.getPositiveState() != null) {
                            this.createDestroyParticle(world, pos, manager, tile.getPositiveState(), factory, d0, d1, d2);
                        }
                        if (tile.getNegativeState() == null) continue;
                        this.createDestroyParticle(world, pos, manager, tile.getNegativeState(), factory, d0, d1, d2);
                    }
                }
            }
            return true;
        }).orElse(false);
    }

    @SideOnly(value=Side.CLIENT)
    private void createDestroyParticle(World world, BlockPos pos, ParticleManager manager, IBlockState state, ParticleDigging.Factory factory, double d0, double d1, double d2) {
        ParticleDigging particle = (ParticleDigging)factory.func_178902_a(0, world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
        if (particle == null) {
            return;
        }
        particle.func_174846_a(pos);
        manager.func_78873_a((Particle)particle);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> BlockDoubleSlab.getTile(world, pos).map(tile -> {
            if (tintIndex < 1000) {
                return tile.getTopState() != null ? Minecraft.func_71410_x().func_184125_al().func_186724_a(tile.getTopState(), world, pos, tintIndex) : -1;
            }
            return tile.getBottomState() != null ? Minecraft.func_71410_x().func_184125_al().func_186724_a(tile.getNegativeState(), world, pos, tintIndex - 1000) : -1;
        }).orElse(-1);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180645_a(world, pos, state, random);
        BlockDoubleSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_177230_c().func_180645_a(world, pos, s, random));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        BlockDoubleSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_177230_c().func_180655_c(s, world, pos, rand));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        if (side == null) {
            return false;
        }
        return BlockDoubleSlab.getTile(world, pos).map(tile -> tile.getPositiveState() != null && tile.getPositiveState().func_177230_c().canConnectRedstone(tile.getPositiveState(), world, pos, side) || tile.getNegativeState() != null && tile.getNegativeState().func_177230_c().canConnectRedstone(tile.getNegativeState(), world, pos, side)).orElse(false);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        return BlockDoubleSlab.max(world, pos, s -> s.func_185911_a(world, pos, side));
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        return BlockDoubleSlab.max(world, pos, s -> s.func_185893_b(world, pos, side));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return BlockDoubleSlab.getTile(world, pos).map(tile -> tile.getPositiveState().func_177230_c().canCreatureSpawn(tile.getPositiveState(), world, pos, type)).orElse(true);
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return BlockDoubleSlab.maxWithWorld((IBlockAccess)world, pos, pair -> ((IBlockState)pair.getLeft()).func_185888_a((World)pair.getRight(), pos));
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return BlockDoubleSlab.addFloat((IBlockAccess)world, pos, s -> s.func_177230_c().getEnchantPowerBonus(world, pos));
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return BlockDoubleSlab.max(world, pos, s -> s.func_177230_c().getFireSpreadSpeed(world, pos, face));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return BlockDoubleSlab.max(world, pos, s -> s.func_177230_c().getFlammability(world, pos, face));
    }

    public boolean func_149653_t() {
        return true;
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        return BlockDoubleSlab.either(world, pos, s -> s.func_177230_c().isBeaconBase(world, pos, beacon));
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return BlockDoubleSlab.either(world, pos, s -> s.func_177230_c().isBurning(world, pos));
    }

    public boolean isFertile(World world, BlockPos pos) {
        return BlockDoubleSlab.either((IBlockAccess)world, pos, s -> s.func_177230_c().isFertile(world, pos));
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return BlockDoubleSlab.either((IBlockAccess)world, pos, s -> s.func_177230_c().isFireSource(world, pos, side));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return BlockDoubleSlab.either(world, pos, s -> s.func_177230_c().isFlammable(world, pos, face));
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return BlockDoubleSlab.either(world, pos, s -> s.func_177230_c().isFoliage(world, pos));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        BlockDoubleSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_189546_a(world, pos, block, fromPos));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177230_c() != this) {
            return false;
        }
        return BlockDoubleSlab.getHalfStateWithWorld((IBlockAccess)world, pos, hitY).map(pair -> {
            IContainerSupport support = ContainerSupport.getSupport((World)pair.getRight(), pos, (IBlockState)pair.getLeft());
            if (support == null) {
                boolean result;
                ISlabSupport slabSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)world, pos, (IBlockState)pair.getLeft());
                try {
                    result = slabSupport == null ? ((IBlockState)pair.getLeft()).func_177230_c().func_180639_a((World)pair.getRight(), pos, (IBlockState)pair.getLeft(), player, hand, facing, hitX, hitY, hitZ) : slabSupport.onActivated((IBlockState)pair.getLeft(), (World)pair.getRight(), pos, player, hand, facing, hitX, hitY, hitZ);
                }
                catch (Exception e) {
                    result = false;
                }
                return result;
            }
            if (!world.field_72995_K) {
                NetworkUtils.openGui(player, support.getMod(), support.getGuiId((World)pair.getRight(), pos, (IBlockState)pair.getLeft()), (World)pair.getRight(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ((WorldWrapper)((Object)((Object)pair.getRight()))).isPositive());
                support.onClicked((World)pair.getRight(), pos, (IBlockState)pair.getLeft(), player, hand, facing);
            }
            return true;
        }).orElse(false);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult result = Utils.rayTrace(player);
        if (result.field_72307_f != null) {
            BlockDoubleSlab.getHalfStateWithWorld((IBlockAccess)world, pos, result.field_72307_f.field_72448_b - (double)pos.func_177956_o()).ifPresent(pair -> ((IBlockState)pair.getLeft()).func_177230_c().func_180649_a((World)pair.getRight(), pos, player));
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        BlockDoubleSlab.runIfAvailable(world, pos, s -> s.func_177230_c().onNeighborChange(world, pos, neighbor));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        BlockDoubleSlab.runIfAvailable((IBlockAccess)world, pos, s -> s.func_177230_c().func_180650_b(world, pos, s, rand));
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!BlockDoubleSlab.getTile((IBlockAccess)world, pos).map(tile -> {
            if (tile.getPositiveState() != null) {
                tile.getPositiveState().func_177230_c().func_180658_a((World)tile.getPositiveWorld(), pos, entity, fallDistance);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        BlockPos pos = entity.func_180425_c().func_177977_b();
        if (world.func_180495_p(pos).func_177230_c() == this && !BlockDoubleSlab.getTile((IBlockAccess)world, pos).map(tile -> {
            if (tile.getPositiveState() != null) {
                tile.getPositiveState().func_177230_c().func_176216_a((World)tile.getPositiveWorld(), entity);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.func_176216_a(world, entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        BlockDoubleSlab.getTile((IBlockAccess)world, pos).ifPresent(tile -> {
            if (tile.getPositiveState() != null) {
                tile.getPositiveState().func_177230_c().func_176199_a(world, pos, entity);
            }
        });
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        BlockDoubleSlab.getTile((IBlockAccess)world, pos).ifPresent(tile -> {
            if (tile.getPositiveState() != null) {
                tile.getPositiveState().func_177230_c().func_180634_a(world, pos, tile.getPositiveState(), entity);
            }
        });
    }
}

