/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.DoubleSlabs;
import cjminecraft.doubleslabs.addons.atum2.Atum2SlabSupport;
import cjminecraft.doubleslabs.addons.conquestreforged.ConquestReforgedSlabSupport;
import cjminecraft.doubleslabs.addons.conquestreforged.ConquestReforgedVerticalSlabSupport;
import cjminecraft.doubleslabs.addons.conquestreforged.ConquestReforgedVerticalSlabWoodSupport;
import cjminecraft.doubleslabs.addons.engineersdecor.EngineersDecorSlabSupport;
import cjminecraft.doubleslabs.addons.erebus.ErebusSlabSupport;
import cjminecraft.doubleslabs.addons.libraryex.LibraryExSlabSupport;
import cjminecraft.doubleslabs.addons.minecraft.MinecraftSlabSupport;
import cjminecraft.doubleslabs.addons.stairwaytoaether.StairwayToAetherSlabSupport;
import cjminecraft.doubleslabs.addons.thebetweenlands.TheBetweenlandsSlabSupport;
import cjminecraft.doubleslabs.api.ISlabSupport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;

public class SlabSupport {
    private static final List<ISlabSupport> supportedSlabs = new ArrayList<ISlabSupport>();

    public static void init() {
        SlabSupport.addSlabSupport(new MinecraftSlabSupport());
        if (Loader.isModLoaded((String)"atum")) {
            SlabSupport.addSlabSupport(new Atum2SlabSupport());
        }
        if (Loader.isModLoaded((String)"libraryex")) {
            SlabSupport.addSlabSupport(new LibraryExSlabSupport());
        }
        if (Loader.isModLoaded((String)"erebus")) {
            SlabSupport.addSlabSupport(new ErebusSlabSupport());
        }
        if (Loader.isModLoaded((String)"thebetweenlands")) {
            SlabSupport.addSlabSupport(new TheBetweenlandsSlabSupport());
        }
        if (Loader.isModLoaded((String)"engineersdecor")) {
            SlabSupport.addSlabSupport(new EngineersDecorSlabSupport());
        }
        if (Loader.isModLoaded((String)"stairway")) {
            SlabSupport.addSlabSupport(new StairwayToAetherSlabSupport());
        }
        if (Loader.isModLoaded((String)"conquest")) {
            SlabSupport.addSlabSupport(new ConquestReforgedSlabSupport());
            SlabSupport.addSlabSupport(new ConquestReforgedVerticalSlabSupport());
            SlabSupport.addSlabSupport(new ConquestReforgedVerticalSlabWoodSupport());
        }
    }

    public static void addSlabSupport(@Nonnull ISlabSupport support) {
        if (supportedSlabs.contains(support)) {
            DoubleSlabs.LOGGER.warn("A slab support of type %s has already been registered - SKIPPING", (Object)support.getClass().getSimpleName());
        } else {
            supportedSlabs.add(support);
            DoubleSlabs.LOGGER.info("Successfully added slab support for type %s", (Object)support.getClass().getSimpleName());
        }
    }

    public static void addSupportFromIMC(String className) {
        try {
            Class<?> support = Class.forName(className);
            for (Class<?> interfaces : support.getInterfaces()) {
                if (!interfaces.getName().equals(ISlabSupport.class.getName())) continue;
                SlabSupport.addSlabSupport((ISlabSupport)support.newInstance());
            }
        }
        catch (Exception e) {
            DoubleSlabs.LOGGER.error("An error occurred when registering slab support for class %s", (Object)className);
        }
    }

    @Nullable
    public static ISlabSupport getHorizontalSlabSupport(IBlockAccess world, BlockPos pos, IBlockState state) {
        return SlabSupport.getSupport(world, pos, state);
    }

    @Nullable
    public static ISlabSupport getHorizontalSlabSupport(ItemStack stack, EntityPlayer player, EnumHand hand) {
        return SlabSupport.getSupport(stack, player, hand);
    }

    @Nullable
    public static ISlabSupport getVerticalSlabSupport(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() instanceof ISlabSupport && ((ISlabSupport)state.func_177230_c()).isVerticalSlab(world, pos, state)) {
            return (ISlabSupport)state.func_177230_c();
        }
        for (ISlabSupport support : supportedSlabs) {
            if (!support.isVerticalSlab(world, pos, state)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static ISlabSupport getVerticalSlabSupport(ItemStack stack, EntityPlayer player, EnumHand hand) {
        ISlabSupport support2;
        Block block;
        if (stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof ISlabSupport && (support2 = (ISlabSupport)block).isVerticalSlab(stack, player, hand)) {
            return support2;
        }
        for (ISlabSupport support2 : supportedSlabs) {
            if (!support2.isVerticalSlab(stack, player, hand)) continue;
            return support2;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static ISlabSupport getSupport(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() instanceof ISlabSupport && ((ISlabSupport)state.func_177230_c()).isHorizontalSlab(world, pos, state)) {
            return (ISlabSupport)state.func_177230_c();
        }
        for (ISlabSupport support : supportedSlabs) {
            if (!support.isHorizontalSlab(world, pos, state)) continue;
            return support;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static ISlabSupport getSupport(ItemStack stack, EntityPlayer player, EnumHand hand) {
        ISlabSupport support2;
        Block block;
        if (stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof ISlabSupport && (support2 = (ISlabSupport)block).isHorizontalSlab(stack, player, hand)) {
            return support2;
        }
        for (ISlabSupport support2 : supportedSlabs) {
            if (!support2.isHorizontalSlab(stack, player, hand)) continue;
            return support2;
        }
        return null;
    }
}

