/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.DoubleSlabs;
import cjminecraft.doubleslabs.addons.slabmachines.SlabMachinesContainerSupport;
import cjminecraft.doubleslabs.api.IContainerSupport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ContainerSupport {
    private static final List<IContainerSupport> supportedContainers = new ArrayList<IContainerSupport>();

    public static void init() {
        if (Loader.isModLoaded((String)"slabmachines")) {
            ContainerSupport.addContainerSupport(new SlabMachinesContainerSupport());
        }
    }

    public static void addContainerSupport(@Nonnull IContainerSupport support) {
        if (supportedContainers.contains(support)) {
            DoubleSlabs.LOGGER.warn("A container support of type %s has already been registered - SKIPPING", (Object)support.getClass().getSimpleName());
        } else {
            supportedContainers.add(support);
            DoubleSlabs.LOGGER.info("Successfully added container support for type %s", (Object)support.getClass().getSimpleName());
        }
    }

    @Nullable
    public static IContainerSupport getSupport(World world, BlockPos pos, IBlockState state) {
        for (IContainerSupport support : supportedContainers) {
            if (!support.isValid(world, pos, state)) continue;
            return support;
        }
        return null;
    }
}

