/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.addons.thebetweenlands;

import cjminecraft.doubleslabs.api.ISlabSupport;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TheBetweenlandsSlabSupport<T extends Enum<T>>
implements ISlabSupport {
    private final Class<?> slab;
    private final PropertyEnum<T> slabTypeProperty;
    private final T[] slabTypes;

    public TheBetweenlandsSlabSupport() {
        Enum[] slabTypes;
        PropertyEnum slabTypeProperty;
        Class<?> slab;
        try {
            slab = Class.forName("thebetweenlands.common.block.structure.BlockSlabBetweenlands");
            slabTypeProperty = (PropertyEnum)slab.getField("HALF").get(null);
            Class<?> slabType = Class.forName("thebetweenlands.common.block.structure.BlockSlabBetweenlands$EnumBlockHalfBL");
            slabTypes = (Enum[])slabType.getEnumConstants();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            slabTypeProperty = null;
            slabTypes = null;
        }
        this.slab = slab;
        this.slabTypeProperty = slabTypeProperty;
        this.slabTypes = slabTypes;
    }

    @Override
    public boolean isValid(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && state.func_177229_b(this.slabTypeProperty) != this.slabTypes[2];
    }

    @Override
    public boolean isValid(ItemStack stack, EntityPlayer player, EnumHand hand) {
        return this.slab != null && stack.func_77973_b() instanceof ItemBlock && this.slab.isAssignableFrom(((ItemBlock)stack.func_77973_b()).func_179223_d().getClass());
    }

    @Override
    public BlockSlab.EnumBlockHalf getHalf(World world, BlockPos pos, IBlockState state) {
        return this.slab != null && state.func_177229_b(this.slabTypeProperty) == this.slabTypes[1] ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP;
    }

    @Override
    public IBlockState getStateForHalf(World world, BlockPos pos, IBlockState state, BlockSlab.EnumBlockHalf half) {
        return this.slab != null ? state.func_177226_a(this.slabTypeProperty, half == BlockSlab.EnumBlockHalf.BOTTOM ? this.slabTypes[1] : this.slabTypes[0]) : state;
    }

    @Override
    public boolean areSame(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        return state.func_177230_c() == ((ItemBlock)stack.func_77973_b()).func_179223_d();
    }
}

