/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs;

import cjminecraft.doubleslabs.DoubleSlabs;
import cjminecraft.doubleslabs.blocks.BlockDoubleSlab;
import cjminecraft.doubleslabs.blocks.BlockVerticalSlab;
import cjminecraft.doubleslabs.client.model.DoubleSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.tileentitiy.TileEntityDoubleSlab;
import cjminecraft.doubleslabs.tileentitiy.TileEntityVerticalSlab;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class Registrar {
    public static BlockDoubleSlab DOUBLE_SLAB = new BlockDoubleSlab();
    public static BlockVerticalSlab VERTICAL_SLAB = new BlockVerticalSlab();

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{DOUBLE_SLAB, VERTICAL_SLAB});
        GameRegistry.registerTileEntity(TileEntityDoubleSlab.class, (ResourceLocation)new ResourceLocation("doubleslabs", "double_slab"));
        GameRegistry.registerTileEntity(TileEntityVerticalSlab.class, (ResourceLocation)new ResourceLocation("doubleslabs", "vertical_slab"));
    }

    private static String getPropertyString(Map<IProperty<?>, Comparable<?>> values) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(Registrar.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)DoubleSlabBakedModel.variantTag, (Object)new DoubleSlabBakedModel());
        VerticalSlabBakedModel verticalSlabBakedModel = new VerticalSlabBakedModel();
        for (IBlockState state : VERTICAL_SLAB.func_176194_O().func_177619_a()) {
            ModelResourceLocation variantResourceLocation = new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)VERTICAL_SLAB), Registrar.getPropertyString(state.func_177228_b()));
            IBakedModel existingModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)variantResourceLocation);
            if (existingModel == null) {
                DoubleSlabs.LOGGER.warn("Did not find the expected vanilla baked model(s) for the vertical slab in registry");
                continue;
            }
            if (existingModel instanceof VerticalSlabBakedModel) {
                DoubleSlabs.LOGGER.warn("Tried to replace VerticalSlabBakedModel twice");
                continue;
            }
            verticalSlabBakedModel.addModel(existingModel, state);
            event.getModelRegistry().func_82595_a((Object)variantResourceLocation, (Object)verticalSlabBakedModel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerBlockColours(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(DOUBLE_SLAB.getBlockColor(), new Block[]{DOUBLE_SLAB});
        event.getBlockColors().func_186722_a(VERTICAL_SLAB.getBlockColor(), new Block[]{VERTICAL_SLAB});
    }
}

