/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs;

import cjminecraft.doubleslabs.DoubleSlabsConfig;
import cjminecraft.doubleslabs.Registrar;
import cjminecraft.doubleslabs.Utils;
import cjminecraft.doubleslabs.api.ISlabSupport;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.blocks.BlockDoubleSlab;
import cjminecraft.doubleslabs.blocks.BlockVerticalSlab;
import cjminecraft.doubleslabs.patches.DynamicSurroundings;
import cjminecraft.doubleslabs.tileentitiy.TileEntityVerticalSlab;
import java.util.Arrays;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class Events {
    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("doubleslabs")) {
            ConfigManager.sync((String)"doubleslabs", (Config.Type)Config.Type.INSTANCE);
            DoubleSlabsConfig.SLAB_BLACKLIST = Arrays.asList(DoubleSlabsConfig.SLAB_BLACKLIST_ARRAY);
            DoubleSlabsConfig.LAZY_VERTICAL_SLABS = Arrays.asList(DoubleSlabsConfig.LAZY_VERTICAL_SLABS_ARRAY);
        }
    }

    public static boolean canPlace(World world, BlockPos pos, EnumFacing face, EntityPlayer player, EnumHand hand, ItemStack stack, PlayerInteractEvent.RightClickBlock event, boolean activateBlock) {
        boolean flag1;
        if (!player.func_175151_a(pos, face, stack)) {
            return false;
        }
        if (!activateBlock) {
            return true;
        }
        boolean flag = !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
        boolean bl = flag1 = !player.func_70093_af() || !flag || player.func_184614_ca().doesSneakBypassUse((IBlockAccess)world, pos, player) && player.func_184592_cb().doesSneakBypassUse((IBlockAccess)world, pos, player);
        if (flag1) {
            boolean result = world.func_180495_p(pos).func_177230_c().func_180639_a(world, pos, world.func_180495_p(pos), player, hand, face, (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c);
            if (result) {
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
            return !result;
        }
        return true;
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().func_190926_b()) {
            ISlabSupport itemSupport = SlabSupport.getHorizontalSlabSupport(event.getItemStack(), event.getEntityPlayer(), event.getHand());
            if (itemSupport == null) {
                itemSupport = SlabSupport.getVerticalSlabSupport(event.getItemStack(), event.getEntityPlayer(), event.getHand());
                if (itemSupport == null) {
                    return;
                }
                if (Events.canPlace(event.getWorld(), event.getPos(), event.getFace(), event.getEntityPlayer(), event.getHand(), event.getItemStack(), event, true)) {
                    TileEntityVerticalSlab tile;
                    BlockPos pos = event.getPos();
                    if (MathHelper.func_76128_c((double)event.getEntityPlayer().field_70165_t) == pos.func_177958_n() && MathHelper.func_76128_c((double)event.getEntityPlayer().field_70163_u) == pos.func_177956_o() && MathHelper.func_76128_c((double)event.getEntityPlayer().field_70161_v) == pos.func_177952_p()) {
                        return;
                    }
                    IBlockState state = event.getWorld().func_180495_p(pos);
                    EnumFacing face = event.getFace();
                    if (state.func_177230_c() != Registrar.VERTICAL_SLAB && event.getWorld().func_180495_p(pos.func_177972_a(face)).func_177230_c() == Registrar.VERTICAL_SLAB) {
                        state = event.getWorld().func_180495_p(pos.func_177972_a(face));
                        pos = pos.func_177972_a(face);
                        tile = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos);
                        if (tile != null) {
                            face = tile.getPositiveState() != null ? ((EnumFacing)state.func_177229_b((IProperty)BlockVerticalSlab.FACING)).func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)BlockVerticalSlab.FACING);
                        }
                        if (!Events.canPlace(tile.getPositiveState() != null ? tile.getPositiveWorld() : tile.getNegativeWorld(), pos, face, event.getEntityPlayer(), event.getHand(), event.getItemStack(), event, false)) {
                            return;
                        }
                    }
                    if (state.func_177230_c() == Registrar.VERTICAL_SLAB) {
                        if (!(((Boolean)state.func_177229_b((IProperty)BlockVerticalSlab.DOUBLE)).booleanValue() || face != ((EnumFacing)state.func_177229_b((IProperty)BlockVerticalSlab.FACING)).func_176734_d() || (tile = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos)) == null || event.getEntityPlayer().func_70093_af() || face == state.func_177229_b((IProperty)BlockVerticalSlab.FACING) && tile.getPositiveState() != null)) {
                            IBlockState newState = state.func_177226_a((IProperty)BlockVerticalSlab.DOUBLE, (Comparable)Boolean.valueOf(true));
                            IBlockState slabState = itemSupport.getStateForDirection(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), tile.getPositiveState() != null ? face.func_176734_d() : face);
                            if (DoubleSlabsConfig.isBlacklistedVerticalSlab(slabState)) {
                                return;
                            }
                            if (event.getWorld().func_180501_a(pos, newState, 3)) {
                                if (tile.getPositiveState() != null) {
                                    tile.setNegativeState(slabState);
                                } else {
                                    tile.setPositiveState(slabState);
                                }
                                Events.finishBlockPlacement(event, pos, slabState);
                                return;
                            }
                        }
                    } else {
                        ISlabSupport blockSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)event.getWorld(), pos, state);
                        if (blockSupport == null) {
                            pos = pos.func_177972_a(face);
                            if (MathHelper.func_76128_c((double)event.getEntityPlayer().field_70165_t) == pos.func_177958_n() && MathHelper.func_76128_c((double)event.getEntityPlayer().field_70163_u) == pos.func_177956_o() && MathHelper.func_76128_c((double)event.getEntityPlayer().field_70161_v) == pos.func_177952_p()) {
                                return;
                            }
                            state = event.getWorld().func_180495_p(pos);
                            if (!Events.canPlace(event.getWorld(), pos, face, event.getEntityPlayer(), event.getHand(), event.getItemStack(), event, false)) {
                                return;
                            }
                            blockSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)event.getWorld(), pos, state);
                            if (blockSupport == null) {
                                return;
                            }
                            face = blockSupport.getDirection(event.getWorld(), pos, state).func_176734_d();
                        }
                        if (DoubleSlabsConfig.isBlacklistedVerticalSlab(state)) {
                            return;
                        }
                        EnumFacing direction = blockSupport.getDirection(event.getWorld(), pos, state);
                        if (face == direction.func_176734_d()) {
                            IBlockState slabState = itemSupport.getStateForDirection(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), direction.func_176734_d());
                            if (DoubleSlabsConfig.isBlacklistedVerticalSlab(slabState)) {
                                return;
                            }
                            IBlockState newState = Registrar.VERTICAL_SLAB.func_176223_P().func_177226_a((IProperty)BlockVerticalSlab.FACING, (Comparable)direction).func_177226_a((IProperty)BlockVerticalSlab.DOUBLE, (Comparable)Boolean.valueOf(true));
                            if (event.getWorld().func_180501_a(pos, newState, 11)) {
                                TileEntityVerticalSlab tile2 = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos);
                                if (tile2 == null) {
                                    return;
                                }
                                tile2.setNegativeState(state);
                                tile2.setPositiveState(slabState);
                                Events.finishBlockPlacement(event, pos, slabState);
                            }
                        }
                    }
                }
                return;
            }
            if (Events.canPlace(event.getWorld(), event.getPos(), event.getFace(), event.getEntityPlayer(), event.getHand(), event.getItemStack(), event, true)) {
                TileEntityVerticalSlab tile;
                IBlockState state;
                BlockPos pos = event.getPos();
                EnumFacing face = event.getFace();
                IBlockState originalState = state = event.getWorld().func_180495_p(pos);
                if (DoubleSlabsConfig.SLAB_BLACKLIST.contains(DoubleSlabsConfig.slabToString(state))) {
                    return;
                }
                boolean verticalSlab = state.func_177230_c() == Registrar.VERTICAL_SLAB && (Boolean)state.func_177229_b((IProperty)BlockVerticalSlab.DOUBLE) == false && (((TileEntityVerticalSlab)event.getWorld().func_175625_s(pos)).getPositiveState() != null ? face == ((EnumFacing)state.func_177229_b((IProperty)BlockVerticalSlab.FACING)).func_176734_d() : face == state.func_177229_b((IProperty)BlockVerticalSlab.FACING));
                ISlabSupport blockSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)event.getWorld(), pos, state);
                if (blockSupport == null && !verticalSlab) {
                    blockSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)event.getWorld(), pos, state);
                    if (blockSupport != null) {
                        if (DoubleSlabsConfig.isBlacklistedVerticalSlab(state)) {
                            return;
                        }
                        EnumFacing direction = blockSupport.getDirection(event.getWorld(), pos, state);
                        if (face == direction) {
                            IBlockState slabState = itemSupport.getStateForHalf(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), BlockSlab.EnumBlockHalf.BOTTOM);
                            IBlockState newState = Registrar.VERTICAL_SLAB.func_176223_P().func_177226_a((IProperty)BlockVerticalSlab.DOUBLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockVerticalSlab.FACING, (Comparable)direction);
                            DynamicSurroundings.patchBlockState(newState);
                            if (event.getWorld().func_180501_a(pos, newState, 3)) {
                                TileEntityVerticalSlab tile3 = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos);
                                if (tile3 == null) {
                                    return;
                                }
                                tile3.setNegativeState(state);
                                tile3.setPositiveState(slabState);
                                Events.finishBlockPlacement(event, pos, slabState);
                            }
                            return;
                        }
                    }
                    originalState = state;
                    BlockPos originalPos = pos;
                    pos = pos.func_177972_a(event.getFace());
                    if (MathHelper.func_76128_c((double)event.getEntityPlayer().field_70165_t) == pos.func_177958_n() && MathHelper.func_76128_c((double)event.getEntityPlayer().field_70163_u) == pos.func_177956_o() && MathHelper.func_76128_c((double)event.getEntityPlayer().field_70161_v) == pos.func_177952_p()) {
                        return;
                    }
                    state = event.getWorld().func_180495_p(pos);
                    if (!Events.canPlace(event.getWorld(), pos, face, event.getEntityPlayer(), event.getHand(), event.getItemStack(), event, false)) {
                        return;
                    }
                    verticalSlab = state.func_177230_c() == Registrar.VERTICAL_SLAB && (Boolean)state.func_177229_b((IProperty)BlockVerticalSlab.DOUBLE) == false;
                    blockSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)event.getWorld(), pos, state);
                    if (blockSupport == null && !verticalSlab) {
                        blockSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)event.getWorld(), pos, state);
                        if (blockSupport != null) {
                            if (DoubleSlabsConfig.isBlacklistedVerticalSlab(state)) {
                                return;
                            }
                            EnumFacing direction = blockSupport.getDirection(event.getWorld(), pos, state);
                            IBlockState slabState = itemSupport.getStateForHalf(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), BlockSlab.EnumBlockHalf.BOTTOM);
                            IBlockState newState = Registrar.VERTICAL_SLAB.func_176223_P().func_177226_a((IProperty)BlockVerticalSlab.DOUBLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockVerticalSlab.FACING, (Comparable)direction);
                            DynamicSurroundings.patchBlockState(newState);
                            if (event.getWorld().func_180501_a(pos, newState, 3)) {
                                TileEntityVerticalSlab tile4 = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos);
                                if (tile4 == null) {
                                    return;
                                }
                                tile4.setNegativeState(state);
                                tile4.setPositiveState(slabState);
                                Events.finishBlockPlacement(event, pos, slabState);
                            }
                            return;
                        }
                        if ((event.getEntityPlayer().func_70093_af() && !DoubleSlabsConfig.ALTERNATE_VERTICAL_SLAB_PLACEMENT || DoubleSlabsConfig.ALTERNATE_VERTICAL_SLAB_PLACEMENT && (event.getEntityPlayer().func_70093_af() && face.func_176740_k() == EnumFacing.Axis.Y || !event.getEntityPlayer().func_70093_af() && face.func_176740_k() != EnumFacing.Axis.Y)) && !DoubleSlabsConfig.DISABLE_VERTICAL_SLAB_PLACEMENT) {
                            if (originalState.func_177230_c().hasTileEntity(originalState) && originalState.func_177230_c().func_180639_a(event.getWorld(), event.getPos(), originalState, event.getEntityPlayer(), event.getHand(), face, (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c)) {
                                return;
                            }
                            RayTraceResult result = Utils.rayTrace(event.getEntityPlayer());
                            if (originalState.func_177230_c().func_176200_f((IBlockAccess)event.getWorld(), originalPos)) {
                                state = originalState;
                                pos = originalPos;
                            } else if (!state.func_177230_c().func_176200_f((IBlockAccess)event.getWorld(), pos)) {
                                return;
                            }
                            if (face.func_176740_k() == EnumFacing.Axis.Y) {
                                EnumFacing direction = event.getEntityPlayer().func_174811_aO();
                                double distance = direction.func_176740_k() == EnumFacing.Axis.X ? result.field_72307_f.field_72450_a - (double)pos.func_177958_n() : result.field_72307_f.field_72449_c - (double)pos.func_177952_p();
                                if (direction.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && distance < 0.5) {
                                    direction = direction.func_176734_d();
                                } else if (direction.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE && distance > 0.5) {
                                    direction = direction.func_176734_d();
                                }
                                IBlockState slabState = itemSupport.getStateForHalf(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), BlockSlab.EnumBlockHalf.BOTTOM);
                                if (DoubleSlabsConfig.isBlacklistedVerticalSlab(slabState)) {
                                    return;
                                }
                                IBlockState newState = Registrar.VERTICAL_SLAB.func_176223_P().func_177226_a((IProperty)BlockVerticalSlab.FACING, (Comparable)direction);
                                DynamicSurroundings.patchBlockState(newState);
                                if (event.getWorld().func_180501_a(pos, newState, 3)) {
                                    TileEntityVerticalSlab tile5 = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos);
                                    if (tile5 == null) {
                                        return;
                                    }
                                    tile5.setPositiveState(slabState);
                                    Events.finishBlockPlacement(event, pos, slabState);
                                }
                            } else {
                                IBlockState slabState = itemSupport.getStateForHalf(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), BlockSlab.EnumBlockHalf.BOTTOM);
                                if (DoubleSlabsConfig.isBlacklistedVerticalSlab(slabState)) {
                                    return;
                                }
                                IBlockState newState = Registrar.VERTICAL_SLAB.func_176223_P().func_177226_a((IProperty)BlockVerticalSlab.FACING, (Comparable)face.func_176734_d());
                                DynamicSurroundings.patchBlockState(newState);
                                if (event.getWorld().func_180501_a(pos, newState, 3)) {
                                    TileEntityVerticalSlab tile6 = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos);
                                    if (tile6 == null) {
                                        return;
                                    }
                                    tile6.setPositiveState(slabState);
                                    Events.finishBlockPlacement(event, pos, slabState);
                                }
                            }
                        }
                        return;
                    }
                    if (blockSupport != null) {
                        face = blockSupport.getHalf(event.getWorld(), pos, state) == BlockSlab.EnumBlockHalf.BOTTOM ? EnumFacing.UP : EnumFacing.DOWN;
                    }
                } else if (state.func_177230_c().hasTileEntity(state) && state.func_177230_c().func_180639_a(event.getWorld(), pos, state, event.getEntityPlayer(), event.getHand(), face, (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c)) {
                    return;
                }
                if (!(!verticalSlab || state.func_177230_c() != Registrar.VERTICAL_SLAB || ((Boolean)state.func_177229_b((IProperty)BlockVerticalSlab.DOUBLE)).booleanValue() || (tile = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos)) == null || event.getEntityPlayer().func_70093_af() || face == state.func_177229_b((IProperty)BlockVerticalSlab.FACING) && tile.getPositiveState() != null)) {
                    IBlockState newState = state.func_177226_a((IProperty)BlockVerticalSlab.DOUBLE, (Comparable)Boolean.valueOf(true));
                    DynamicSurroundings.patchBlockState(newState);
                    IBlockState slabState = itemSupport.getStateForHalf(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), tile.getPositiveState() != null ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM);
                    if (DoubleSlabsConfig.isBlacklistedVerticalSlab(slabState)) {
                        return;
                    }
                    if (event.getWorld().func_180501_a(pos, newState, 3)) {
                        if (tile.getPositiveState() != null) {
                            tile.setNegativeState(slabState);
                        } else {
                            tile.setPositiveState(slabState);
                        }
                        Events.finishBlockPlacement(event, pos, slabState);
                        return;
                    }
                }
                if (!DoubleSlabsConfig.REPLACE_SAME_SLAB && blockSupport == itemSupport && blockSupport.areSame(event.getWorld(), pos, state, event.getItemStack())) {
                    return;
                }
                if (blockSupport != null) {
                    BlockSlab.EnumBlockHalf half = blockSupport.getHalf(event.getWorld(), pos, state);
                    if (face == EnumFacing.UP && half == BlockSlab.EnumBlockHalf.BOTTOM || face == EnumFacing.DOWN && half == BlockSlab.EnumBlockHalf.TOP) {
                        IBlockState slabState = itemSupport.getStateForHalf(event.getWorld(), pos, itemSupport.getStateFromStack(event.getItemStack(), event.getWorld(), pos, face, event.getHitVec(), event.getEntityPlayer(), event.getHand()), half == BlockSlab.EnumBlockHalf.BOTTOM ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM);
                        if (DoubleSlabsConfig.isBlacklistedHorizontalSlab(state)) {
                            return;
                        }
                        IExtendedBlockState newState = ((IExtendedBlockState)Registrar.DOUBLE_SLAB.func_176223_P()).withProperty((IUnlistedProperty)BlockDoubleSlab.TOP, (Object)(half == BlockSlab.EnumBlockHalf.TOP ? state : slabState)).withProperty((IUnlistedProperty)BlockDoubleSlab.BOTTOM, (Object)(half == BlockSlab.EnumBlockHalf.BOTTOM ? state : slabState));
                        AxisAlignedBB axisalignedbb = newState.func_185890_d((IBlockAccess)event.getWorld(), pos);
                        DynamicSurroundings.patchBlockState((IBlockState)newState);
                        if (axisalignedbb != Block.field_185506_k && event.getWorld().func_72855_b(axisalignedbb.func_186670_a(pos)) && event.getWorld().func_180501_a(pos, (IBlockState)newState, 11)) {
                            TileEntityVerticalSlab tile7 = (TileEntityVerticalSlab)event.getWorld().func_175625_s(pos);
                            if (tile7 == null) {
                                return;
                            }
                            tile7.setPositiveState(half == BlockSlab.EnumBlockHalf.TOP ? state : slabState);
                            tile7.setNegativeState(half == BlockSlab.EnumBlockHalf.TOP ? slabState : state);
                            SoundType soundtype = state.func_177230_c().getSoundType(slabState, event.getWorld(), pos, (Entity)event.getEntityPlayer());
                            event.getWorld().func_184133_a(event.getEntityPlayer(), pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                            if (!event.getEntityPlayer().func_184812_l_()) {
                                event.getItemStack().func_190918_g(1);
                            }
                            event.setCancellationResult(EnumActionResult.SUCCESS);
                            event.setCanceled(true);
                            if (event.getEntityPlayer() instanceof EntityPlayerMP) {
                                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)event.getEntityPlayer(), pos, event.getItemStack());
                            }
                        } else {
                            event.setUseItem(Event.Result.DENY);
                        }
                    }
                }
            }
        }
    }

    private static void finishBlockPlacement(PlayerInteractEvent.RightClickBlock event, BlockPos pos, IBlockState slabState) {
        SoundType soundtype = slabState.func_177230_c().getSoundType(slabState, event.getWorld(), pos, (Entity)event.getEntityPlayer());
        event.getWorld().func_184133_a(event.getEntityPlayer(), pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (!event.getEntityPlayer().func_184812_l_()) {
            event.getItemStack().func_190918_g(1);
        }
        event.setCancellationResult(EnumActionResult.SUCCESS);
        event.setCanceled(true);
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)event.getEntityPlayer(), pos, event.getItemStack());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.getTarget().func_178782_a());
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_() || Minecraft.func_71410_x().field_71439_g.func_184812_l_() && Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            double expansionAmount;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            double x = (double)event.getTarget().func_178782_a().func_177958_n() - (event.getPlayer().field_70142_S + (event.getPlayer().field_70165_t - event.getPlayer().field_70142_S) * (double)event.getPartialTicks());
            double y = (double)event.getTarget().func_178782_a().func_177956_o() - (event.getPlayer().field_70137_T + (event.getPlayer().field_70163_u - event.getPlayer().field_70137_T) * (double)event.getPartialTicks());
            double z = (double)event.getTarget().func_178782_a().func_177952_p() - (event.getPlayer().field_70136_U + (event.getPlayer().field_70161_v - event.getPlayer().field_70136_U) * (double)event.getPartialTicks());
            if (state.func_177230_c() == Registrar.DOUBLE_SLAB) {
                if (Minecraft.func_71410_x().field_71441_e.func_175723_af().func_177746_a(event.getTarget().func_178782_a())) {
                    expansionAmount = 0.002f;
                    if (event.getTarget().field_72307_f.field_72448_b - (double)event.getTarget().func_178782_a().func_177956_o() > 0.5) {
                        RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y + 0.5 - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    } else {
                        RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 0.5 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    }
                }
                event.setCanceled(true);
            }
            if (state.func_177230_c() == Registrar.VERTICAL_SLAB && ((Boolean)state.func_177229_b((IProperty)BlockVerticalSlab.DOUBLE)).booleanValue()) {
                expansionAmount = 0.002f;
                switch (((EnumFacing)state.func_177229_b((IProperty)BlockVerticalSlab.FACING)).func_176740_k()) {
                    case X: {
                        if (event.getTarget().field_72307_f.field_72450_a - (double)event.getTarget().func_178782_a().func_177958_n() > 0.5) {
                            RenderGlobal.func_189694_a((double)(x + 0.5 - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 0.5 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                    case Z: {
                        if (event.getTarget().field_72307_f.field_72449_c - (double)event.getTarget().func_178782_a().func_177952_p() > 0.5) {
                            RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z + 0.5 - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 0.5 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }
}

