/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.config.Config;

@Config(modid="doubleslabs")
public class DoubleSlabsConfig {
    @Config.Name(value="Slab Blacklist")
    @Config.Comment(value={"The list of slab types and variants to ignore when creating double slabs", "Example: minecraft:purpur_slab", "Example: minecraft:stone_slab#variant=cobblestone"})
    @Config.LangKey(value="config.doubleslabs.slab_blacklist")
    public static String[] SLAB_BLACKLIST_ARRAY = new String[0];
    @Config.Ignore
    public static List<String> SLAB_BLACKLIST = new ArrayList<String>();
    @Config.Name(value="Replace Same Slab")
    @Config.Comment(value={"Whether to use the custom double slab when combining slabs of the same type"})
    @Config.LangKey(value="config.doubleslabs.replace_same_slab")
    public static boolean REPLACE_SAME_SLAB = true;
    @Config.Name(value="Disable Vertical Slab Placement")
    @Config.Comment(value={"Whether to disable the placement of vertical slabs from regular horizontal slabs when holding shift"})
    @Config.LangKey(value="config.doubleslabs.disable_vertical_slab_placement")
    public static boolean DISABLE_VERTICAL_SLAB_PLACEMENT = false;
    @Config.Name(value="Alternate Vertical Slab Placement")
    @Config.Comment(value={"Whether to use an alternate system when placing vertical slabs"})
    @Config.LangKey(value="config.doubleslabs.alternate_vertical_slab_placement")
    public static boolean ALTERNATE_VERTICAL_SLAB_PLACEMENT = true;
    @Config.Name(value="Lazy Vertical Slab Models")
    @Config.Comment(value={"The list of slabs which should use the lazy model rendering technique", "Lazy model rendering does not physically rotate the original slab model, but applies the same texture to a default vertical slab model", "This often yields better looking results with wooden planks and does not necessarily improve the look of all vertical slabs"})
    @Config.LangKey(value="config.doubleslabs.lazy_vertical_slabs")
    public static String[] LAZY_VERTICAL_SLABS_ARRAY = new String[]{"minecraft:wooden_slab#variant=oak", "minecraft:wooden_slab#variant=spruce", "minecraft:wooden_slab#variant=birch", "minecraft:wooden_slab#variant=jungle", "minecraft:wooden_slab#variant=acacia", "minecraft:wooden_slab#variant=dark_oak"};
    @Config.Ignore
    public static List<String> LAZY_VERTICAL_SLABS = new ArrayList<String>();
    @Config.Name(value="Slab Cull Blacklist")
    @Config.Comment(value={"The list of slabs which should not be culled when combined"})
    @Config.LangKey(value="config.doubleslabs.slab_cull_blacklist")
    public static String[] SLAB_CULL_BLACKLIST = new String[0];
    @Config.Name(value="Vertical Slab Blacklist")
    @Config.Comment(value={"The list of slabs which should not be able to be placed vertically"})
    @Config.LangKey(value="config.doubleslabs.vertical_slab_blacklist")
    public static String[] VERTICAL_SLAB_BLACKLIST = new String[0];

    public static String slabToString(IBlockState state) {
        if (state == null) {
            return "null";
        }
        Block block = state.func_177230_c();
        if (state.func_177230_c().getRegistryName() == null) {
            return "";
        }
        if (block instanceof BlockSlab) {
            BlockSlab slab = (BlockSlab)block;
            try {
                if (slab.func_176551_l() == BlockSlab.field_176554_a || slab.func_176551_l() == null) {
                    return state.func_177230_c().getRegistryName().toString();
                }
                return state.func_177230_c().getRegistryName().toString() + (slab.func_176551_l().func_177700_c().size() == 1 ? "" : "#" + slab.func_176551_l().func_177701_a() + "=" + state.func_177229_b(slab.func_176551_l()).toString());
            }
            catch (Exception e) {
                return state.func_177230_c().getRegistryName().toString();
            }
        }
        return state.func_177230_c().getRegistryName().toString();
    }

    private static boolean isPresent(IBlockState state, String[] array) {
        String slabString = DoubleSlabsConfig.slabToString(state);
        if (slabString.length() == 0) {
            return false;
        }
        for (String entry : array) {
            if (!entry.equals(slabString)) continue;
            return true;
        }
        return false;
    }

    public static boolean useLazyModel(IBlockState state) {
        return DoubleSlabsConfig.isPresent(state, LAZY_VERTICAL_SLABS_ARRAY);
    }

    public static boolean shouldCull(IBlockState state) {
        return !DoubleSlabsConfig.isPresent(state, SLAB_CULL_BLACKLIST);
    }

    public static boolean isBlacklistedHorizontalSlab(IBlockState state) {
        return DoubleSlabsConfig.isPresent(state, SLAB_BLACKLIST_ARRAY);
    }

    public static boolean isBlacklistedVerticalSlab(IBlockState state) {
        return DoubleSlabsConfig.isPresent(state, VERTICAL_SLAB_BLACKLIST);
    }
}

