/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.patches.DynamicSurroundings;
import cjminecraft.doubleslabs.proxy.IProxy;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="DoubleSlabs", modid="doubleslabs", acceptedMinecraftVersions="[1.12,1.12.2]", updateJSON="https://raw.githubusercontent.com/CJMinecraft01/DoubleSlabs/1.12.x/update.json", useMetadata=true)
public class DoubleSlabs {
    public static final String NAME = "DoubleSlabs";
    public static final String MODID = "doubleslabs";
    public static final String ACCEPTED_MC_VERSIONS = "[1.12,1.12.2]";
    public static final String UPDATE_URL = "https://raw.githubusercontent.com/CJMinecraft01/DoubleSlabs/1.12.x/update.json";
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"DoubleSlabs");
    @SidedProxy(serverSide="cjminecraft.doubleslabs.proxy.ServerProxy", clientSide="cjminecraft.doubleslabs.proxy.ClientProxy")
    private static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        DynamicSurroundings.prepare();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        SlabSupport.init();
        ContainerSupport.init();
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equalsIgnoreCase("register")) continue;
            LOGGER.info("Received slab support registration from [{}] for class {}", (Object)message.getSender(), (Object)message.getStringValue());
            SlabSupport.addSupportFromIMC(message.getStringValue());
        }
    }
}

