/*
 * Decompiled with CFR 0.152.
 */
package valerate.simpleoresamples.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import valerate.simpleoresamples.Config;
import valerate.simpleoresamples.blocks.SampleBlock;

public class WorldGen
implements IWorldGenerator {
    public static HashMap<IBlockState, SampleBlock> SAMPLES = new HashMap();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!Config.dimension_whitelist.contains(world.field_73011_w.getDimension()) || Config.samplesPerOrePerChunk == 0) {
            return;
        }
        HashMap<SampleBlock, Integer> counter = this.scanChunk(world.func_72964_e(chunkX, chunkZ));
        for (Map.Entry<SampleBlock, Integer> entry : counter.entrySet()) {
            int samples = Config.oreCounterEnabled ? Math.min(entry.getValue() / Config.oresPerSample, Config.samplesPerOrePerChunk) : Config.samplesPerOrePerChunk;
            for (int i = 0; i < samples; ++i) {
                if (!(random.nextFloat() < Config.oreSampleChance)) continue;
                int x = (chunkX << 4) + random.nextInt(16);
                int z = (chunkZ << 4) + random.nextInt(16);
                entry.getKey().placeSample(world, x, z);
            }
        }
    }

    public HashMap<SampleBlock, Integer> scanChunk(Chunk chunk) {
        HashMap<SampleBlock, Integer> counter = new HashMap<SampleBlock, Integer>();
        for (int i = 1; i <= 256; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    SampleBlock sample;
                    IBlockState bs = chunk.func_186032_a(j, i, k);
                    Block b = bs.func_177230_c();
                    if (b == Blocks.field_150350_a || b == Blocks.field_150348_b || b == Blocks.field_150346_d || b == Blocks.field_150351_n || (sample = SAMPLES.get(bs)) == null) continue;
                    Integer count = counter.get(sample);
                    if (count != null) {
                        if (!Config.oreCounterEnabled) continue;
                        counter.put(sample, count + 1);
                        continue;
                    }
                    counter.put(sample, 1);
                }
            }
        }
        return counter;
    }
}

