/*
 * Decompiled with CFR 0.152.
 */
package valerate.simpleoresamples.world;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import valerate.simpleoresamples.blocks.SampleBlock;
import valerate.simpleoresamples.init.BlockInit;
import valerate.simpleoresamples.world.WorldGen;

public class OreDict {
    public static void init() {
        Map<String, String[]> dropRemap = BlockInit.getDropRemap();
        for (SampleBlock sample : BlockInit.SAMPLEBLOCKS.values()) {
            String[] aliases = dropRemap.get(sample.getOredictBase().toLowerCase());
            if (aliases == null) {
                OreDict.registerOre(sample.getOredict(), sample);
                continue;
            }
            for (String alias : aliases) {
                OreDict.registerOre(sample.getOredictPrefix() + alias, sample);
            }
        }
    }

    public static void registerOre(String name, SampleBlock sample) {
        for (ItemStack stack : OreDictionary.getOres((String)name, (boolean)false)) {
            ImmutableList states;
            Block b = Block.func_149634_a((Item)stack.func_77973_b());
            if (b == Blocks.field_150350_a) continue;
            int meta = stack.func_77952_i();
            if (meta >= (states = b.func_176194_O().func_177619_a()).size()) {
                meta = 0;
            }
            IBlockState bs = (IBlockState)states.get(meta);
            WorldGen.SAMPLES.put(bs, sample);
        }
    }
}

