/*
 * Decompiled with CFR 0.152.
 */
package valerate.simpleoresamples.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import valerate.simpleoresamples.Config;
import valerate.simpleoresamples.SimpleOreSamples;
import valerate.simpleoresamples.blocks.SampleBlock;
import valerate.simpleoresamples.blocks.SampleBlockGem;
import valerate.simpleoresamples.blocks.SampleBlockOre;

public class BlockInit {
    public static final HashMap<String, SampleBlock> SAMPLEBLOCKS = new HashMap();
    private static final String[][] dropAliases = new String[][]{{"Aluminium", "Aluminum", "Bauxite"}, {"Uranium", "Yellorite"}, {"Titanium", "Rutile"}};
    private static final HashMap<String, String[]> dropRemap = new HashMap();

    public static void readConfig() {
        ArrayList<String> failed = new ArrayList<String>();
        Config.oresToMakeSampleOf.forEach(str -> {
            String[] txt = str.split("\\|");
            if (txt.length < 2) {
                failed.add((String)str);
                return;
            }
            if (txt[2].equals("ore")) {
                try {
                    SAMPLEBLOCKS.put(txt[0], new SampleBlockOre("sampleblock" + txt[0], txt[0], Integer.parseInt(txt[1]), txt.length == 4 ? txt[3] : "empty"));
                }
                catch (Exception e) {
                    failed.add((String)str);
                }
            } else if (txt[2].equals("gem")) {
                try {
                    SAMPLEBLOCKS.put(txt[0], new SampleBlockGem("sampleblock" + txt[0], txt[0], Integer.parseInt(txt[1]), txt.length == 4 ? txt[3] : "empty"));
                }
                catch (Exception e) {
                    failed.add((String)str);
                }
            } else {
                failed.add((String)str);
            }
        });
        SimpleOreSamples.LOGGER.warn("Sucsesfully made sample block of {}/{} ore samples", (Object)SAMPLEBLOCKS.size(), (Object)Config.oresToMakeSampleOf.size());
        if (!failed.isEmpty()) {
            SimpleOreSamples.LOGGER.warn("Failed to create a sample blocks for: ");
            failed.forEach(str -> SimpleOreSamples.LOGGER.warn(" <{}>", str));
        }
    }

    public static Map<String, String[]> getDropRemap() {
        return dropRemap;
    }

    private static ItemStack getOredictOrEmpty(String oredictEntry) {
        NonNullList ores = OreDictionary.getOres((String)oredictEntry, (boolean)false);
        if (!ores.isEmpty()) {
            return (ItemStack)ores.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public static void fixDrops() {
        SAMPLEBLOCKS.values().forEach(sample -> {
            String dropType = sample.getDropType();
            ItemStack drop = ItemStack.field_190927_a;
            if (dropType.equals("empty")) {
                SimpleOreSamples.LOGGER.info("No drop configured for {}", (Object)sample.getOredict());
            } else {
                String[] aliases = dropRemap.get(sample.getOredictBase().toLowerCase());
                if (aliases == null) {
                    drop = BlockInit.getOredictOrEmpty(dropType + sample.getOredictBase());
                } else {
                    for (String alias : aliases) {
                        drop = BlockInit.getOredictOrEmpty(dropType + alias);
                        if (drop != ItemStack.field_190927_a) break;
                    }
                }
                if (drop == ItemStack.field_190927_a) {
                    String[] str = dropType.split(":", 3);
                    int end = str.length - 1;
                    short damage = 0;
                    try {
                        damage = Short.parseShort(str[end]);
                        --end;
                    }
                    catch (NumberFormatException alias) {
                        // empty catch block
                    }
                    String mod = end < 1 ? "minecraft" : str[0];
                    String item = str[end];
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74778_a("id", mod + ":" + item);
                    compound.func_74774_a("Count", (byte)1);
                    compound.func_74777_a("Damage", damage);
                    drop = new ItemStack(compound);
                }
            }
            if (drop == ItemStack.field_190927_a) {
                SimpleOreSamples.LOGGER.info("No drop found for {} , with type <{}>", (Object)sample.getOredict(), (Object)dropType);
            }
            sample.setDrop(drop);
        });
    }

    static {
        String[][] stringArray = dropAliases;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] aliasList;
            for (String alias : aliasList = stringArray[i]) {
                dropRemap.put(alias.toLowerCase(), aliasList);
            }
        }
    }
}

