/*
 * Decompiled with CFR 0.152.
 */
package valerate.simpleoresamples.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import valerate.simpleoresamples.SimpleOreSamples;
import valerate.simpleoresamples.blocks.item.ItemBlockVariants;
import valerate.simpleoresamples.init.ItemInit;
import valerate.simpleoresamples.util.IHasModel;

public abstract class SampleBlock
extends Block
implements IHasModel {
    public static final AxisAlignedBB SampleBlockAABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
    private int color;
    private String oredictPrefix;
    private String oredictBase;
    private ItemStack drop;
    private String dropType;
    private String blockRenderFile;

    public SampleBlock(String name, String oredictPrefix, String oredictBase, int color, String dropType, String blockRenderFile) {
        super(Material.field_151578_c);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(2.0f);
        this.color = color;
        this.oredictPrefix = oredictPrefix;
        this.oredictBase = oredictBase;
        this.dropType = dropType;
        this.blockRenderFile = blockRenderFile;
        ItemInit.ITEMS.add((Item)new ItemBlockVariants(this).setRegistryName(this.getRegistryName()));
    }

    public void setDrop(ItemStack drop) {
        this.drop = drop;
    }

    public String getDropType() {
        return this.dropType;
    }

    public String getOredict() {
        return this.oredictPrefix + this.oredictBase;
    }

    public String getOredictPrefix() {
        return this.oredictPrefix;
    }

    public String getOredictBase() {
        return this.oredictBase;
    }

    public ItemStack getOreItemStack() {
        NonNullList items = OreDictionary.getOres((String)this.getOredict(), (boolean)false);
        if (!items.isEmpty()) {
            return (ItemStack)items.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public int getColor() {
        return this.color;
    }

    public void placeSample(World world, int x, int z) {
        Block surfaceBlock;
        BlockPos surface = world.func_175672_r(new BlockPos(x, 64, z));
        if (surface.func_177956_o() > 1 && surface.func_177956_o() < 255 && !((surfaceBlock = world.func_180495_p(surface).func_177230_c()) instanceof BlockLiquid) && surfaceBlock.func_176200_f((IBlockAccess)world, surface) && this.func_176196_c(world, surface)) {
            world.func_175656_a(surface, this.func_176223_P());
        }
    }

    @Override
    public void registerModels() {
        SimpleOreSamples.proxy.registerBlockRenderer(this, this.blockRenderFile);
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SampleBlockAABB;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.drop.func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return this.drop.func_77952_i();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class ColorHandler
    implements IBlockColor,
    IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            return ((ItemBlockVariants)stack.func_77973_b()).getBlock().getColor();
        }

        public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
            return tintIndex == 0 ? -1 : ((SampleBlock)state.func_177230_c()).getColor();
        }
    }
}

