/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.resources;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IconRegistry {
    private final Set<ResourceLocation> resources = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, TextureAtlasSprite> icons = new HashMap<ResourceLocation, TextureAtlasSprite>();

    public void registerIcon(ResourceLocation location) {
        if (location != null && !this.resources.contains(location)) {
            this.resources.add(location);
        }
    }

    public TextureAtlasSprite getIcon(ResourceLocation location) {
        if (location == null) {
            return null;
        }
        TextureAtlasSprite icon = this.icons.get(location);
        if (icon != null) {
            return icon;
        }
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
    }

    public void loadIcons(TextureMap iconRegistry) {
        for (ResourceLocation resourcelocation : this.resources) {
            TextureAtlasSprite textureatlassprite = iconRegistry.func_174942_a(resourcelocation);
            this.icons.put(resourcelocation, textureatlassprite);
        }
    }
}

