/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.util;

import com.mcmoddev.basemetals.init.Fluids;
import com.mcmoddev.basemetals.init.Materials;
import com.mcmoddev.basemetals.properties.AdamantineProperty;
import com.mcmoddev.basemetals.properties.AdamantineToolProperty;
import com.mcmoddev.basemetals.properties.AquariumProperty;
import com.mcmoddev.basemetals.properties.AquariumToolProperty;
import com.mcmoddev.basemetals.properties.ColdIronProperty;
import com.mcmoddev.basemetals.properties.ColdIronToolProperty;
import com.mcmoddev.basemetals.properties.LeadProperty;
import com.mcmoddev.basemetals.properties.MithrilProperty;
import com.mcmoddev.basemetals.properties.MithrilToolProperty;
import com.mcmoddev.basemetals.properties.StarSteelProperty;
import com.mcmoddev.lib.events.MMDLibRegisterFluids;
import com.mcmoddev.lib.events.MMDLibRegisterMaterialProperties;
import com.mcmoddev.lib.events.MMDLibRegisterMaterials;
import com.mcmoddev.lib.item.ItemMMDShield;
import com.mcmoddev.lib.properties.MMDMaterialPropertyBase;
import com.mcmoddev.lib.recipe.ShieldUpgradeRecipe;
import com.mcmoddev.lib.util.Config;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public final class EventHandler {
    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        float damage = event.getAmount();
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ItemStack activeItemStack = player.func_184607_cu();
        if (activeItemStack.func_190926_b()) {
            return;
        }
        if (damage > 0.0f && activeItemStack.func_77973_b() instanceof ItemMMDShield) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            activeItemStack.func_77972_a(i, (EntityLivingBase)player);
            if (activeItemStack.func_190916_E() <= 0) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)activeItemStack, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                    player.func_184185_a(SoundEvents.field_187677_b, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }

    @Nonnull
    public static InventoryCrafting getDummyCraftingInv() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        };
        return new InventoryCrafting(tempContainer, 2, 1);
    }

    @SubscribeEvent
    public static void handleAnvilEvent(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b() || left.func_190916_E() != 1 || right.func_190916_E() != 1) {
            return;
        }
        InventoryCrafting recipeInput = EventHandler.getDummyCraftingInv();
        recipeInput.func_70299_a(0, left);
        recipeInput.func_70299_a(1, right);
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)recipeInput, null);
        if (recipe instanceof ShieldUpgradeRecipe && ((ShieldUpgradeRecipe)recipe).func_77569_a(recipeInput, null)) {
            event.setOutput(recipe.func_77572_b(recipeInput));
            event.setCost(((ShieldUpgradeRecipe)recipe).getCost(recipeInput));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onUpdate(TickEvent.RenderTickEvent event) {
        if (Config.Options.requireMMDOreSpawn() && Loader.isModLoaded((String)"orespawn")) {
            return;
        }
        if (!Config.Options.fallbackOrespawn()) {
            return;
        }
        if (!Config.Options.requireMMDOreSpawn()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiScreen guiscreen = minecraft.field_71462_r;
        if (guiscreen == null) {
            return;
        }
        FontRenderer fontRender = minecraft.field_71466_p;
        int y = guiscreen.field_146295_m / 100 * 2;
        int x = guiscreen.field_146294_l / 2;
        if (guiscreen instanceof GuiMainMenu) {
            guiscreen.func_73732_a(fontRender, "MMD OreSpawn not present, but requested in configuration, using fallback generator!", x, y, -256);
        } else if (guiscreen instanceof GuiWorldSelection) {
            x = 10;
            int widest = fontRender.func_78256_a("This is likely not what you want - try turning off the 'using_orespawn' option");
            int shortest = fontRender.func_78256_a("Fallback Ore Spawn Generator Enabled!");
            int wrap = widest + 50;
            if (guiscreen.field_146294_l / 2 <= wrap) {
                wrap = shortest + 50;
            }
            fontRender.func_78279_b("Fallback Ore Spawn Generator Enabled!\nThis is likely not what you want - try turning off the 'using_orespawn' option\n(or install MMD OreSpawn)", x, y, wrap, -256);
        }
    }

    @SubscribeEvent
    public static void mmdlibRegisterMaterials(MMDLibRegisterMaterials event) {
        Materials.init(event);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Materials.initTooltips();
        }
    }

    @SubscribeEvent
    public static void mmdlibRegisterFluids(MMDLibRegisterFluids event) {
        Fluids.registerEvent(event);
    }

    @SubscribeEvent
    public static void mmdlibRegisterMaterialProperies(MMDLibRegisterMaterialProperties event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new MMDMaterialPropertyBase[]{(MMDMaterialPropertyBase)new StarSteelProperty().setRegistryName("basemetals:moon_jump"), (MMDMaterialPropertyBase)new LeadProperty().setRegistryName("basemetals:slowdown"), (MMDMaterialPropertyBase)new AdamantineProperty().setRegistryName("basemetals:resistance_is_futile"), (MMDMaterialPropertyBase)new ColdIronProperty().setRegistryName("basemetals:swim_in_lava"), (MMDMaterialPropertyBase)new MithrilProperty().setRegistryName("basemetals:clear_effects"), (MMDMaterialPropertyBase)new AquariumProperty().setRegistryName("basemetals:the_abyss_was_better"), (MMDMaterialPropertyBase)new AdamantineToolProperty().setRegistryName("basemetals:heavy_damage"), (MMDMaterialPropertyBase)new ColdIronToolProperty().setRegistryName("basemetals:cold_as_ice"), (MMDMaterialPropertyBase)new MithrilToolProperty().setRegistryName("basemetals:holy_roller"), (MMDMaterialPropertyBase)new AquariumToolProperty().setRegistryName("basemetals:drown_bitca")});
    }
}

